BEGIN;

ALTER TABLE entity_status ADD COLUMN searchable_status char(1) DEFAULT ('f') NOT NULL;
ALTER TABLE entity_status ADD COLUMN archived_status char(1) DEFAULT ('f') NOT NULL;

-- insert current status for the old release process
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status) 
    SELECT nextval('entity_status_seq'), 'DRAFT', e.entity_type, 't','f','f' FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id GROUP BY e.entity_type;
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
    SELECT nextval('entity_status_seq'), 'IN_REVIEW', e.entity_type, 'f','f','f' FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id GROUP BY e.entity_type;
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
    SELECT nextval('entity_status_seq'), 'DECLINED', e.entity_type, 'f','f','f' FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id GROUP BY e.entity_type;
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
    SELECT nextval('entity_status_seq'), 'RELEASED', e.entity_type, 'f','f','f' FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id GROUP BY e.entity_type;
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
    SELECT nextval('entity_status_seq'), 'PUBLISHED', e.entity_type, 'f','t','f' FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id GROUP BY e.entity_type;
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
    SELECT nextval('entity_status_seq'), 'ARCHIVED', e.entity_type, 'f','t','t' FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id GROUP BY e.entity_type;

-- insert default status for all entities without entity-versions
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status) 
SELECT nextval('entity_status_seq'), 'DEFAULT', name, 't','t','f' FROM entity_type_name WHERE name IN (
    SELECT e.name from entity_type_name e LEFT JOIN entity_status s on e.name = s.entity_type WHERE s.status_name IS NULL
);

-- create id-reference to entity_status
ALTER TABLE entity_version ADD COLUMN entity_status_id  BIGINT NULL;
ALTER TABLE entity_version ADD CONSTRAINT entity_version_status_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id);


-- set id for current versions
UPDATE entity_version SET entity_status_id=status.status_id FROM (
    SELECT v.id as version_id, s.id as status_id FROM entity_version v 
    INNER JOIN entity_status s ON v.version_status = s.status_name 
    INNER JOIN entity e ON v.entity_id=e.id AND e.entity_type=s.entity_type
) AS status WHERE status.version_id=entity_version.id;

-- update entity_status_id to NOT NULL
ALTER TABLE entity_version ALTER COLUMN entity_status_id SET NOT NULL;

--shadow table
ALTER TABLE sh_entity_version ADD COLUMN entity_status_id  BIGINT NULL;
    
COMMIT;
