BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00006, '7.9', '00006_#patch_migrate_link_attachments', 'FEATURE', '#8699 - Link-Anhänge in eigener Link-Tabelle statt in workstream_entry_attribute speichern', now());

CREATE OR REPLACE FUNCTION migrate_links() RETURNS VOID AS
$BODY$
DECLARE
    entry_attribute RECORD;
    new_link_id BIGINT;
    link_url varchar;
    link_title varchar;
BEGIN
    -- iterate over all url attributes
    FOR entry_attribute IN SELECT entry_id, key, value FROM workstream_entry_attribute WHERE key = 'link_url' LOOP
        -- get the correspondig link title for the current url
        SELECT value INTO link_title FROM workstream_entry_attribute WHERE entry_id = entry_attribute.entry_id AND key = 'link_title';
        link_url = entry_attribute.value;
        
        -- create new entry in link table
        INSERT INTO link (id, url, title, create_date) VALUES (nextval('link_seq'), link_url, link_title, clock_timestamp()) RETURNING id INTO new_link_id;
        -- create attachment for the new link
        INSERT INTO workstream_attachment (entry_id, item_id, item_type, position) VALUES (entry_attribute.entry_id, new_link_id, 'LINK', 0);
        -- remove attributes that contain link-related data. Keep the attribute's (microblog posting) text
        DELETE FROM workstream_entry_attribute
        WHERE entry_id = entry_attribute.entry_id AND
        (workstream_entry_attribute.key = 'link_title' OR workstream_entry_attribute.key = 'link_url');
    END LOOP;
END;
$BODY$
    LANGUAGE plpgsql;
    SELECT migrate_links();
    DROP FUNCTION migrate_links();
COMMIT;