BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00001, '7.6', '00001_#patch_unique_person_primary_network.sql', 'BUGFIX', '#5104: Duplikate bei primären Netzwerken', now());

-- first delete duplicate entries for each person by adding a column
CREATE SEQUENCE person_primary_network_seq;
ALTER TABLE person_primary_network ADD helper NUMERIC(16,0) DEFAULT NEXTVAL('person_primary_network_seq');
DELETE FROM person_primary_network n1 WHERE n1.helper > ( SELECT MIN(n2.helper) FROM  person_primary_network n2 WHERE n1.person_id = n2.person_id );
ALTER TABLE person_primary_network DROP COLUMN helper;
DROP SEQUENCE person_primary_network_seq;

-- add unique constraints for person and (person, network)
ALTER TABLE person_primary_network ADD CONSTRAINT p_p_n__person_uq UNIQUE(person_id);

COMMIT;
