BEGIN;

INSERT INTO version (
  id, "release", name, "type", description, "date"
) VALUES (
  01314, '6.13', '01314_6.13_create_multiwiki_tables.sql', 'FEATURE', '#4453 Basis des Mehrfacheditoren-Moduls', now()
);

CREATE SEQUENCE multi_wiki_seq
    START WITH 1
    INCREMENT BY 1;

CREATE TABLE multi_wiki (
    id BIGINT PRIMARY KEY NOT NULL,
    parent_item_id BIGINT NOT NULL,
    parent_item_type VARCHAR NOT NULL,
    create_date timestamp without time zone NOT NULL DEFAULT clock_timestamp(),
    modify_date timestamp without time zone NOT NULL DEFAULT clock_timestamp(),
    CONSTRAINT multi_wiki_parent_unq UNIQUE (parent_item_id, parent_item_type)
);

CREATE SEQUENCE multi_wiki_version_seq
    START WITH 1
    INCREMENT BY 1;

CREATE TABLE multi_wiki_version (
    id BIGINT PRIMARY KEY NOT NULL,
    wiki_id BIGINT NOT NULL REFERENCES multi_wiki(id) ON DELETE CASCADE,
    create_date timestamp without time zone NOT NULL DEFAULT clock_timestamp(),
    modify_date timestamp without time zone NOT NULL DEFAULT clock_timestamp()
);

CREATE SEQUENCE multi_wiki_section_seq
    START WITH 1
    INCREMENT BY 1;

CREATE TABLE multi_wiki_section (
    id BIGINT PRIMARY KEY NOT NULL,
    version_id BIGINT NOT NULL REFERENCES multi_wiki_version(id) ON DELETE CASCADE,
    headline VARCHAR NOT NULL,
    html TEXT NOT NULL,
    create_date timestamp without time zone NOT NULL DEFAULT clock_timestamp(),
    modify_date timestamp without time zone NOT NULL DEFAULT clock_timestamp()
);


COMMIT;
