BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01243, '6.5', '01243-6.5-B-migrate_workstream_filter.sql', 'BUGFIX', 'fixes #2590  migration of workstream filter settings', now());

insert into base_property (id, property_name, converter_class, description, default_value, container_name, create_at, last_changed, inheritance_type)
    select nextval('seq_base_property') as id,
    'Settings/Workstream/Default workstream filter profile' as property_name, 'com.freiheit.superoperty.converter.SimpleStringConverter' as converter_class,
    'Defines which filter is set per default when a workstream is displayed on a profile page. Possible values are: ALL, MICROBLOG, FEED' as description,
default_value as default_value,
    'systemSettings' as container_name,
    now() as create_at,
    now() as last_changed,
    'F' as inheritance_type
    from base_property where property_name = 'Settings/Workstream/Default workstream filter start'
    and 0 in (select count(*) from base_property where property_name = 'Settings/Workstream/Default workstream filter profile');

insert into base_property (id, property_name, converter_class, description, default_value, container_name, create_at, last_changed, inheritance_type)
    select nextval('seq_base_property') as id,
    'Settings/Workstream/Default workstream filter entity' as property_name,
    'com.freiheit.superoperty.converter.SimpleStringConverter' as converter_class,
    'Defines which filter is set per default when a workstream is displayed on an entity page. Possible values are: ALL, MICROBLOG, FEED' as description,
default_value as default_value,
    'systemSettings' as container_name,
    now() as create_at,
    now() as last_changed,
    'F' as inheritance_type
    from base_property where property_name = 'Settings/Workstream/Default workstream filter start'
    and 0 in (select count(*) from base_property where property_name = 'Settings/Workstream/Default workstream filter entity');

COMMIT;
