/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.apache.commons.dbutils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanProcessor {
    protected static final int PROPERTY_NOT_FOUND = -1;
    private static final Map primitiveDefaults = new HashMap();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public Object toBean(ResultSet rs, Class type) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        return this.createBean(rs, type, props, columnToProperty);
    }

    public List toBeanList(ResultSet rs, Class type) throws SQLException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (!rs.next()) {
            return results;
        }
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        do {
            results.add(this.createBean(rs, type, props, columnToProperty));
        } while (rs.next());
        return results;
    }

    private Object createBean(ResultSet rs, Class type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        Object bean = this.newInstance(type);
        for (int i = 1; i < columnToProperty.length; ++i) {
            if (columnToProperty[i] == -1) continue;
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<?> propType = prop.getPropertyType();
            Object value = this.processColumn(rs, i, propType);
            if (propType != null && value == null && propType.isPrimitive()) {
                value = primitiveDefaults.get(propType);
            }
            this.callSetter(bean, prop, value);
        }
        return bean;
    }

    private void callSetter(Object target, PropertyDescriptor prop, Object value) throws SQLException {
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            return;
        }
        Class<?>[] params = setter.getParameterTypes();
        try {
            if (value != null && value instanceof java.util.Date) {
                if (params[0].getName().equals("java.sql.Date")) {
                    value = new Date(((java.util.Date)value).getTime());
                } else if (params[0].getName().equals("java.sql.Time")) {
                    value = new Time(((java.util.Date)value).getTime());
                } else if (params[0].getName().equals("java.sql.Timestamp")) {
                    value = new Timestamp(((java.util.Date)value).getTime());
                }
            }
            if (!this.isCompatibleType(value, params[0])) {
                throw new SQLException("Cannot set " + prop.getName() + ": incompatible types.");
            }
            setter.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
    }

    private boolean isCompatibleType(Object value, Class type) {
        if (value == null || type.isInstance(value)) {
            return true;
        }
        if (type.equals(Integer.TYPE) && (class$java$lang$Integer == null ? (class$java$lang$Integer = BeanProcessor.class$("java.lang.Integer")) : class$java$lang$Integer).isInstance(value)) {
            return true;
        }
        if (type.equals(Long.TYPE) && (class$java$lang$Long == null ? (class$java$lang$Long = BeanProcessor.class$("java.lang.Long")) : class$java$lang$Long).isInstance(value)) {
            return true;
        }
        if (type.equals(Double.TYPE) && (class$java$lang$Double == null ? (class$java$lang$Double = BeanProcessor.class$("java.lang.Double")) : class$java$lang$Double).isInstance(value)) {
            return true;
        }
        if (type.equals(Float.TYPE) && (class$java$lang$Float == null ? (class$java$lang$Float = BeanProcessor.class$("java.lang.Float")) : class$java$lang$Float).isInstance(value)) {
            return true;
        }
        if (type.equals(Short.TYPE) && (class$java$lang$Short == null ? (class$java$lang$Short = BeanProcessor.class$("java.lang.Short")) : class$java$lang$Short).isInstance(value)) {
            return true;
        }
        if (type.equals(Byte.TYPE) && (class$java$lang$Byte == null ? (class$java$lang$Byte = BeanProcessor.class$("java.lang.Byte")) : class$java$lang$Byte).isInstance(value)) {
            return true;
        }
        if (type.equals(Character.TYPE) && (class$java$lang$Character == null ? (class$java$lang$Character = BeanProcessor.class$("java.lang.Character")) : class$java$lang$Character).isInstance(value)) {
            return true;
        }
        return type.equals(Boolean.TYPE) && (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanProcessor.class$("java.lang.Boolean")) : class$java$lang$Boolean).isInstance(value);
    }

    protected Object newInstance(Class c) throws SQLException {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class c) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String columnName = rsmd.getColumnName(col);
            for (int i = 0; i < props.length; ++i) {
                if (!columnName.equalsIgnoreCase(props[i].getName())) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }

    protected Object processColumn(ResultSet rs, int index, Class propType) throws SQLException {
        if (propType.equals(class$java$lang$String == null ? (class$java$lang$String = BeanProcessor.class$("java.lang.String")) : class$java$lang$String)) {
            return rs.getString(index);
        }
        if (propType.equals(Integer.TYPE) || propType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanProcessor.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(rs.getInt(index));
        }
        if (propType.equals(Boolean.TYPE) || propType.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanProcessor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(rs.getBoolean(index));
        }
        if (propType.equals(Long.TYPE) || propType.equals(class$java$lang$Long == null ? (class$java$lang$Long = BeanProcessor.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(rs.getLong(index));
        }
        if (propType.equals(Double.TYPE) || propType.equals(class$java$lang$Double == null ? (class$java$lang$Double = BeanProcessor.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(rs.getDouble(index));
        }
        if (propType.equals(Float.TYPE) || propType.equals(class$java$lang$Float == null ? (class$java$lang$Float = BeanProcessor.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(rs.getFloat(index));
        }
        if (propType.equals(Short.TYPE) || propType.equals(class$java$lang$Short == null ? (class$java$lang$Short = BeanProcessor.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(rs.getShort(index));
        }
        if (propType.equals(Byte.TYPE) || propType.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanProcessor.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(rs.getByte(index));
        }
        if (propType.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = BeanProcessor.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return rs.getTimestamp(index);
        }
        return rs.getObject(index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveDefaults.put(Integer.TYPE, new Integer(0));
        primitiveDefaults.put(Short.TYPE, new Short(0));
        primitiveDefaults.put(Byte.TYPE, new Byte(0));
        primitiveDefaults.put(Float.TYPE, new Float(0.0f));
        primitiveDefaults.put(Double.TYPE, new Double(0.0));
        primitiveDefaults.put(Long.TYPE, new Long(0L));
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Character.TYPE, new Character('\u0000'));
    }
}

