/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.clean;

import java.util.HashSet;
import java.util.Set;
import org.dbmaintain.config.FactoryWithDatabase;
import org.dbmaintain.structure.clean.DBCleaner;
import org.dbmaintain.structure.clean.impl.DefaultDBCleaner;
import org.dbmaintain.structure.model.DbItemIdentifier;
import org.dbmaintain.structure.model.DbItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCleanerFactory
extends FactoryWithDatabase<DBCleaner> {
    @Override
    public DBCleaner createInstance() {
        Set<DbItemIdentifier> itemsToPreserve = this.getItemsToPreserve();
        return new DefaultDBCleaner(this.getDatabases(), itemsToPreserve, this.getSqlHandler());
    }

    protected Set<DbItemIdentifier> getItemsToPreserve() {
        DbItemIdentifier executedScriptsTable = this.factoryWithDatabaseContext.getExecutedScriptsTable();
        HashSet<DbItemIdentifier> itemsToPreserve = new HashSet<DbItemIdentifier>();
        itemsToPreserve.add(executedScriptsTable);
        itemsToPreserve.addAll(this.factoryWithDatabaseContext.getSchemasToPreserve("dbMaintainer.preserve.schemas"));
        itemsToPreserve.addAll(this.factoryWithDatabaseContext.getSchemasToPreserve("dbMaintainer.preserveDataOnly.schemas"));
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.TABLE, "dbMaintainer.preserve.tables", itemsToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.TABLE, "dbMaintainer.preserveDataOnly.tables", itemsToPreserve);
        return itemsToPreserve;
    }
}

