/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.runner.impl;

import java.io.File;
import java.io.IOException;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseInfo;
import org.dbmaintain.database.Databases;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.runner.impl.Application;
import org.dbmaintain.script.runner.impl.BaseNativeScriptRunner;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.FileUtils;
import thirdparty.org.apache.commons.lang.StringUtils;

public class SqlPlusScriptRunner
extends BaseNativeScriptRunner {
    protected Application application;
    protected String sqlPlusCommand;

    public SqlPlusScriptRunner(Databases databases, String sqlPlusCommand) {
        super(databases);
        this.sqlPlusCommand = sqlPlusCommand;
        this.application = this.createApplication(sqlPlusCommand);
    }

    protected void executeScript(File scriptFile, Database targetDatabase) throws Exception {
        File wrapperScriptFile = this.generateWrapperScriptFile(targetDatabase.getDatabaseInfo(), scriptFile);
        String[] arguments = new String[]{"/nolog", "@" + wrapperScriptFile.getPath()};
        Application.ProcessOutput processOutput = this.application.execute(arguments);
        int exitValue = processOutput.getExitValue();
        if (exitValue != 0) {
            throw new DbMaintainException("Failed to execute command. SQL*Plus returned an error.\n" + processOutput.getOutput());
        }
    }

    protected File generateWrapperScriptFile(DatabaseInfo databaseInfo, File targetScriptFile) throws IOException {
        File temporaryScriptsDir = this.createTemporaryScriptsDir();
        File temporaryScriptWrapperFile = new File(temporaryScriptsDir, "wrapper-" + System.currentTimeMillis() + targetScriptFile.getName());
        temporaryScriptWrapperFile.deleteOnExit();
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder content = new StringBuilder();
        content.append("set echo off");
        content.append(lineSeparator);
        content.append("whenever sqlerror exit sql.sqlcode rollback");
        content.append(lineSeparator);
        content.append("whenever oserror exit sql.sqlcode rollback");
        content.append(lineSeparator);
        content.append("connect ");
        content.append(databaseInfo.getUserName());
        content.append('/');
        content.append(databaseInfo.getPassword());
        content.append('@');
        content.append(this.getDatabaseConfigFromJdbcUrl(databaseInfo.getUrl()));
        content.append(lineSeparator);
        content.append("alter session set current_schema=");
        content.append(databaseInfo.getDefaultSchemaName());
        content.append(";");
        content.append(lineSeparator);
        content.append("set echo on");
        content.append(lineSeparator);
        content.append("@@");
        content.append(targetScriptFile.getName());
        content.append(lineSeparator);
        content.append("exit sql.sqlcode");
        content.append(lineSeparator);
        FileUtils.createFile(temporaryScriptWrapperFile, content.toString());
        return temporaryScriptWrapperFile;
    }

    protected String getTemporaryScriptName(Script script) {
        String temporaryScriptName = super.getTemporaryScriptName(script);
        return StringUtils.deleteWhitespace(temporaryScriptName);
    }

    protected Application createApplication(String sqlPlusCommand) {
        return new Application("SQL*Plus", sqlPlusCommand);
    }

    protected String getDatabaseConfigFromJdbcUrl(String url) {
        int index = url.indexOf(64);
        if (index == -1) {
            return url;
        }
        return url.substring(index + 1);
    }
}

