/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.repository;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.ScriptContentHandle;
import org.dbmaintain.script.ScriptFactory;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.util.DbMaintainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptLocation {
    public static final String LOCATION_PROPERTIES_FILENAME = "META-INF/dbmaintain.properties";
    protected SortedSet<Script> scripts;
    protected String scriptEncoding;
    protected String postProcessingScriptDirName;
    protected Set<Qualifier> registeredQualifiers;
    protected Set<Qualifier> patchQualifiers;
    protected String scriptIndexRegexp;
    protected String qualifierRegexp;
    protected String targetDatabaseRegexp;
    protected Set<String> scriptFileExtensions;
    protected String scriptLocationName;
    protected ScriptIndexes baseLineRevision;
    protected boolean ignoreCarriageReturnsWhenCalculatingCheckSum;
    protected ScriptFactory scriptFactory;

    protected ScriptLocation(SortedSet<Script> scripts, String scriptEncoding, String postProcessingScriptDirName, Set<Qualifier> registeredQualifiers, Set<Qualifier> patchQualifiers, String scriptIndexRegexp, String qualifierRegexp, String targetDatabaseRegexp, Set<String> scriptFileExtensions, ScriptIndexes baseLineRevision, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
        this.scripts = scripts;
        this.scriptEncoding = scriptEncoding;
        this.postProcessingScriptDirName = postProcessingScriptDirName;
        this.registeredQualifiers = registeredQualifiers;
        this.patchQualifiers = patchQualifiers;
        this.scriptIndexRegexp = scriptIndexRegexp;
        this.qualifierRegexp = qualifierRegexp;
        this.targetDatabaseRegexp = targetDatabaseRegexp;
        this.scriptFileExtensions = scriptFileExtensions;
        this.scriptLocationName = "<undefined>";
        this.baseLineRevision = baseLineRevision;
        this.ignoreCarriageReturnsWhenCalculatingCheckSum = ignoreCarriageReturnsWhenCalculatingCheckSum;
        this.scriptFactory = this.createScriptFactory();
    }

    protected ScriptLocation(File scriptLocation, String defaultScriptEncoding, String defaultPostProcessingScriptDirName, Set<Qualifier> defaultRegisteredQualifiers, Set<Qualifier> defaultPatchQualifiers, String defaultScriptIndexRegexp, String defaultQualifierRegexp, String defaultTargetDatabaseRegexp, Set<String> defaultScriptFileExtensions, ScriptIndexes defaultBaseLineRevision, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
        this.assertValidScriptLocation(scriptLocation);
        this.scriptEncoding = defaultScriptEncoding;
        this.postProcessingScriptDirName = defaultPostProcessingScriptDirName;
        this.registeredQualifiers = defaultRegisteredQualifiers;
        this.patchQualifiers = defaultPatchQualifiers;
        this.scriptIndexRegexp = defaultScriptIndexRegexp;
        this.qualifierRegexp = defaultQualifierRegexp;
        this.targetDatabaseRegexp = defaultTargetDatabaseRegexp;
        this.scriptFileExtensions = defaultScriptFileExtensions;
        this.baseLineRevision = defaultBaseLineRevision;
        this.ignoreCarriageReturnsWhenCalculatingCheckSum = ignoreCarriageReturnsWhenCalculatingCheckSum;
        Properties customProperties = this.getCustomProperties(scriptLocation);
        this.overrideValuesWithCustomConfiguration(customProperties);
        this.scriptLocationName = scriptLocation.getAbsolutePath();
        this.scriptFactory = this.createScriptFactory();
        this.scripts = this.loadScripts(scriptLocation);
    }

    protected abstract SortedSet<Script> loadScripts(File var1);

    protected Properties getCustomProperties(File scriptLocation) {
        return null;
    }

    protected abstract void assertValidScriptLocation(File var1);

    public String getLocationName() {
        return this.scriptLocationName;
    }

    public String getScriptEncoding() {
        return this.scriptEncoding;
    }

    public String getPostProcessingScriptDirName() {
        return this.postProcessingScriptDirName;
    }

    public Set<Qualifier> getRegisteredQualifiers() {
        return this.registeredQualifiers;
    }

    public Set<Qualifier> getPatchQualifiers() {
        return this.patchQualifiers;
    }

    public String getQualifierRegexp() {
        return this.qualifierRegexp;
    }

    public String getTargetDatabaseRegexp() {
        return this.targetDatabaseRegexp;
    }

    public Set<String> getScriptFileExtensions() {
        return this.scriptFileExtensions;
    }

    public SortedSet<Script> getScripts() {
        return this.scripts;
    }

    protected void overrideValuesWithCustomConfiguration(Properties customProperties) {
        if (customProperties == null) {
            return;
        }
        if (customProperties.containsKey("dbMaintainer.script.encoding")) {
            this.scriptEncoding = PropertyUtils.getString("dbMaintainer.script.encoding", customProperties);
        }
        if (customProperties.containsKey("dbMaintainer.postProcessingScript.directoryName")) {
            this.postProcessingScriptDirName = PropertyUtils.getString("dbMaintainer.postProcessingScript.directoryName", customProperties);
        }
        if (customProperties.containsKey("dbMaintainer.qualifiers")) {
            this.registeredQualifiers = this.createQualifiers(PropertyUtils.getStringList("dbMaintainer.qualifiers", customProperties));
        }
        if (customProperties.containsKey("dbMaintainer.script.patch.qualifiers")) {
            this.patchQualifiers = this.createQualifiers(PropertyUtils.getStringList("dbMaintainer.script.patch.qualifiers", customProperties));
        }
        if (customProperties.containsKey("dbMaintainer.script.index.regexp")) {
            this.scriptIndexRegexp = PropertyUtils.getString("dbMaintainer.script.index.regexp", customProperties);
        }
        if (customProperties.containsKey("dbMaintainer.script.qualifier.regexp")) {
            this.qualifierRegexp = PropertyUtils.getString("dbMaintainer.script.qualifier.regexp", customProperties);
        }
        if (customProperties.containsKey("dbMaintainer.script.targetDatabase.regexp")) {
            this.targetDatabaseRegexp = PropertyUtils.getString("dbMaintainer.script.targetDatabase.regexp", customProperties);
        }
        if (customProperties.containsKey("dbMaintainer.script.fileExtensions")) {
            this.scriptFileExtensions = new HashSet<String>(PropertyUtils.getStringList("dbMaintainer.script.fileExtensions", customProperties));
        }
        if (customProperties.containsKey("dbMaintainer.baseline.revision")) {
            String baseLineRevisionString = PropertyUtils.getString("dbMaintainer.baseline.revision", customProperties);
            this.baseLineRevision = new ScriptIndexes(baseLineRevisionString);
        }
        if (customProperties.containsKey("dbMaintainer.script.ignoreCarriageReturnsWhenCalculatingCheckSum")) {
            this.ignoreCarriageReturnsWhenCalculatingCheckSum = PropertyUtils.getBoolean("dbMaintainer.script.ignoreCarriageReturnsWhenCalculatingCheckSum", customProperties);
        }
        this.assertValidScriptExtensions();
    }

    protected void assertValidScriptExtensions() {
        if (this.scriptFileExtensions.isEmpty()) {
            throw new DbMaintainException("No script file extensions specified!");
        }
        for (String extension : this.scriptFileExtensions) {
            if (!extension.startsWith(".")) continue;
            throw new DbMaintainException("Script file extension " + extension + " should not start with a '.'");
        }
    }

    protected boolean isScriptFileName(String fileName) {
        for (String scriptFileExtension : this.scriptFileExtensions) {
            if (!fileName.endsWith(scriptFileExtension)) continue;
            return true;
        }
        return false;
    }

    protected Set<Qualifier> createQualifiers(List<String> qualifierNames) {
        HashSet<Qualifier> qualifiers = new HashSet<Qualifier>();
        for (String qualifierName : qualifierNames) {
            qualifiers.add(new Qualifier(qualifierName));
        }
        return qualifiers;
    }

    protected ScriptFactory createScriptFactory() {
        return new ScriptFactory(this.scriptIndexRegexp, this.targetDatabaseRegexp, this.qualifierRegexp, this.registeredQualifiers, this.patchQualifiers, this.postProcessingScriptDirName, this.baseLineRevision);
    }

    protected Script createScript(String fileName, Long fileLastModifiedAt, ScriptContentHandle scriptContentHandle) {
        return this.scriptFactory.createScriptWithContent(fileName, fileLastModifiedAt, scriptContentHandle);
    }
}

