CREATE TABLE conversation_change (
    id number(19) NOT NULL PRIMARY KEY,
    conversation_id number(19) NOT NULL,
    participant_id number(19) NOT NULL,
    change_type varchar2(255 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT cchng_participant_id_fk FOREIGN KEY (participant_id) REFERENCES person (id) ON DELETE CASCADE,
    CONSTRAINT cchng_uq UNIQUE (conversation_id, participant_id, change_type)
);

CREATE SEQUENCE conversation_change_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE INDEX cchng_create_date_idx ON conversation_change (create_date);
CREATE INDEX cchng_prtcpnt_create_date_idx ON conversation_change (participant_id, create_date);

COMMIT;
