CREATE SEQUENCE profile_attribute_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;

CREATE TABLE profile_attribute (
    id number(19) NOT NULL,
    person_id number(19) NOT NULL,
    name varchar2(255 CHAR) NOT NULL,
    value clob NOT NULL,
    value_order number(10) NOT NULL,
    section_order number(10) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT profile_attribute_pk PRIMARY KEY (id),
    CONSTRAINT profile_attribute_pid_fk FOREIGN KEY (person_id) REFERENCES person (id)
);

CREATE TABLE sh_profile_attribute (
    id number(19),
    person_id number(19),
    name varchar2(255 CHAR),
    value clob,
    value_order number(10),
    section_order number(10),
    delete_action_id number(19),
    create_date timestamp,
    CONSTRAINT sh_prfl_attr_del_action_id_fk FOREIGN KEY (delete_action_id) REFERENCES delete_action (id)
);

INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PROFILE_ATTRIBUTE','SH_PROFILE_ATTRIBUTE','f');

COMMIT;