MERGE INTO conversation c
USING (
  SELECT conversation_id, LISTAGG(firstname || ' ' || surname, ', ') WITHIN GROUP (ORDER BY surname) title
  FROM (
    SELECT cp.conversation_id, p.firstname, p.surname 
    FROM person p 
    JOIN conversation_participant cp ON (cp.participant_id = p.id) 
    JOIN conversation c ON (cp.conversation_id = c.id)
    WHERE c.type = 'MULTI_USER_CHAT'
    AND (trim(both FROM c.title) = '' 
      OR c.title IS null
    )
  )
  GROUP BY conversation_id
) titles
ON (c.id = titles.conversation_id)
WHEN MATCHED THEN UPDATE
SET c.title = titles.title;

COMMIT;