create table subscriptions (
    subscriber_id number(19) references person(id) on delete cascade not null,
    item_id number(19) not null,
    item_type varchar2(32 char) not null,
    subscription_type varchar2(32 char) not null,
    subscription_state varchar2(32 char) not null,
    created_at timestamp not null,
    modified_at timestamp not null,
    constraint subscriptions_pkey primary key (item_id, item_type, subscriber_id)
);

create table sh_subscriptions (
    subscriber_id number(19),
    item_id number(19),
    item_type varchar2(32 char),
    subscription_type varchar2(32 char),
    subscription_state varchar2(32 char),
    created_at timestamp,
    modified_at timestamp,
    delete_action_id number(19, 0),
    foreign key (delete_action_id) references delete_action (id)
);

insert into shadow_table (table_name,shadow_table_name,delete_action_mandatory) values ('SUBSCRIPTIONS','SH_SUBSCRIPTIONS','f');

insert into subscriptions(
       subscriber_id,
       item_id,
       item_type,
       subscription_type,
       subscription_state,
       created_at,
       modified_at)
select
    subscriber_id,
    item_id,
    item_type,
    case when passive='t' then 'PASSIVE'
         else 'DEFAULT' end,
    'SUBSCRIBED',
    created_at,
    modified_at
from like_subscribe
where subscriber_id in (select id from person);

insert into subscriptions(
       subscriber_id,
       item_id,
       item_type,
       subscription_type,
       subscription_state,
       created_at,
       modified_at)
select
    unsubscriber_id,
    item_id,
    item_type,
    'DEFAULT',
    'UNSUBSCRIBED_HIERARCHY',
    created_at,
    modified_at
from like_unsubscribe
where (unsubscriber_id, item_id, item_type) not in (select subscriber_id, item_id, item_type from subscriptions)
and unsubscriber_id in (select id from person);

delete from shadow_table where table_name = 'LIKE_SUBSCRIBE';
drop table like_subscribe;
drop table sh_like_subscribe;
delete from shadow_table where table_name = 'LIKE_UNSUBSCRIBE';
drop table like_unsubscribe;
drop table sh_like_unsubscribe;

commit;
