INSERT INTO version (id, release, name, type, description, "date")
VALUES (00009, '8.0', '00009_#patch_migrate_old_notifications_oracle', 'FEATURE', '#10190 Migration von Notifications (oracle)', now());

CREATE TABLE tmp_notification (
    id number(19),
    notification_type varchar2(255 char),
    state varchar2(255 char),
    originator_id number(19),
    receiver_id number(19),
    entity_id number(19),
    entity_type varchar2(255 char),
    subject_id number(19),
    subject_type varchar2(255 char),
    create_date timestamp,
    modify_date timestamp
);

-- Contact requests
insert into tmp_notification(id, notification_type, state,
       originator_id, receiver_id, create_date, modify_date)
select notification_seq.nextval, 'CONTACT_REQUEST_NOTIFICATION', 'ORIGINAL', person_id, friend_id, to_timestamp('1970-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS'), to_timestamp('1970-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS')
from map_person_person_invite;

-- Entity invitations
insert into tmp_notification(id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date)
select notification_seq.nextval, 'INVITATION_NOTIFICATION', 'ORIGINAL',
       i.inviter_id, i.person_id, i.entity_id, e.entity_type, i.entity_id, 'ENTITY', i.create_date, i.create_date
from entity_internal_invitation i, entity e, entity_member_role r
where i.entity_id = e.id
and e.id = r.entity_id
and i.person_id = r.person_id
and r.role = 'HAS_INVITATION';

-- Entity recommendations
insert into tmp_notification(id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date)
select notification_seq.nextval, 'RECOMMENDATION_NOTIFICATION', 'ORIGINAL',
       i.recommender_id, i.person_id, i.entity_id, e.entity_type, i.entity_id, 'ENTITY', i.create_date, i.create_date
from entity_recommendation i, entity e
where i.entity_id = e.id;

-- Join requests
insert into tmp_notification(id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date)
select notification_seq.nextval, 'JOIN_REQUEST_NOTIFICATION', 'ORIGINAL',
       r.person_id, r2.person_id, r.entity_id, e.entity_type, r.entity_id, 'ENTITY', r.create_date, r.create_date
from entity_member_role r, entity e, entity_member_role r2
where r.entity_id = e.id
and r.entity_id = r2.entity_id
and (r2.role = 'ADMIN' or r2.role = 'CO_ADMIN')
and r.role = 'HAS_SENT_JOINREQUEST';

-- In review notification
insert into tmp_notification(id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date)
select notification_seq.nextval, 'ENTITY_VERSION_RELEASE_REQUEST_NOTIFICATION', 'ORIGINAL',
       evr.inviter_id, evr.reviewer_id, ev.entity_id, e.entity_type, ev.id, 'ENTITY_VERSION', ev.create_date, ev.create_date
from entity_version_review evr
inner join entity_version ev on ev.id = evr.entity_version_id
inner join entity e on e.id = ev.entity_id
where evr.review_status='IN_REVIEW' and ev.version_status='IN_REVIEW';

-- Entity release accepted
insert into tmp_notification(id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date)
select notification_seq.nextval, 'ENTITY_VERSION_RELEASE_ACCEPTED_NOTIFICATION', 'ORIGINAL',
       (select r.reviewer_id from entity_version_review r
        where r.entity_version_id=ev.id and review_status='ACCEPTED'
        and rownum=1),
       person_id, entity_id, e.entity_type, ev.id, 'ENTITY_VERSION', ev.modify_date, ev.modify_date
from entity_version ev
inner join entity e on e.id = ev.entity_id
where ev.version_status='PUBLISHED'
and read_date is null;

-- Entity release declined
insert into tmp_notification(id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date)
select notification_seq.nextval, 'ENTITY_VERSION_RELEASE_DENIED_NOTIFICATION', 'ORIGINAL',
       (select r.reviewer_id from entity_version_review r
        where r.entity_version_id=v.id and review_status='DECLINED'
        and rownum=1),
       person_id, entity_id, e.entity_type, v.id, 'ENTITY_VERSION', v.modify_date, v.modify_date
from entity_version v
inner join entity e on e.id = v.entity_id
where version_status='DECLINED'
and read_date is null;


-- Clean the notifications
update tmp_notification
set originator_id = -1
where originator_id is null;

update tmp_notification
set originator_id = -1
where originator_id not in (select id from person);

delete from tmp_notification
where receiver_id not in (select id from person);

-- Delete notifications, so we do not create duplicates.
delete from notification where state = 'ORIGINAL';

-- Insert the actual notifications
insert into notification(id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date)
select id, notification_type, state,
       originator_id, receiver_id, entity_id, entity_type, subject_id, subject_type, create_date, modify_date
from tmp_notification;

-- Drop tmp table
drop table tmp_notification;

COMMIT;
