INSERT INTO version (id, release, name, type, description, "date")
VALUES (00006, '7.9', '00006_#patch_migrate_link_attachments', 'FEATURE', '#8699 - Link-Anhänge in eigener Link-Tabelle statt in workstream_entry_attribute speichern', sysdate);

CREATE OR REPLACE PROCEDURE migrate_links
IS
    CURSOR attribute_cursor
    IS SELECT entry_id, key, value
    FROM workstream_entry_attribute
    WHERE key = 'link_url';

    entry_attribute attribute_cursor%ROWTYPE;
    new_link_id number(19);
    link_url varchar2(4000);
    link_title varchar2(4000);
BEGIN
    OPEN attribute_cursor;
    LOOP
        FETCH attribute_cursor INTO entry_attribute;
        EXIT WHEN attribute_cursor%NOTFOUND;
        
        -- get the correspondig link title for the current url or set NULL
        BEGIN
          SELECT value INTO link_title
          FROM workstream_entry_attribute
          WHERE entry_id = entry_attribute.entry_id
          AND key = 'link_title';

          EXCEPTION
          WHEN NO_DATA_FOUND THEN
            link_title := NULL;
        END;

        link_url := entry_attribute.value;

        -- create new entry in link table
        INSERT INTO link (id, url, title, create_date)
        VALUES (link_seq.nextval, link_url, link_title, clock_timestamp())
        RETURNING id INTO new_link_id;

        -- create attachment for the new link
        -- position is always 0 for there can only be one link attachment per posting
        INSERT INTO workstream_attachment (entry_id, item_id, item_type, position)
        VALUES (entry_attribute.entry_id, new_link_id, 'LINK', 0);
        
        -- remove attributes that contain link-related data. Keep the attribute's (microblog posting) text
        DELETE FROM workstream_entry_attribute
        WHERE entry_id = entry_attribute.entry_id
        AND (workstream_entry_attribute.key = 'link_title' OR workstream_entry_attribute.key = 'link_url');
    END LOOP;
    CLOSE attribute_cursor;
END;
/

BEGIN
    migrate_links;
END;
/

DROP PROCEDURE migrate_links;

COMMIT;
