INSERT INTO version (id, release, name, type, description, "date")
VALUES (00008, '7.5', '00008_#patch_item_visibility_queue.sql', 'FEATURE', '#7229 Sichtbarkeit von Entitäten in der DB speichern', now());

CREATE SEQUENCE item_visibility_queue_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;

CREATE TABLE item_visibility_queue (
    id NUMBER(19, 0) NOT NULL,
    item_id NUMBER(19, 0) NOT NULL,
    item_type VARCHAR2(32 char) NOT NULL,
    created_at TIMESTAMP DEFAULT systimestamp,
    CONSTRAINT itm_vis_q_pk PRIMARY KEY (id)
);

CREATE INDEX itm_vis_q_itm_idx ON item_visibility_queue(item_id, item_type);
CREATE INDEX itm_vis_q_date_idx ON item_visibility_queue(created_at ASC);

CREATE TABLE item_visibility_queue_event (
    item_visibility_queue_id NUMBER(19, 0) NOT NULL,
    event_type VARCHAR2(50 char) NOT NULL,
    CONSTRAINT itm_vis_q_e_pk PRIMARY KEY (item_visibility_queue_id, event_type),
    CONSTRAINT itm_vis_q_e_ivq_fk FOREIGN KEY (item_visibility_queue_id) REFERENCES item_visibility_queue(id) ON DELETE CASCADE
);

COMMIT;
