

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00007, '7.2', '00007_#patch_create_shadow_tables.sql', 'FEATURE', 'refs #4853 Basis für "als gelöscht markieren"', now());

CREATE TABLE SH_ACCEPTED_EXTERNAL_INVITATIO (
    "INVITER_ID" number(10, 0),
    "PERSON_ID" number(10, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "INVITER_ID")
);

CREATE TABLE SH_CONTACT_DATA_BASIC (
    "PERSON_ID" number(19, 0),
    "TYPE" number(*, 0),
    "CO" varchar2(130 char),
    "STREET" varchar2(255 char),
    "ZIPCODE" varchar2(10 char),
    "ZIPCODE_SUCCESSIVE" char(1 char),
    "CITY" varchar2(255 char),
    "COUNTRY_ID" number(19, 0),
    "EMAIL" varchar2(100 char),
    "PHONE" varchar2(100 char),
    "FAX" varchar2(100 char),
    "MOBILE" varchar2(100 char),
    "WEBSITE" varchar2(255 char),
    "CREATED_AT" timestamp(6),
    "MODIFIED_AT" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("TYPE", "PERSON_ID")
);

CREATE TABLE SH_DEFAULT_ALBUM (
    "ITEM_ID" number(19, 0),
    "ITEM_TYPE" varchar2(32 char),
    "ALBUM_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_DYNAMIC_PERSON_ATTRIBUTE (
    "PERSON_ID" number(19, 0),
    "ORDERIDX" number(*, 0),
    "TAB" varchar2(255 char),
    "SECTION" varchar2(255 char),
    "NAME" varchar2(255 char),
    "VALUE" clob,
    "SECTION_CLONE" number(*, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_EMAIL_NOTIFICATION_SETTING (
    "PERSON_ID" number(19, 0),
    "SUBSCRIBE_ROOT_ITEMS" char(1 char),
    "SUBSCRIBE_OTHER_ITEMS" char(1 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    "NOTIFICATIONS_ENABLED" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID")
);

CREATE TABLE SH_EMAIL_USER (
    "USER_ID" varchar2(128 char),
    "domain" varchar2(128 char),
    "PASSWORD" varchar2(64 char),
    "PERSON_ID" number(19, 0),
    "PASSWORD_ENCRYPTED" varchar2(64 char),
    "CREATED_AT" timestamp(6),
    "MODIFIED_AT" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_EMPLOYMENT (
    "ID" number(10, 0),
    "EMPLOYER" clob,
    "position" varchar2(50 char),
    "CITY" varchar2(50 char),
    "START_AT" date,
    "END_AT" date,
    "PERSON_ID" number(10, 0),
    "WEBSITE" varchar2(256 char),
    "INDUSTRY_ID" number(*, 0),
    "OCCUPATION_ID" number(*, 0),
    "JOB_STATUS_ID" number(*, 0),
    "ACTIVITIES" varchar2(1024 char),
    "current" char(1 char),
    "CREATED_AT" timestamp(6),
    "MODIFIED_AT" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID", "PERSON_ID")
);

CREATE TABLE SH_ENTITY (
    "ID" number(19, 0),
    "NAME" varchar2(255 char),
    "START_AT" timestamp(6),
    "END_AT" timestamp(6),
    "CLOSING_DATE" timestamp(6),
    "TIMEZONE" varchar2(255 char),
    "PARTICIPANT_LIMITED" char(1 char),
    "PARTICIPANT_COUNT" number(*, 0),
    "DESCRIPTION" clob,
    "LOCATION" varchar2(255 char),
    "TAGS" clob,
    "SUBDOMAIN" varchar2(255 char),
    "SUBDOMAIN_DEACTIVATED" char(1 char),
    "EXTERNAL_DOMAIN" varchar2(255 char),
    "GOOGLE_MAPS_API_KEY" varchar2(255 char),
    "LOGO" varchar2(255 char),
    "ICON" varchar2(255 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    "WIDGETS_SHOW_SUB_ENTITIES" char(1 char),
    "NETWORK_ID" number(19, 0),
    "GROUP_ID" number(19, 0),
    "WIKI_ID" number(19, 0),
    "APPOINTMENT_ID" number(19, 0),
    "AGGREGATE_WORKSTREAM" char(1 char),
    "CATEGORY" varchar2(32 char),
    "TEXT_IF_NOT_VISIBLE" clob,
    "PUBLIC_VISIBLE" char(1 char),
    "STREAM_WORKSTREAM_TO_PARENTS" char(1 char),
    "USE_PARENT_ADMIN_AS_COADMIN" char(1 char),
    "ENTITY_TYPE" varchar2(255 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_ENTITY_COMPONENT (
    "ENTITY_ID" number(19, 0),
    "COMPONENT_TYPE" varchar2(255 char),
    "position" number(19, 0),
    "order" number(*, 0),
    "VISIBLE" char(1 char),
    "open" char(1 char),
    "CUSTOMIZED_TITLE" clob,
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID", "COMPONENT_TYPE")
);

CREATE TABLE SH_ENTITY_COMPONENT_OPEN_FOR (
    "ENTITY_ID" number(19, 0),
    "COMPONENT_TYPE" varchar2(255 char),
    "AUTHORITY_NAME" varchar2(50 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID", "COMPONENT_TYPE", "AUTHORITY_NAME")
);

CREATE TABLE SH_ENTITY_CONTACT_DATA (
    "ENTITY_ID" number(19, 0),
    "OFFICE" varchar2(255 char),
    "CONTACT_NAME" varchar2(255 char),
    "WEBSITE" varchar2(255 char),
    "EMAIL" varchar2(255 char),
    "PHONE" varchar2(100 char),
    "FAX" varchar2(100 char),
    "STREET" varchar2(255 char),
    "ZIPCODE" varchar2(50 char),
    "CITY" varchar2(255 char),
    "STATE" varchar2(255 char),
    "COUNTRY_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    "LAT" float(126),
    "LNG" float(126),
    "NOT_RESOLVABLE" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID")
);

CREATE TABLE SH_ENTITY_DESIGN (
    "ENTITY_ID" number(19, 0),
    "PAGE_BORDER_COLOR" char(7 char),
    "NAV_BG_COLOR" char(7 char),
    "NAV_QUICKLINK_COLOR" char(7 char),
    "HEADER_BG_COLOR" char(7 char),
    "HEADER_BORDER_COLOR" char(7 char),
    "HEADER_TEXT_COLOR" char(7 char),
    "HEADER_LINK_COLOR" char(7 char),
    "HEADING_BOX_BG_COLOR" char(7 char),
    "HEADING_BOX_TEXT_COLOR" char(7 char),
    "HEADING_BOX_BORDER_COLOR" char(7 char),
    "SUBHEADING_BOX_BG_COLOR" char(7 char),
    "SUBHEADING_BOX_TEXT_COLOR" char(7 char),
    "SUBHEADING_BOX_LINK_COLOR" char(7 char),
    "SUBHEADING_BOX_BORDER_COLOR" char(7 char),
    "SUBHEADING_BOX_LINE_COLOR" char(7 char),
    "INNER_BG_COLOR" char(7 char),
    "OUTER_BG_COLOR" char(7 char),
    "TEXT_COLOR" char(7 char),
    "LINK_COLOR" char(7 char),
    "LINE_COLOR" char(7 char),
    "BUTTON_BG_COLOR" char(7 char),
    "BUTTON_TEXT_COLOR" char(7 char),
    "BOX_TOP_BORDER" char(1 char),
    "BOX_BOTTOM_BORDER" char(1 char),
    "BOX_LEFT_BORDER" char(1 char),
    "BOX_RIGHT_BORDER" char(1 char),
    "HORIZONTAL_NAV_BG_COLOR" char(7 char),
    "HORIZONTAL_NAV_LINK_COLOR" char(7 char),
    "HORIZONTAL_NAV" varchar2(255 char),
    "HEADING_BOX" varchar2(255 char),
    "BANNER" varchar2(255 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    "BG_HORIZONTAL_REPEAT" char(1 char),
    "BG_VERTICAL_REPEAT" char(1 char),
    "BG_IMAGE" varchar2(255 char),
    "BG_SCROLL_FIX" char(1 char),
    "HORIZONTAL_NAV_SELECTED_LINK" char(7 char),
    "HORIZONTAL_NAV_SELECTED_BG" char(7 char),
    "HORIZONTAL_NAV_SUB_LINE" char(7 char),
    "HORIZONTAL_NAV_SELECTED_IMAGE" varchar2(255 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID")
);

CREATE TABLE SH_ENTITY_DYNAMIC_ATTRIBUTE (
    "ENTITY_ID" number,
    "ATTRIBUTE_ID" varchar2(255 char),
    "ATTRIBUTE_VALUE" clob,
    "POSITION" number(*, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_ENTITY_LINK (
    "ENTITY_ID" number(19, 0),
    "LINKED_ENTITY_ID" number(19, 0),
    "order" number(*, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID", "LINKED_ENTITY_ID")
);

CREATE TABLE SH_ENTITY_MEMBER (
    "PERSON_ID" number(19, 0),
    "ENTITY_ID" number(19, 0),
    "MEMBER_STATUS" number(*, 0),
    "MEMBER_ROLE" number(*, 0),
    "STATUS_MODIFY_DATE" timestamp(6),
    "LAST_NOTIFY_STATUS" number(*, 0),
    "LAST_NOTIFY_DATE" timestamp(6),
    "INVITER_ID" number(19, 0),
    "INVITE_MESSAGE" clob,
    "MODIFY_DATE" timestamp(6),
    "CREATE_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "ENTITY_ID")
);

CREATE TABLE SH_ENTITY_NAV_LINK (
    "ID" number(19, 0),
    "ENTITY_ID" number(19, 0),
    "TEXT" varchar2(63 char),
    "TARGET" varchar2(255 char),
    "LIST_INDEX" number(*, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_ENTITY_NAV_SUBLINK (
    "ID" number(19, 0),
    "PARENT_ID" number(19, 0),
    "TEXT" varchar2(63 char),
    "TARGET" varchar2(255 char),
    "LIST_INDEX" number(*, 0),
    "CREATE_DATE" timestamp(6),
    "EDIT_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_ENTITY_OPTION (
    "ENTITY_ID" number(19, 0),
    "OPTION_NAME" varchar2(100 char),
    "OPTION_VALUE" varchar2(100 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID", "OPTION_NAME")
);

CREATE TABLE SH_ENTITY_PRIVACY (
    "ENTITY_ID" number(19, 0),
    "PRIVACY_TYPE" varchar2(50 char),
    "AUTHORITY_NAME" varchar2(50 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_ENTITY_TO_ENTITY_TYPE_PRIVA (
    "ENTITY_ID" number(19, 0),
    "ENTITY_TYPE" varchar2(255 char),
    "AUTHORITY_NAME" varchar2(50 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID", "ENTITY_TYPE", "AUTHORITY_NAME")
);

CREATE TABLE SH_ENTITY_VERSION (
    "ID" number(19, 0),
    "ENTITY_ID" number(19, 0),
    "PARENT_VERSION_ID" number(19, 0),
    "PERSON_ID" number(19, 0),
    "MAJOR_VERSION" number(*, 0),
    "MINOR_VERSION" number(*, 0),
    "DRAFT_VERSION" number(*, 0),
    "VERSION_TYPE" varchar2(255 char),
    "TARGET_TYPE" varchar2(255 char),
    "VERSION_STATUS" varchar2(255 char),
    "RELEASE_DATE" timestamp(6),
    "EXPIRATION_DATE" timestamp(6),
    "CHANGE_MESSAGE" varchar2(255 char),
    "COMMENT_FOR_REVIEWERS" varchar2(255 char),
    "READ_DATE" date,
    "DECLINE_MESSAGE" varchar2(255 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_ENTITY_VERSION_COMPONENTS (
    "ENTITY_VERSION_ID" number(19, 0),
    "MULTI_WIKI_VERSION_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_ENTITY_VERSION_REVIEW (
    "ENTITY_VERSION_ID" number(19, 0),
    "REVIEWER_ID" number(19, 0),
    "INVITER_ID" number(19, 0),
    "REVIEW_STATUS" varchar2(255 char),
    "REVIEW_ORDER" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_VERSION_ID", "REVIEWER_ID")
);

CREATE TABLE SH_EXTERNAL_INVITATION (
    "INVITER_ID" number(10, 0),
    "EMAIL" varchar2(100 char),
    "HASH" varchar2(100 char),
    "ENTITY_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("HASH")
);

CREATE TABLE SH_IGNORE_LIST (
    "PERSON_ID" number(10, 0),
    "IGNORED_ID" number(10, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "IGNORED_ID")
);

CREATE TABLE SH_ITEM_UNREAD (
    "PERSON_ID" number(8, 0),
    "ITEM_ID" number(8, 0),
    "ITEM_TYPE" varchar2(4000 char),
    "CREATION_DATE" timestamp(6),
    "ITEM_MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "ITEM_ID", "ITEM_TYPE")
);

CREATE TABLE SH_LIKE_SUBSCRIBE (
    "SUBSCRIBER_ID" number(19, 0),
    "ITEM_ID" number(19, 0),
    "ITEM_TYPE" varchar2(4000 char),
    "CREATED_AT" timestamp(6),
    "MODIFIED_AT" timestamp(6),
    "PASSIVE" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ITEM_ID", "ITEM_TYPE", "SUBSCRIBER_ID")
);

CREATE TABLE SH_LIKE_TABLE (
    "LIKER_ID" number(19, 0),
    "ITEM_ID" number(19, 0),
    "ITEM_TYPE" varchar2(4000 char),
    "CREATED_AT" timestamp(6),
    "MODIFIED_AT" timestamp(6),
    "RECENT" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ITEM_ID", "ITEM_TYPE", "LIKER_ID")
);

CREATE TABLE SH_LIKE_UNSUBSCRIBE (
    "UNSUBSCRIBER_ID" number(19, 0),
    "ITEM_ID" number(19, 0),
    "ITEM_TYPE" varchar2(4000 char),
    "CREATED_AT" timestamp(6),
    "MODIFIED_AT" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ITEM_ID", "ITEM_TYPE", "UNSUBSCRIBER_ID")
);

CREATE TABLE SH_MAP_PERSON_PERSON (
    "PERSON_ID" number(10, 0),
    "FRIEND_ID" number(10, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "FRIEND_ID")
);

CREATE TABLE SH_MAP_PERSON_PERSON_INVITE (
    "PERSON_ID" number(10, 0),
    "FRIEND_ID" number(10, 0),
    "MESSAGE" clob,
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "FRIEND_ID")
);

CREATE TABLE SH_MAP_PERSON_RELATIONSHIP_TYP (
    "PERSON_ID" number(10, 0),
    "RELATIONSHIPTYPE_ID" number(2, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "RELATIONSHIPTYPE_ID")
);

CREATE TABLE SH_MDL_ALBUM (
    "ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "MODULE" char(1 char),
    "OWNER_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "EDIT_DATE" timestamp(6),
    "TITLE" varchar2(255 char),
    "DESCRIPTION" clob,
    "LOCATION" varchar2(80 char),
    "FRIENDS_ONLY" char(1 char),
    "OLD_ALBUM_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MDL_ALBUM_IMAGE (
    "ID" number(19, 0),
    "TITLE" varchar2(255 char),
    "ALBUM_ID" number(19, 0),
    "FILENAME" varchar2(255 char),
    "OWNER_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "EDIT_DATE" timestamp(6),
    "OLD_ALBUM_IMAGE_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MDL_COMMENT (
    "ID" number(19, 0),
    "AUTHOR_ID" number(19, 0),
    "TEXT" varchar2(1000 char),
    "POSTED_AT" timestamp(6),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "CUSTOM_INFO" varchar2(255 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MDL_DOCUMENT (
    "ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "DESCRIPTION" varchar2(1024 char),
    "KEYWORDS" clob,
    "DOWNLOAD_COUNT" number(19, 0),
    "CHECKED_OUT_BY" number(19, 0),
    "CHECKED_OUT_AT" timestamp(6),
    "STATUS" number(*, 0),
    "STATUS_CHANGED_BY" number(19, 0),
    "STATUS_CHANGED_AT" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MDL_DOCUMENT_VERSION (
    "ID" number(19, 0),
    "VERSION" number(*, 0),
    "FILENAME" varchar2(256 char),
    "DOCUMENT_ID" number(19, 0),
    "URL" varchar2(1024 char),
    "UPLOADED_BY" number(19, 0),
    "UPLOADED_AT" timestamp(6),
    "size" number(19, 0),
    "FILE_TYPE_ID" number(19, 0),
    "RESTORED_FROM" number(*, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MDL_FORUM_MIGRATION (
    "ENTITY_ID" number(19, 0),
    "OLD_FORUM_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_MDL_FORUM_TOPIC (
    "ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "CAPTION" varchar2(255 char),
    "EDIT_DATE" timestamp(6),
    "CREATE_DATE" timestamp(6),
    "AUTHOR_ID" number(19, 0),
    "HITS" number(19, 0),
    "OLD_TOPIC_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MDL_FORUM_TOPIC_ARTICLE (
    "ID" number(19, 0),
    "TOPIC_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "AUTHOR_ID" number(19, 0),
    "ARTICLE_TEXT" clob,
    "EDITOR_ID" number(19, 0),
    "EDIT_DATE" timestamp(6),
    "EDIT_REASON" varchar2(50 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MDL_VIDEO_LINK (
    "ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "TITLE" varchar2(255 char),
    "URL" varchar2(255 char),
    "EDIT_DATE" timestamp(6),
    "CREATE_DATE" timestamp(6),
    "AUTHOR_ID" number(19, 0),
    "public" char(1 char),
    "VIDEO_FILE" varchar2(256 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MESSAGE (
    "ID" number(10, 0),
    "SENDER_ID" number(10, 0),
    "MESSAGE" clob,
    "SUBJECT" varchar2(255 char),
    "date" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MESSAGE_INBOX (
    "OWNER_ID" number(10, 0),
    "MESSAGE_ID" number(10, 0),
    "MESSAGE_STATUS" number(1, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("OWNER_ID", "MESSAGE_ID")
);

CREATE TABLE SH_MESSAGE_OUTBOX (
    "OWNER_ID" number(10, 0),
    "MESSAGE_ID" number(10, 0),
    "MESSAGE_STATUS" number(1, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("OWNER_ID", "MESSAGE_ID")
);

CREATE TABLE SH_MESSAGE_RECIPIENT (
    "MESSAGE_ID" number(10, 0),
    "RECIPIENT_ID" number(10, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_MULTI_WIKI (
    "ID" number(19, 0),
    "ENTITY_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MULTI_WIKI_SECTION_VISIBILI (
    "VERSION_SECTION_ID" number(19, 0),
    "AUTHORITY_NAME" varchar2(50 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("VERSION_SECTION_ID", "AUTHORITY_NAME")
);

CREATE TABLE SH_MULTI_WIKI_VERSION (
    "ID" number(19, 0),
    "WIKI_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_MULTI_WIKI_VERSION_SECTION (
    "ID" number(19, 0),
    "VERSION_ID" number(19, 0),
    "HEADLINE" varchar2(256 char),
    "HTML" clob,
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    "SECTION_ID" number(19, 0),
    "SECTION_ORDER" number(9, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_NEWS_BLOG (
    "ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "HEADLINE" varchar2(255 char),
    "CREATE_DATE" timestamp(6),
    "EDIT_DATE" timestamp(6),
    "AUTHOR_ID" number(19, 0),
    "SOURCE_TEXT" varchar2(255 char),
    "SOURCE_HREF" varchar2(255 char),
    "KEYWORDS" varchar2(255 char),
    "TEXT" clob,
    "IMAGE_ID" number(19, 0),
    "DRAFT" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_PERSON (
    "ID" number(10, 0),
    "LAST_LOGIN" timestamp(6),
    "SHOW_TEMPSTARTPAGE" char(1 char),
    "ACCOUNT_ACTIVE" char(1 char),
    "TITLE" varchar2(255 char),
    "FIRSTNAME" varchar2(50 char),
    "SURNAME" varchar2(100 char),
    "EMAIL" varchar2(100 char),
    "NEWMAIL" varchar2(100 char),
    "ACTIVATION_HASH" varchar2(100 char),
    "BIRTHDAY" date,
    "PASSWORD_HASH" char(28 char),
    "KEYWORDS" varchar2(255 char),
    "GENDER" number(*, 0),
    "ZODIAC_ID" number(2, 0),
    "RELATIONSHIPSTATUS_ID" number(2, 0),
    "POLITVIEW_ID" number(2, 0),
    "RELIGVIEW_ID" number(2, 0),
    "HOME_CITY" varchar2(255 char),
    "HOME_COUNTRY" varchar2(255 char),
    "LANGUAGE_ID" char(2 char),
    "CURRENT_CITY" varchar2(255 char),
    "CURRENT_COUNTRY" varchar2(255 char),
    "PASSWORD_QUESTION" varchar2(255 char),
    "PASSWORD_ANSWER" varchar2(255 char),
    "REGISTERDATE" timestamp(6),
    "TERMS_ACCEPTED" char(1 char),
    "IMAGE" varchar2(64 char),
    "ALLOW_NEWSLETTER" char(1 char),
    "BLOCKED" char(1 char),
    "SHOW_ACTIONS_IN_NETWORKS" char(1 char),
    "DEFAULT_TIMEZONE" varchar2(100 char),
    "MODIFIED_AT" timestamp(6),
    "CREATED_AT" timestamp(6),
    "BIRTHDAY_VISIBILITY" varchar2(64 char),
    "STATUS_ID" number(*, 0),
    "HASHED_ID" varchar2(32 char),
    "ADDITIONAL_TITLE" varchar2(255 char),
    "PSEUDONYM" varchar2(255 char),
    "PSEUDONYM_ENABLED" char(1 char),
    "VISIBLE_FOR_RESTRICTED" char(1 char),
    "DELETED" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_PERSON_EXTERNAL_IDS (
    "PERSON_ID" number(19, 0),
    "EXTERNAL_PERSON_ID" varchar2(4000 char),
    "EXTERNAL_SYSTEM_ID" varchar2(50 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "EXTERNAL_SYSTEM_ID")
);

CREATE TABLE SH_PERSON_NOFRIENDS_MESSAGE (
    "PERSON_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID")
);

CREATE TABLE SH_PERSON_PRIMARY_NETWORK (
    "PERSON_ID" number(19, 0),
    "NETWORK_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_PERSON_TO_ROLE (
    "PERSON_ID" number(19, 0),
    "ROLE_NAME" varchar2(15 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "ROLE_NAME")
);

CREATE TABLE SH_PROFILE_COMPONENT (
    "PERSON_ID" number(19, 0),
    "COMPONENT_TYPE" varchar2(255 char),
    "position" number(19, 0),
    "order" number(*, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "COMPONENT_TYPE")
);

CREATE TABLE SH_PROFILE_COMPONENT_VISIBILIT (
    "PERSON_ID" number(19, 0),
    "COMPONENT_TYPE" varchar2(255 char),
    "AUTHORITY_NAME" varchar2(50 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "COMPONENT_TYPE", "AUTHORITY_NAME")
);

CREATE TABLE SH_PROFILE_VISIBILITY_FOR_ROLE (
    "PERSON_ID" number(19, 0),
    "ROLE_NAME_MAY_SEE" clob,
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_RANDOM_MEMBER_COMPONENT_CFG (
    "ENTITY_ID" number(19, 0),
    "ROLE_NAME" varchar2(15 char),
    "order" number(*, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID", "ROLE_NAME")
);

CREATE TABLE SH_RAWEDITOR_VERSION (
    "ID" number(19, 0),
    "RAWEDITOR_ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "EDITOR_TYPE" varchar2(255 char),
    "VERSION" number(*, 0),
    "TEXT" clob,
    "CREATE_DATE" timestamp(6),
    "AUTHOR_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_RIGHTS (
    "PERSON_ID" number(10, 0),
    "ADMIN" char(1 char),
    "TRANSLATOR" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID")
);

CREATE TABLE SH_SCHOOL (
    "ID" number(10, 0),
    "NAME" varchar2(50 char),
    "GRADYEAR" number(4, 0),
    "PERSON_ID" number(10, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_START_PAGE_PROFILE (
    "ID" number(19, 0),
    "PERSON_ID" number(19, 0),
    "LANGUAGE" char(2 char),
    "ACTIVATED" char(1 char),
    "IMAGE" varchar2(255 char),
    "DELETED" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_SURVEY (
    "ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "TITLE" varchar2(255 char),
    "EXPIRED_DATE" timestamp(6),
    "OWNER_ID" number(19, 0),
    "RESULT_VISIBILTY" number(*, 0),
    "ANONYM" char(1 char),
    "PARTICIPANT_MAY_MODIFY" char(1 char),
    "AUTO_DELETE_ANSWERS" char(1 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_SURVEY_PARTICIPANT_ANSWER (
    "PARTICIPANT_ID" number(19, 0),
    "SURVEY_QUESTION_ID" number(19, 0),
    "SURVEY_PREDEFINED_ANSWER_ID" number(19, 0),
    "FREETEXT_ANSWER" clob,
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_SURVEY_PREDEFINED_ANSWER (
    "ID" number(19, 0),
    "SURVEY_QUESTION_ID" number(19, 0),
    "ANSWER" clob,
    "order" number(*, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_SURVEY_QUESTION (
    "ID" number(19, 0),
    "SURVEY_ID" number(19, 0),
    "QUESTION" clob,
    "order" number(*, 0),
    "FREETEXT_ANSWER" char(1 char),
    "MIN_ANSWER" number(*, 0),
    "MAX_ANSWER" number(*, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_UNIVERSITY (
    "ID" number(10, 0),
    "NAME" varchar2(50 char),
    "DEGREE" varchar2(50 char),
    "COURSE" varchar2(50 char),
    "GRADYEAR" number(4, 0),
    "PERSON_ID" number(10, 0),
    "UNIVERSITY_DEPARTMENT_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_USER_SETTING (
    "ID" number(19, 0),
    "PERSON_ID" number(10, 0),
    "KEY" varchar2(30 char),
    "VALUE" varchar2(4000 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_WIKI_EDITOR (
    "ID" number(19, 0),
    "PARENT_ITEM_ID" number(19, 0),
    "PARENT_ITEM_TYPE" varchar2(32 char),
    "OLD_GROUP_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_WIKI_EDITOR_BACKUP (
    "WIKI_EDITOR_ID" number(19, 0),
    "HEADLINE" varchar2(255 char),
    "WIKI_TEXT" clob,
    "AUTHOR_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("WIKI_EDITOR_ID")
);

CREATE TABLE SH_WIKI_EDITOR_VERSION (
    "ID" number(19, 0),
    "WIKI_EDITOR_ID" number(19, 0),
    "HEADLINE" varchar2(255 char),
    "WIKI_TEXT" clob,
    "VERSION" number(*, 0),
    "AUTHOR_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "RESTORED_FROM" number(19, 0),
    "OLD_PAGE_ID" number(19, 0),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_WORKSTREAM (
    "ENTRY_ID" number(19, 0),
    "ITEM_ID" number(19, 0),
    "ITEM_TYPE" varchar2(32 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_WORKSTREAM_ATTACHMENT (
    "ENTRY_ID" number(19, 0),
    "ITEM_ID" number(19, 0),
    "ITEM_TYPE" varchar2(32 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ITEM_ID", "ITEM_TYPE")
);

CREATE TABLE SH_WORKSTREAM_ENTRY (
    "ID" number(19, 0),
    "TYPE" varchar2(32 char),
    "ORIGIN_ITEM_ID" number(19, 0),
    "ORIGIN_ITEM_TYPE" varchar2(32 char),
    "AUTHOR_ID" number(19, 0),
    "CREATED_AT" timestamp(6),
    "MODIFIED_AT" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_WORKSTREAM_ENTRY_ATTRIBUTE (
    "ENTRY_ID" number(19, 0),
    "KEY" varchar2(24 char),
    "VALUE" clob,
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ACCEPTED_EXTERNAL_INVITATION','SH_ACCEPTED_EXTERNAL_INVITATIO','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('CONTACT_DATA_BASIC','SH_CONTACT_DATA_BASIC','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('DEFAULT_ALBUM','SH_DEFAULT_ALBUM','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('DYNAMIC_PERSON_ATTRIBUTE','SH_DYNAMIC_PERSON_ATTRIBUTE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('EMAIL_NOTIFICATION_SETTING','SH_EMAIL_NOTIFICATION_SETTING','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('EMAIL_USER','SH_EMAIL_USER','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('EMPLOYMENT','SH_EMPLOYMENT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY','SH_ENTITY','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_COMPONENT','SH_ENTITY_COMPONENT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_COMPONENT_OPEN_FOR','SH_ENTITY_COMPONENT_OPEN_FOR','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_CONTACT_DATA','SH_ENTITY_CONTACT_DATA','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_DESIGN','SH_ENTITY_DESIGN','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_DYNAMIC_ATTRIBUTE','SH_ENTITY_DYNAMIC_ATTRIBUTE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_LINK','SH_ENTITY_LINK','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_MEMBER','SH_ENTITY_MEMBER','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_NAV_LINK','SH_ENTITY_NAV_LINK','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_NAV_SUBLINK','SH_ENTITY_NAV_SUBLINK','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_OPTION','SH_ENTITY_OPTION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_PRIVACY','SH_ENTITY_PRIVACY','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_TO_ENTITY_TYPE_PRIVACY','SH_ENTITY_TO_ENTITY_TYPE_PRIVA','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_VERSION','SH_ENTITY_VERSION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_VERSION_COMPONENTS','SH_ENTITY_VERSION_COMPONENTS','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_VERSION_REVIEW','SH_ENTITY_VERSION_REVIEW','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('EXTERNAL_INVITATION','SH_EXTERNAL_INVITATION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('IGNORE_LIST','SH_IGNORE_LIST','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ITEM_UNREAD','SH_ITEM_UNREAD','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('LIKE_SUBSCRIBE','SH_LIKE_SUBSCRIBE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('LIKE_TABLE','SH_LIKE_TABLE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('LIKE_UNSUBSCRIBE','SH_LIKE_UNSUBSCRIBE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MAP_PERSON_PERSON','SH_MAP_PERSON_PERSON','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MAP_PERSON_PERSON_INVITE','SH_MAP_PERSON_PERSON_INVITE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MAP_PERSON_RELATIONSHIP_TYPE','SH_MAP_PERSON_RELATIONSHIP_TYP','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_ALBUM','SH_MDL_ALBUM','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_ALBUM_IMAGE','SH_MDL_ALBUM_IMAGE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_COMMENT','SH_MDL_COMMENT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_DOCUMENT','SH_MDL_DOCUMENT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_DOCUMENT_VERSION','SH_MDL_DOCUMENT_VERSION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_FORUM_MIGRATION','SH_MDL_FORUM_MIGRATION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_FORUM_TOPIC','SH_MDL_FORUM_TOPIC','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_FORUM_TOPIC_ARTICLE','SH_MDL_FORUM_TOPIC_ARTICLE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MDL_VIDEO_LINK','SH_MDL_VIDEO_LINK','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MESSAGE','SH_MESSAGE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MESSAGE_INBOX','SH_MESSAGE_INBOX','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MESSAGE_OUTBOX','SH_MESSAGE_OUTBOX','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MESSAGE_RECIPIENT','SH_MESSAGE_RECIPIENT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MULTI_WIKI','SH_MULTI_WIKI','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MULTI_WIKI_SECTION_VISIBILITY','SH_MULTI_WIKI_SECTION_VISIBILI','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MULTI_WIKI_VERSION','SH_MULTI_WIKI_VERSION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('MULTI_WIKI_VERSION_SECTION','SH_MULTI_WIKI_VERSION_SECTION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('NEWS_BLOG','SH_NEWS_BLOG','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PERSON','SH_PERSON','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PERSON_EXTERNAL_IDS','SH_PERSON_EXTERNAL_IDS','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PERSON_NOFRIENDS_MESSAGE','SH_PERSON_NOFRIENDS_MESSAGE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PERSON_PRIMARY_NETWORK','SH_PERSON_PRIMARY_NETWORK','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PERSON_TO_ROLE','SH_PERSON_TO_ROLE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PROFILE_COMPONENT','SH_PROFILE_COMPONENT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PROFILE_COMPONENT_VISIBILITY','SH_PROFILE_COMPONENT_VISIBILIT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('PROFILE_VISIBILITY_FOR_ROLE','SH_PROFILE_VISIBILITY_FOR_ROLE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('RANDOM_MEMBER_COMPONENT_CFG','SH_RANDOM_MEMBER_COMPONENT_CFG','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('RAWEDITOR_VERSION','SH_RAWEDITOR_VERSION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('RIGHTS','SH_RIGHTS','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('SCHOOL','SH_SCHOOL','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('START_PAGE_PROFILE','SH_START_PAGE_PROFILE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('SURVEY','SH_SURVEY','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('SURVEY_PARTICIPANT_ANSWER','SH_SURVEY_PARTICIPANT_ANSWER','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('SURVEY_PREDEFINED_ANSWER','SH_SURVEY_PREDEFINED_ANSWER','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('SURVEY_QUESTION','SH_SURVEY_QUESTION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('UNIVERSITY','SH_UNIVERSITY','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('USER_SETTING','SH_USER_SETTING','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('WIKI_EDITOR','SH_WIKI_EDITOR','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('WIKI_EDITOR_BACKUP','SH_WIKI_EDITOR_BACKUP','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('WIKI_EDITOR_VERSION','SH_WIKI_EDITOR_VERSION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('WORKSTREAM','SH_WORKSTREAM','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('WORKSTREAM_ATTACHMENT','SH_WORKSTREAM_ATTACHMENT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('WORKSTREAM_ENTRY','SH_WORKSTREAM_ENTRY','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('WORKSTREAM_ENTRY_ATTRIBUTE','SH_WORKSTREAM_ENTRY_ATTRIBUTE','f');


COMMIT;