INSERT INTO version (id, release, name, type, description, "date")
VALUES (00004, '7.2', '00004_#patch_create_entity_default_design_table.sql', 'FEATURE', '#4750: Basis für unterschiedliche Standarddesigns für Entitätstypen schaffen', now());

CREATE SEQUENCE entity_default_design_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE entity_default_design
(
    id number(8) NOT NULL,
    entity_type varchar2(255 CHAR),
    page_border_color char(7),
    nav_bg_color char(7),
    nav_quicklink_color char(7),
    nav_separator_bg_color char(7),
    nav_separator_txt_color char(7),
    header_bg_color char(7),
    header_border_color char(7),
    header_text_color char(7),
    header_link_color char(7),
    heading_box_bg_color char(7),
    heading_box_text_color char(7),
    heading_box_border_color char(7),
    subheading_box_bg_color char(7),
    subheading_box_text_color char(7),
    subheading_box_link_color char(7),
    subheading_box_border_color char(7),
    subheading_box_line_color char(7),
    inner_bg_color char(7),
    outer_bg_color char(7),
    text_color char(7),
    link_color char(7),
    line_color char(7),
    button_bg_color char(7),
    button_text_color char(7),
    box_top_border char(1) DEFAULT ('f') NOT NULL,
    box_bottom_border char(1) DEFAULT ('f') NOT NULL,
    box_left_border char(1) DEFAULT ('f') NOT NULL,
    box_right_border char(1) DEFAULT ('f') NOT NULL,
    horizontal_nav_bg_color char(7),
    horizontal_nav_link_color char(7),
    bg_horizontal_repeat char(1) DEFAULT ('f') NOT NULL,
    bg_vertical_repeat char(1) DEFAULT ('f') NOT NULL,
    bg_scroll_fix char(1) DEFAULT ('f') NOT NULL,
    bg_image varchar2(255 CHAR),
    horizontal_nav_selected_link char(7),
    horizontal_nav_selected_bg char(7),
    horizontal_nav_sub_line char(7),
    horizontal_nav_selected_image varchar2(255 CHAR),
    horizontal_nav varchar2(255 CHAR),
    heading_box varchar2(255 CHAR),
    banner varchar2(255 CHAR),
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_default_design_pk PRIMARY KEY (id),
    CONSTRAINT entity_default_design_type_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name(name)  ON DELETE CASCADE,
    CONSTRAINT entity_default_type_unique UNIQUE (entity_type)
);

INSERT INTO entity_default_design(
            id, entity_type,
            nav_bg_color, nav_quicklink_color, page_border_color, header_bg_color, header_text_color, 
            header_link_color, header_border_color, heading_box_bg_color, heading_box_text_color, heading_box_border_color, 
            subheading_box_bg_color, subheading_box_text_color, subheading_box_link_color, subheading_box_border_color, 
            subheading_box_line_color, outer_bg_color, inner_bg_color, text_color, link_color, line_color, 
            button_bg_color, button_text_color, horizontal_nav_bg_color, horizontal_nav_link_color,
            horizontal_nav_selected_bg, horizontal_nav_selected_link, horizontal_nav_sub_line,
            create_date, modify_date,
            bg_image, banner, heading_box, horizontal_nav, horizontal_nav_selected_image,
            bg_horizontal_repeat, bg_scroll_fix, bg_vertical_repeat, box_bottom_border, box_left_border, box_right_border, box_top_border)
SELECT entity_default_design_seq.nextval, null as entity_type,
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 1), TO_CLOB('#000000')), 
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 2), TO_CLOB('#0e2568')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 3), TO_CLOB('#a8cffa')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 4), TO_CLOB('#f4f8fe')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 5), TO_CLOB('#000000')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 6), TO_CLOB('#0061ca')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 7), TO_CLOB('#a8cffa')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 8), TO_CLOB('#f4f8fe')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 9), TO_CLOB('#0061ca')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 10), TO_CLOB('#a8cffa')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 11), TO_CLOB('#f4f8fe')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 12), TO_CLOB('#333333')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 13), TO_CLOB('#0061ca')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 14), TO_CLOB('#a8cffa')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 15), TO_CLOB('#a8cffa')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 16), TO_CLOB('#ffffff')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 17), TO_CLOB('#ffffff')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 18), TO_CLOB('#000000')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 19), TO_CLOB('#0061ca')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 20), TO_CLOB('#a8cffa')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 21), TO_CLOB('#0e2568')), 
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 22), TO_CLOB('#ffffff')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 23), TO_CLOB('#f4f8fe')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 24), TO_CLOB('#0061ca')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 25), TO_CLOB('#0e2568')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 26), TO_CLOB('#ffffff')),
COALESCE(REGEXP_SUBSTR(COALESCE((SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings'), TO_CLOB('')), '[^,]+', 1, 27), TO_CLOB('#f4f8fe')),
now(), now(),
(SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design images/background image url' and container_name = 'systemSettings'),
(SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design images/banner' and container_name = 'systemSettings'),
(SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design images/heading box wide' and container_name = 'systemSettings'),
(SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design images/horizontal navigation' and container_name = 'systemSettings'),
(SELECT default_value from base_property WHERE property_name = 'Settings/Networks/Designs/default design images/horizontal navigation selected' and container_name = 'systemSettings'),
COALESCE((SELECT case when TO_CHAR(default_value) = 'true' then 't' else 'f' end from base_property WHERE property_name = 'Settings/Networks/Designs/default design background horizontal repeat' and container_name = 'systemSettings'), 'f'),
COALESCE((SELECT case when TO_CHAR(default_value) = 'true' then 't' else 'f' end from base_property WHERE property_name = 'Settings/Networks/Designs/default design background scrolling fixed' and container_name = 'systemSettings'), 'f'),
COALESCE((SELECT case when TO_CHAR(default_value) = 'true' then 't' else 'f' end from base_property WHERE property_name = 'Settings/Networks/Designs/default design background vertical repeat' and container_name = 'systemSettings'), 'f'),
COALESCE((SELECT case when TO_CHAR(default_value) = 'true' then 't' else 'f' end from base_property WHERE property_name = 'Settings/Networks/Designs/default design show bottom border' and container_name = 'systemSettings'), 'f'),
COALESCE((SELECT case when TO_CHAR(default_value) = 'true' then 't' else 'f' end from base_property WHERE property_name = 'Settings/Networks/Designs/default design show left border' and container_name = 'systemSettings'), 'f'),
COALESCE((SELECT case when TO_CHAR(default_value) = 'true' then 't' else 'f' end from base_property WHERE property_name = 'Settings/Networks/Designs/default design show right border' and container_name = 'systemSettings'), 'f'),
COALESCE((SELECT case when TO_CHAR(default_value) = 'true' then 't' else 'f' end from base_property WHERE property_name = 'Settings/Networks/Designs/default design show top border' and container_name = 'systemSettings'), 'f')
FROM dual;

DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design images/background image url' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design images/banner' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design images/heading box wide' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design images/horizontal navigation' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design images/horizontal navigation selected' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design background horizontal repeat' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design background scrolling fixed' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design background vertical repeat' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design show bottom border' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design show left border' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design show right border' and container_name = 'systemSettings';
DELETE FROM base_property WHERE property_name = 'Settings/Networks/Designs/default design show top border' and container_name = 'systemSettings';

COMMIT;
