/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import thirdparty.org.apache.commons.dbutils.BasicRowProcessor;
import thirdparty.org.apache.commons.dbutils.RowProcessor;

public class ResultSetIterator
implements Iterator {
    private ResultSet rs = null;
    private RowProcessor convert = new BasicRowProcessor();

    public ResultSetIterator(ResultSet rs) {
        this.rs = rs;
    }

    public ResultSetIterator(ResultSet rs, RowProcessor convert) {
        this.rs = rs;
        this.convert = convert;
    }

    public boolean hasNext() {
        try {
            return !this.rs.isLast();
        }
        catch (SQLException e) {
            this.rethrow(e);
            return false;
        }
    }

    public Object next() {
        try {
            this.rs.next();
            return this.convert.toArray(this.rs);
        }
        catch (SQLException e) {
            this.rethrow(e);
            return null;
        }
    }

    public void remove() {
        try {
            this.rs.deleteRow();
        }
        catch (SQLException e) {
            this.rethrow(e);
        }
    }

    protected void rethrow(SQLException e) {
        throw new RuntimeException(e.getMessage());
    }
}

