/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.parser.parsingstate.impl;

import org.dbmaintain.script.parser.impl.HandleNextCharacterResult;
import org.dbmaintain.script.parser.impl.StatementBuilder;
import org.dbmaintain.script.parser.parsingstate.ParsingState;
import org.dbmaintain.script.parser.parsingstate.PlSqlBlockMatcher;

public abstract class BaseNormalParsingState
implements ParsingState {
    protected static final Character BACKSLASH = Character.valueOf('\\');
    protected static final Character DASH = Character.valueOf('-');
    protected static final Character SLASH = Character.valueOf('/');
    protected static final Character ASTERIX = Character.valueOf('*');
    protected static final Character SINGLE_QUOTE = Character.valueOf('\'');
    protected static final Character DOUBLE_QUOTE = Character.valueOf('\"');
    protected static final Character SEMICOLON = Character.valueOf(';');
    protected static final Character OPEN_CURLY_BRACE = Character.valueOf('{');
    protected boolean backSlashEscapingEnabled;
    protected boolean curlyBraceBlockCommentSupported;
    protected PlSqlBlockMatcher plSqlBlockMatcher;
    protected HandleNextCharacterResult endOfStatementResult;
    protected HandleNextCharacterResult stayInNormalNotExecutableResult;
    protected HandleNextCharacterResult stayInNormalExecutableResult;
    protected HandleNextCharacterResult toEscapingParsingStateResult;
    protected HandleNextCharacterResult toInLineCommentResult;
    protected HandleNextCharacterResult toInBlockCommentResult;
    protected HandleNextCharacterResult toCurlyBraceBlockCommentResult;
    protected HandleNextCharacterResult toInSingleQuotesStateResult;
    protected HandleNextCharacterResult toInDoubleQuotesStateResult;
    protected HandleNextCharacterResult toInPlSqlBlockStateResult;

    protected BaseNormalParsingState(boolean backSlashEscapingEnabled, boolean curlyBraceBlockCommentSupported, PlSqlBlockMatcher plSqlBlockMatcher) {
        this.backSlashEscapingEnabled = backSlashEscapingEnabled;
        this.curlyBraceBlockCommentSupported = curlyBraceBlockCommentSupported;
        this.plSqlBlockMatcher = plSqlBlockMatcher;
    }

    public void linkParsingStates(ParsingState inLineCommentParsingState, ParsingState inBlockCommentParsingState, ParsingState inCurlyBraceBlockCommentParsingState, ParsingState inSingleQuotesParsingState, ParsingState inDoubleQuotesParsingState, ParsingState escapingParsingState, ParsingState plSqlBlockNormalParsingState) {
        this.endOfStatementResult = new HandleNextCharacterResult(null, false);
        this.stayInNormalNotExecutableResult = new HandleNextCharacterResult(this, false);
        this.stayInNormalExecutableResult = new HandleNextCharacterResult(this, true);
        this.toInLineCommentResult = new HandleNextCharacterResult(inLineCommentParsingState, false);
        this.toInBlockCommentResult = new HandleNextCharacterResult(inBlockCommentParsingState, false);
        this.toCurlyBraceBlockCommentResult = new HandleNextCharacterResult(inCurlyBraceBlockCommentParsingState, false);
        this.toInSingleQuotesStateResult = new HandleNextCharacterResult(inSingleQuotesParsingState, true);
        this.toInDoubleQuotesStateResult = new HandleNextCharacterResult(inDoubleQuotesParsingState, true);
        this.toEscapingParsingStateResult = new HandleNextCharacterResult(escapingParsingState, false);
        this.toInPlSqlBlockStateResult = new HandleNextCharacterResult(plSqlBlockNormalParsingState, true);
    }

    public HandleNextCharacterResult getNextParsingState(Character previousChar, Character currentChar, Character nextChar, StatementBuilder statementBuilder) {
        if (this.isEndOfStatement(previousChar, currentChar, statementBuilder)) {
            return this.endOfStatementResult;
        }
        if (BACKSLASH.equals(currentChar) && this.backSlashEscapingEnabled) {
            return this.toEscapingParsingStateResult;
        }
        if (DASH.equals(currentChar) && DASH.equals(nextChar)) {
            return this.toInLineCommentResult;
        }
        if (SLASH.equals(currentChar) && ASTERIX.equals(nextChar)) {
            return this.toInBlockCommentResult;
        }
        if (this.curlyBraceBlockCommentSupported && OPEN_CURLY_BRACE.equals(currentChar)) {
            return this.toCurlyBraceBlockCommentResult;
        }
        if (SINGLE_QUOTE.equals(currentChar)) {
            return this.toInSingleQuotesStateResult;
        }
        if (DOUBLE_QUOTE.equals(currentChar)) {
            return this.toInDoubleQuotesStateResult;
        }
        if (this.isWhitespace(currentChar) && this.plSqlBlockMatcher.isStartOfPlSqlBlock(statementBuilder.getStatementInUppercaseWithoutCommentsOrWhitespace())) {
            return this.toInPlSqlBlockStateResult;
        }
        if (this.isWhitespace(currentChar) || this.isStatementSeparator(currentChar)) {
            return this.stayInNormalNotExecutableResult;
        }
        return this.stayInNormalExecutableResult;
    }

    protected abstract boolean isStatementSeparator(Character var1);

    protected abstract boolean isEndOfStatement(Character var1, Character var2, StatementBuilder var3);

    protected boolean isWhitespace(Character character) {
        return character == null || Character.isWhitespace(character.charValue());
    }
}

