/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.parser.impl;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbmaintain.script.parser.impl.HandleNextCharacterResult;
import org.dbmaintain.script.parser.parsingstate.ParsingState;
import org.dbmaintain.util.CharacterUtils;

public class StatementBuilder {
    private static final Character CARRIAGE_RETURN = Character.valueOf('\r');
    private static final Character NEWLINE = Character.valueOf('\n');
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    private StringBuilder statement = new StringBuilder();
    private Properties scriptParameters;
    private StringBuilder currentLine = new StringBuilder();
    private StringBuilder statementInUppercaseWithoutCommentsAndWhitespace = new StringBuilder();
    private boolean currentLineHasExecutableContent = false;
    private boolean hasExecutableContent = false;
    private ParsingState currentParsingState;
    private Character previousChar;

    public StatementBuilder(ParsingState initialParsingState, Properties scriptParameters) {
        this.currentParsingState = initialParsingState;
        this.scriptParameters = scriptParameters;
    }

    public void addCharacter(Character currentChar, Character nextChar) {
        HandleNextCharacterResult handleNextCharacterResult = this.currentParsingState.getNextParsingState(this.previousChar, currentChar, nextChar, this);
        this.currentParsingState = handleNextCharacterResult.getNextState();
        if (handleNextCharacterResult.isExecutable()) {
            this.currentLineHasExecutableContent = true;
            this.hasExecutableContent = true;
        }
        if (this.currentParsingState != null) {
            this.appendToCurrentLine(currentChar);
            if (currentChar == null || CharacterUtils.isNewLineCharacter(currentChar)) {
                this.flushCurrentLine();
            }
        }
        this.appendToStatementWithoutCommentsAndWhitespace(currentChar, handleNextCharacterResult);
        this.previousChar = currentChar;
    }

    protected void flushCurrentLine() {
        this.statement.append((CharSequence)this.currentLine);
        this.currentLine = new StringBuilder();
        this.currentLineHasExecutableContent = false;
    }

    protected void appendToCurrentLine(Character currentChar) {
        if (currentChar != null) {
            if (CARRIAGE_RETURN.equals(currentChar)) {
                this.currentLine.append(NEWLINE);
            } else if (!CARRIAGE_RETURN.equals(this.previousChar) || !NEWLINE.equals(currentChar)) {
                this.currentLine.append(currentChar);
            }
        }
    }

    protected void appendToStatementWithoutCommentsAndWhitespace(Character currentChar, HandleNextCharacterResult handleNextCharacterResult) {
        if (handleNextCharacterResult.isExecutable()) {
            if (currentChar != null) {
                this.statementInUppercaseWithoutCommentsAndWhitespace.append(Character.toUpperCase(currentChar.charValue()));
            }
        } else if (this.isWhitespace(currentChar) && this.statementInUppercaseWithoutCommentsAndWhitespace.length() > 0 && this.getLastCharacter(this.statementInUppercaseWithoutCommentsAndWhitespace) != ' ') {
            this.statementInUppercaseWithoutCommentsAndWhitespace.append(' ');
        }
    }

    protected char getLastCharacter(StringBuilder statement) {
        return statement.charAt(statement.length() - 1);
    }

    protected boolean isWhitespace(Character currentChar) {
        return currentChar != null && Character.isWhitespace(currentChar.charValue());
    }

    public String getCurrentLine() {
        return this.currentLine.toString();
    }

    public boolean isComplete() {
        return this.currentParsingState == null;
    }

    public boolean hasExecutableContent() {
        return this.hasExecutableContent;
    }

    public String buildStatement() {
        if (this.currentLineHasExecutableContent) {
            this.flushCurrentLine();
        }
        if (this.scriptParameters != null) {
            this.statement = this.replaceScriptParameters(this.statement);
        }
        return this.statement.toString();
    }

    private StringBuilder replaceScriptParameters(StringBuilder statement) {
        Matcher parameterMatcher = PARAMETER_PATTERN.matcher(statement);
        boolean parameterFound = parameterMatcher.find();
        if (!parameterFound) {
            return statement;
        }
        StringBuffer result = new StringBuffer();
        while (parameterFound) {
            String parameterName = parameterMatcher.group(1);
            String parameterValue = this.scriptParameters.getProperty(parameterName);
            if (parameterValue != null) {
                parameterMatcher.appendReplacement(result, parameterValue);
            }
            parameterFound = parameterMatcher.find();
        }
        parameterMatcher.appendTail(result);
        return new StringBuilder(result);
    }

    public StringBuilder getStatementInUppercaseWithoutCommentsOrWhitespace() {
        return this.statementInUppercaseWithoutCommentsAndWhitespace;
    }
}

