/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.analyzer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbmaintain.script.ExecutedScript;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.analyzer.ScriptUpdate;
import org.dbmaintain.script.analyzer.ScriptUpdateType;
import org.dbmaintain.script.analyzer.ScriptUpdates;
import org.dbmaintain.script.executedscriptinfo.ExecutedScriptInfoSource;
import org.dbmaintain.script.repository.ScriptRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptUpdatesAnalyzer {
    private final ScriptRepository scriptRepository;
    private final ExecutedScriptInfoSource executedScriptInfoSource;
    private final boolean useScriptFileLastModificationDates;
    private final boolean allowOutOfSequenceExecutionOfPatchScripts;
    private final SortedSet<ScriptUpdate> regularlyAddedOrModifiedScripts = new TreeSet<ScriptUpdate>();
    private final SortedSet<ScriptUpdate> irregularlyUpdatedScripts = new TreeSet<ScriptUpdate>();
    private final SortedSet<ScriptUpdate> regularlyDeletedRepeatableScripts = new TreeSet<ScriptUpdate>();
    private final SortedSet<ScriptUpdate> regularlyAddedPatchScripts = new TreeSet<ScriptUpdate>();
    private final SortedSet<ScriptUpdate> regularlyUpdatedPostprocessingScripts = new TreeSet<ScriptUpdate>();
    private final SortedSet<ScriptUpdate> regularlyRenamedScripts = new TreeSet<ScriptUpdate>();
    private final Map<ExecutedScript, Script> renamedIndexedScripts = new HashMap<ExecutedScript, Script>();
    private final Map<Script, ExecutedScript> scriptExecutedScriptMap = new HashMap<Script, ExecutedScript>();
    private Map<String, Script> scriptNameScriptMap;
    private Map<String, Set<Script>> checkSumScriptMap;

    public ScriptUpdatesAnalyzer(ScriptRepository scriptRepository, ExecutedScriptInfoSource executedScriptInfoSource, boolean useScriptFileLastModificationDates, boolean allowOutOfSequenceExecutionOfPatchScripts) {
        this.scriptRepository = scriptRepository;
        this.executedScriptInfoSource = executedScriptInfoSource;
        this.useScriptFileLastModificationDates = useScriptFileLastModificationDates;
        this.allowOutOfSequenceExecutionOfPatchScripts = allowOutOfSequenceExecutionOfPatchScripts;
    }

    public ScriptUpdates calculateScriptUpdates() {
        Script scriptWithSameName;
        for (ExecutedScript executedScript : this.executedScriptInfoSource.getExecutedScripts()) {
            scriptWithSameName = this.findScriptWithSameName(executedScript);
            if (scriptWithSameName == null) continue;
            this.scriptExecutedScriptMap.put(scriptWithSameName, executedScript);
            if (!executedScript.getScript().isScriptContentEqualTo(scriptWithSameName, this.useScriptFileLastModificationDates)) {
                this.registerScriptUpdate(scriptWithSameName);
                continue;
            }
            if (executedScript.isSuccessful().booleanValue() || !executedScript.getScript().isPostProcessingScript()) continue;
            this.registerPostprocessingScriptUpdate(ScriptUpdateType.POSTPROCESSING_SCRIPT_FAILURE_RERUN, scriptWithSameName);
        }
        if (this.scriptExecutedScriptMap.size() < this.executedScriptInfoSource.getExecutedScripts().size()) {
            for (ExecutedScript executedScript : this.executedScriptInfoSource.getExecutedScripts()) {
                scriptWithSameName = this.findScriptWithSameName(executedScript);
                if (scriptWithSameName != null) continue;
                Script newScriptWithSameContent = this.findNewScriptWithSameContent(executedScript);
                if (newScriptWithSameContent != null) {
                    this.registerScriptRename(executedScript, newScriptWithSameContent);
                    continue;
                }
                this.registerScriptDeletion(executedScript.getScript());
            }
            if (this.sequenceOfIndexedScriptsChangedDueToRenames()) {
                this.registerIrregularIncrementalScriptRenames();
            } else {
                this.registerRegularIncrementalScriptRenames();
            }
        }
        for (Script script : this.scriptRepository.getAllScripts()) {
            if (this.scriptExecutedScriptMap.containsKey(script)) continue;
            this.registerScriptAddition(script);
        }
        return new ScriptUpdates(this.regularlyAddedOrModifiedScripts, this.irregularlyUpdatedScripts, this.regularlyDeletedRepeatableScripts, this.regularlyAddedPatchScripts, this.regularlyUpdatedPostprocessingScripts, this.regularlyRenamedScripts);
    }

    protected void registerScriptAddition(Script script) {
        if (script.isIncremental()) {
            Script scriptWithHighestScriptIndex = this.getExecutedScriptWithHighestScriptIndex();
            if (scriptWithHighestScriptIndex == null || script.compareTo(scriptWithHighestScriptIndex) > 0) {
                this.registerRegularScriptUpdate(ScriptUpdateType.HIGHER_INDEX_SCRIPT_ADDED, script);
            } else if (script.isPatchScript()) {
                if (this.allowOutOfSequenceExecutionOfPatchScripts) {
                    this.registerRegularlyAddedPatchScript(ScriptUpdateType.LOWER_INDEX_PATCH_SCRIPT_ADDED, script);
                } else {
                    this.registerIrregularScriptUpdate(ScriptUpdateType.LOWER_INDEX_PATCH_SCRIPT_ADDED, script);
                }
            } else {
                this.registerIrregularScriptUpdate(ScriptUpdateType.LOWER_INDEX_NON_PATCH_SCRIPT_ADDED, script);
            }
        } else if (script.isRepeatable()) {
            this.registerRegularScriptUpdate(ScriptUpdateType.REPEATABLE_SCRIPT_ADDED, script);
        } else if (script.isPostProcessingScript()) {
            this.registerPostprocessingScriptUpdate(ScriptUpdateType.POSTPROCESSING_SCRIPT_ADDED, script);
        }
    }

    protected void registerScriptUpdate(Script script) {
        if (script.isIncremental()) {
            this.registerIrregularScriptUpdate(ScriptUpdateType.INDEXED_SCRIPT_UPDATED, script);
        } else if (script.isRepeatable()) {
            this.registerRegularScriptUpdate(ScriptUpdateType.REPEATABLE_SCRIPT_UPDATED, script);
        } else if (script.isPostProcessingScript()) {
            this.registerPostprocessingScriptUpdate(ScriptUpdateType.POSTPROCESSING_SCRIPT_UPDATED, script);
        }
    }

    protected void registerScriptDeletion(Script deletedScript) {
        if (deletedScript.isIncremental()) {
            this.registerIrregularScriptUpdate(ScriptUpdateType.INDEXED_SCRIPT_DELETED, deletedScript);
        } else if (deletedScript.isRepeatable()) {
            this.registerRepeatableScriptDeletion(deletedScript);
        } else if (deletedScript.isPostProcessingScript()) {
            this.registerPostprocessingScriptUpdate(ScriptUpdateType.POSTPROCESSING_SCRIPT_DELETED, deletedScript);
        }
    }

    protected void registerScriptRename(ExecutedScript executedScript, Script renamedTo) {
        if (executedScript.getScript().isIncremental() && renamedTo.isIncremental()) {
            this.scriptExecutedScriptMap.put(renamedTo, executedScript);
            this.renamedIndexedScripts.put(executedScript, renamedTo);
        } else if (executedScript.getScript().isRepeatable() && renamedTo.isRepeatable()) {
            this.scriptExecutedScriptMap.put(renamedTo, executedScript);
            this.registerRegularScriptRename(ScriptUpdateType.REPEATABLE_SCRIPT_RENAMED, executedScript.getScript(), renamedTo);
        } else if (executedScript.getScript().isPostProcessingScript() && renamedTo.isPostProcessingScript()) {
            this.scriptExecutedScriptMap.put(renamedTo, executedScript);
            this.registerPostprocessingScriptRename(ScriptUpdateType.POSTPROCESSING_SCRIPT_RENAMED, executedScript.getScript(), renamedTo);
        }
    }

    protected boolean sequenceOfIndexedScriptsChangedDueToRenames() {
        Iterator indexedScriptsIterator = this.scriptRepository.getIndexedScripts().iterator();
        for (ExecutedScript executedScript : this.executedScriptInfoSource.getExecutedScripts()) {
            Script scriptInNewSequence = this.renamedIndexedScripts.get(executedScript);
            if (scriptInNewSequence == null) {
                scriptInNewSequence = executedScript.getScript();
            }
            boolean foundScriptInNewSequenceInIndexedScripts = false;
            while (!foundScriptInNewSequenceInIndexedScripts) {
                if (!indexedScriptsIterator.hasNext()) {
                    return true;
                }
                if (!scriptInNewSequence.equals(indexedScriptsIterator.next())) continue;
                foundScriptInNewSequenceInIndexedScripts = true;
            }
        }
        return false;
    }

    protected void registerRegularIncrementalScriptRenames() {
        for (ExecutedScript renamedIndexedExecutedScript : this.renamedIndexedScripts.keySet()) {
            this.registerRegularScriptRename(ScriptUpdateType.INDEXED_SCRIPT_RENAMED, renamedIndexedExecutedScript.getScript(), this.renamedIndexedScripts.get(renamedIndexedExecutedScript));
        }
    }

    protected void registerIrregularIncrementalScriptRenames() {
        for (ExecutedScript renamedIndexedExecutedScript : this.renamedIndexedScripts.keySet()) {
            this.registerIrregularScriptUpdate(ScriptUpdateType.INDEXED_SCRIPT_RENAMED_SCRIPT_SEQUENCE_CHANGED, renamedIndexedExecutedScript.getScript(), this.renamedIndexedScripts.get(renamedIndexedExecutedScript));
        }
    }

    protected Script findNewScriptWithSameContent(ExecutedScript executedScript) {
        TreeSet<Script> newScriptsWithSameContent = new TreeSet<Script>();
        Set<Script> scriptsWithSameContent = this.getCheckSumScriptMap().get(executedScript.getScript().getCheckSum());
        if (scriptsWithSameContent != null) {
            for (Script scriptWithSameContent : scriptsWithSameContent) {
                if (this.scriptExecutedScriptMap.containsKey(scriptWithSameContent)) continue;
                newScriptsWithSameContent.add(scriptWithSameContent);
            }
        }
        if (newScriptsWithSameContent.size() == 1) {
            return (Script)newScriptsWithSameContent.first();
        }
        return null;
    }

    protected Script findScriptWithSameName(ExecutedScript executedScript) {
        return this.getScriptNameScriptMap().get(executedScript.getScript().getFileName());
    }

    protected Map<String, ExecutedScript> getScriptNameExecutedScriptMap() {
        HashMap<String, ExecutedScript> scriptNameAlreadyExecutedScriptMap = new HashMap<String, ExecutedScript>();
        for (ExecutedScript executedScript : this.executedScriptInfoSource.getExecutedScripts()) {
            scriptNameAlreadyExecutedScriptMap.put(executedScript.getScript().getFileName(), executedScript);
        }
        return scriptNameAlreadyExecutedScriptMap;
    }

    protected Map<String, Script> getScriptNameScriptMap() {
        if (this.scriptNameScriptMap == null) {
            this.scriptNameScriptMap = new HashMap<String, Script>();
            for (Script script : this.scriptRepository.getAllScripts()) {
                this.scriptNameScriptMap.put(script.getFileName(), script);
            }
        }
        return this.scriptNameScriptMap;
    }

    protected Map<String, Set<Script>> getCheckSumScriptMap() {
        if (this.checkSumScriptMap == null) {
            this.checkSumScriptMap = new HashMap<String, Set<Script>>();
            for (Script script : this.scriptRepository.getAllScripts()) {
                Set<Script> scriptsWithCheckSum = this.checkSumScriptMap.get(script.getCheckSum());
                if (scriptsWithCheckSum == null) {
                    scriptsWithCheckSum = new HashSet<Script>();
                    this.checkSumScriptMap.put(script.getCheckSum(), scriptsWithCheckSum);
                }
                scriptsWithCheckSum.add(script);
            }
        }
        return this.checkSumScriptMap;
    }

    protected Script getExecutedScriptWithHighestScriptIndex() {
        Script result = null;
        for (ExecutedScript executedScript : this.executedScriptInfoSource.getExecutedScripts()) {
            if (!executedScript.getScript().isIncremental() || result != null && executedScript.getScript().compareTo(result) <= 0) continue;
            result = executedScript.getScript();
        }
        return result;
    }

    protected void registerRegularScriptUpdate(ScriptUpdateType scriptUpdateType, Script script) {
        this.regularlyAddedOrModifiedScripts.add(new ScriptUpdate(scriptUpdateType, script));
    }

    protected void registerIrregularScriptUpdate(ScriptUpdateType scriptUpdateType, Script script) {
        this.irregularlyUpdatedScripts.add(new ScriptUpdate(scriptUpdateType, script));
    }

    protected void registerIrregularScriptUpdate(ScriptUpdateType scriptUpdateType, Script script1, Script script2) {
        this.irregularlyUpdatedScripts.add(new ScriptUpdate(scriptUpdateType, script1, script2));
    }

    protected void registerRepeatableScriptDeletion(Script script) {
        this.regularlyDeletedRepeatableScripts.add(new ScriptUpdate(ScriptUpdateType.REPEATABLE_SCRIPT_DELETED, script));
    }

    protected void registerRegularlyAddedPatchScript(ScriptUpdateType scriptUpdateType, Script script) {
        this.regularlyAddedPatchScripts.add(new ScriptUpdate(scriptUpdateType, script));
    }

    protected void registerPostprocessingScriptUpdate(ScriptUpdateType scriptUpdateType, Script script) {
        this.regularlyUpdatedPostprocessingScripts.add(new ScriptUpdate(scriptUpdateType, script));
    }

    protected void registerPostprocessingScriptRename(ScriptUpdateType scriptUpdateType, Script originalScript, Script renamedToScript) {
        this.regularlyUpdatedPostprocessingScripts.add(new ScriptUpdate(scriptUpdateType, originalScript, renamedToScript));
    }

    protected void registerRegularScriptRename(ScriptUpdateType scriptUpdateType, Script originalScript, Script renamedScript) {
        this.regularlyRenamedScripts.add(new ScriptUpdate(scriptUpdateType, originalScript, renamedScript));
    }
}

