/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.SQLHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db2Database
extends Database {
    public Db2Database(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        super(databaseConnection, identifierProcessor);
    }

    @Override
    public String getSupportedDatabaseDialect() {
        return "db2";
    }

    @Override
    public Set<String> getTableNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select TABNAME from SYSCAT.TABLES where TABSCHEMA = '" + schemaName + "' and TYPE = 'T'", this.getDataSource());
    }

    @Override
    public Set<String> getColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where TABNAME = '" + tableName + "' and TABSCHEMA = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select TABNAME from SYSCAT.TABLES where TABSCHEMA = '" + schemaName + "' and TYPE = 'V'", this.getDataSource());
    }

    @Override
    public Set<String> getSequenceNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select SEQNAME from SYSCAT.SEQUENCES where SEQTYPE = 'S' AND SEQSCHEMA = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getTriggerNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select TRIGNAME from SYSCAT.TRIGGERS where TRIGSCHEMA = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getTypeNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select TYPENAME from SYSCAT.DATATYPES where TYPESCHEMA = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void disableReferentialConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(schemaName, tableName);
        }
    }

    protected void disableReferentialConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select CONSTNAME from SYSCAT.TABCONST where TYPE = 'F' and TABNAME = '" + tableName + "' and TABSCHEMA = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName), this.getDataSource());
        }
    }

    @Override
    public void disableValueConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableValueConstraints(schemaName, tableName);
        }
    }

    protected void disableValueConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select CONSTNAME from SYSCAT.TABCONST where TYPE in ('K', 'U') and TABNAME = '" + tableName + "' and TABSCHEMA = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName), this.getDataSource());
        }
        Set<String> primaryKeyColumnNames = sqlHandler.getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where KEYSEQ is not null and TABNAME = '" + tableName + "' and TABSCHEMA = '" + schemaName + "'", this.getDataSource());
        Set<String> notNullColumnNames = sqlHandler.getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where NULLS = 'N' and TABNAME = '" + tableName + "' and TABSCHEMA = '" + schemaName + "'", this.getDataSource());
        for (String notNullColumnName : notNullColumnNames) {
            if (primaryKeyColumnNames.contains(notNullColumnName)) continue;
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " alter column " + this.quoted(notNullColumnName) + " drop not null", this.getDataSource());
            sqlHandler.execute("call SYSPROC.ADMIN_CMD('REORG TABLE " + this.qualified(schemaName, tableName) + "')", this.getDataSource());
        }
    }

    @Override
    public long getSequenceValue(String schemaName, String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select next value for " + this.qualified(schemaName, sequenceName) + " from SYSIBM.SYSDUMMY1", this.getDataSource());
    }

    @Override
    public void incrementSequenceToValue(String schemaName, String sequenceName, long newSequenceValue) {
        this.getSQLHandler().execute("alter sequence " + this.qualified(schemaName, sequenceName) + " restart with " + newSequenceValue, this.getDataSource());
    }

    @Override
    public Set<String> getIdentityColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLNAME from SYSCAT.COLUMNS where KEYSEQ is not null and TABNAME = '" + tableName + "' and TABSCHEMA = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void incrementIdentityColumnToValue(String schemaName, String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().execute("alter table " + this.qualified(schemaName, tableName) + " alter column " + this.quoted(identityColumnName) + " restart with " + identityValue, this.getDataSource());
    }

    @Override
    public void setDatabaseDefaultSchema() {
        this.getSQLHandler().execute("set schema " + this.getDefaultSchemaName(), this.getDataSource());
    }

    @Override
    public void setSettingIdentityColumnValueEnabled(String schemaName, String tableName, boolean enabled) {
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }

    @Override
    public boolean supportsSetDatabaseDefaultSchema() {
        return true;
    }
}

