/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.utils.Utils;

public class ConfigDef {
    private static final Object NO_DEFAULT_VALUE = new String("");
    private final Map<String, ConfigKey> configKeys = new HashMap<String, ConfigKey>();

    public Set<String> names() {
        return Collections.unmodifiableSet(this.configKeys.keySet());
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation) {
        if (this.configKeys.containsKey(name)) {
            throw new ConfigException("Configuration " + name + " is defined twice.");
        }
        Object parsedDefault = defaultValue == NO_DEFAULT_VALUE ? NO_DEFAULT_VALUE : this.parseType(name, defaultValue, type);
        this.configKeys.put(name, new ConfigKey(name, type, parsedDefault, validator, importance, documentation));
        return this;
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation) {
        return this.define(name, type, defaultValue, null, importance, documentation);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation);
    }

    public ConfigDef withClientSslSupport() {
        SslConfigs.addClientSslSupport(this);
        return this;
    }

    public ConfigDef withClientSaslSupport() {
        SaslConfigs.addClientSaslSupport(this);
        return this;
    }

    public Map<String, Object> parse(Map<?, ?> props) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (ConfigKey key : this.configKeys.values()) {
            Object value2;
            if (props.containsKey(key.name)) {
                value2 = this.parseType(key.name, props.get(key.name), key.type);
            } else {
                if (key.defaultValue == NO_DEFAULT_VALUE) {
                    throw new ConfigException("Missing required configuration \"" + key.name + "\" which has no default value.");
                }
                value2 = key.defaultValue;
            }
            if (key.validator != null) {
                key.validator.ensureValid(key.name, value2);
            }
            values.put(key.name, value2);
        }
        return values;
    }

    private Object parseType(String name, Object value2, Type type) {
        try {
            if (value2 == null) {
                return null;
            }
            String trimmed = null;
            if (value2 instanceof String) {
                trimmed = ((String)value2).trim();
            }
            switch (type) {
                case BOOLEAN: {
                    if (value2 instanceof String) {
                        if (trimmed.equalsIgnoreCase("true")) {
                            return true;
                        }
                        if (trimmed.equalsIgnoreCase("false")) {
                            return false;
                        }
                        throw new ConfigException(name, value2, "Expected value to be either true or false");
                    }
                    if (value2 instanceof Boolean) {
                        return value2;
                    }
                    throw new ConfigException(name, value2, "Expected value to be either true or false");
                }
                case PASSWORD: {
                    if (value2 instanceof Password) {
                        return value2;
                    }
                    if (value2 instanceof String) {
                        return new Password(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be a string, but it was a " + value2.getClass().getName());
                }
                case STRING: {
                    if (value2 instanceof String) {
                        return trimmed;
                    }
                    throw new ConfigException(name, value2, "Expected value to be a string, but it was a " + value2.getClass().getName());
                }
                case INT: {
                    if (value2 instanceof Integer) {
                        return (Integer)value2;
                    }
                    if (value2 instanceof String) {
                        return Integer.parseInt(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case SHORT: {
                    if (value2 instanceof Short) {
                        return (Short)value2;
                    }
                    if (value2 instanceof String) {
                        return Short.parseShort(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case LONG: {
                    if (value2 instanceof Integer) {
                        return ((Integer)value2).longValue();
                    }
                    if (value2 instanceof Long) {
                        return (Long)value2;
                    }
                    if (value2 instanceof String) {
                        return Long.parseLong(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case DOUBLE: {
                    if (value2 instanceof Number) {
                        return ((Number)value2).doubleValue();
                    }
                    if (value2 instanceof String) {
                        return Double.parseDouble(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case LIST: {
                    if (value2 instanceof List) {
                        return (List)value2;
                    }
                    if (value2 instanceof String) {
                        if (trimmed.isEmpty()) {
                            return Collections.emptyList();
                        }
                        return Arrays.asList(trimmed.split("\\s*,\\s*", -1));
                    }
                    throw new ConfigException(name, value2, "Expected a comma separated list.");
                }
                case CLASS: {
                    if (value2 instanceof Class) {
                        return (Class)value2;
                    }
                    if (value2 instanceof String) {
                        return Class.forName(trimmed, true, Utils.getContextOrKafkaClassLoader());
                    }
                    throw new ConfigException(name, value2, "Expected a Class instance or class name.");
                }
            }
            throw new IllegalStateException("Unknown type.");
        }
        catch (NumberFormatException e) {
            throw new ConfigException(name, value2, "Not a number of type " + (Object)((Object)type));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(name, value2, "Class " + value2 + " could not be found.");
        }
    }

    public String toHtmlTable() {
        ArrayList<ConfigKey> configs = new ArrayList<ConfigKey>(this.configKeys.values());
        Collections.sort(configs, new Comparator<ConfigKey>(){

            @Override
            public int compare(ConfigKey k1, ConfigKey k2) {
                if (!k1.hasDefault() && k2.hasDefault()) {
                    return -1;
                }
                if (!k2.hasDefault() && k1.hasDefault()) {
                    return 1;
                }
                int cmp = k1.importance.compareTo(k2.importance);
                if (cmp == 0) {
                    return k1.name.compareTo(k2.name);
                }
                return cmp;
            }
        });
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>\n");
        b.append("<th>Name</th>\n");
        b.append("<th>Description</th>\n");
        b.append("<th>Type</th>\n");
        b.append("<th>Default</th>\n");
        b.append("<th>Valid Values</th>\n");
        b.append("<th>Importance</th>\n");
        b.append("</tr>\n");
        for (ConfigKey def : configs) {
            b.append("<tr>\n");
            b.append("<td>");
            b.append(def.name);
            b.append("</td>");
            b.append("<td>");
            b.append(def.documentation);
            b.append("</td>");
            b.append("<td>");
            b.append(def.type.toString().toLowerCase());
            b.append("</td>");
            b.append("<td>");
            if (def.hasDefault()) {
                if (def.defaultValue == null) {
                    b.append("null");
                } else if (def.type == Type.STRING && def.defaultValue.toString().isEmpty()) {
                    b.append("\"\"");
                } else {
                    b.append(def.defaultValue);
                }
            } else {
                b.append("");
            }
            b.append("</td>");
            b.append("<td>");
            b.append(def.validator != null ? def.validator.toString() : "");
            b.append("</td>");
            b.append("<td>");
            b.append(def.importance.toString().toLowerCase());
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</tbody></table>");
        return b.toString();
    }

    private static class ConfigKey {
        public final String name;
        public final Type type;
        public final String documentation;
        public final Object defaultValue;
        public final Validator validator;
        public final Importance importance;

        public ConfigKey(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
            this.validator = validator;
            this.importance = importance;
            if (this.validator != null) {
                this.validator.ensureValid(name, defaultValue);
            }
            this.documentation = documentation;
        }

        public boolean hasDefault() {
            return this.defaultValue != NO_DEFAULT_VALUE;
        }
    }

    public static class ValidString
    implements Validator {
        List<String> validStrings;

        private ValidString(List<String> validStrings) {
            this.validStrings = validStrings;
        }

        public static ValidString in(String ... validStrings) {
            return new ValidString(Arrays.asList(validStrings));
        }

        @Override
        public void ensureValid(String name, Object o) {
            String s2 = (String)o;
            if (!this.validStrings.contains(s2)) {
                throw new ConfigException(name, o, "String must be one of: " + Utils.join(this.validStrings, ", "));
            }
        }

        public String toString() {
            return "[" + Utils.join(this.validStrings, ", ") + "]";
        }
    }

    public static class Range
    implements Validator {
        private final Number min;
        private final Number max;

        private Range(Number min2, Number max2) {
            this.min = min2;
            this.max = max2;
        }

        public static Range atLeast(Number min2) {
            return new Range(min2, null);
        }

        public static Range between(Number min2, Number max2) {
            return new Range(min2, max2);
        }

        @Override
        public void ensureValid(String name, Object o) {
            Number n = (Number)o;
            if (this.min != null && n.doubleValue() < this.min.doubleValue()) {
                throw new ConfigException(name, o, "Value must be at least " + this.min);
            }
            if (this.max != null && n.doubleValue() > this.max.doubleValue()) {
                throw new ConfigException(name, o, "Value must be no more than " + this.max);
            }
        }

        public String toString() {
            if (this.min == null) {
                return "[...," + this.max + "]";
            }
            if (this.max == null) {
                return "[" + this.min + ",...]";
            }
            return "[" + this.min + ",...," + this.max + "]";
        }
    }

    public static interface Validator {
        public void ensureValid(String var1, Object var2);
    }

    public static enum Importance {
        HIGH,
        MEDIUM,
        LOW;

    }

    public static enum Type {
        BOOLEAN,
        STRING,
        INT,
        SHORT,
        LONG,
        DOUBLE,
        LIST,
        CLASS,
        PASSWORD;

    }
}

