/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.harisekhon.kafka;

import com.linkedin.harisekhon.CLI;
import com.linkedin.harisekhon.Utils;
import com.linkedin.harisekhon.kafka.CheckKafka$;
import java.io.File;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055x!B\u0001\u0003\u0011\u0003Y\u0011AC\"iK\u000e\\7*\u00194lC*\u00111\u0001B\u0001\u0006W\u000647.\u0019\u0006\u0003\u000b\u0019\t!\u0002[1sSN,7\u000e[8o\u0015\t9\u0001\"\u0001\u0005mS:\\W\rZ5o\u0015\u0005I\u0011aA2p[\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!AC\"iK\u000e\\7*\u00194lCN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\t\u0019\u0011\t\u001d9\t\u000biiA\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005Ya\u0001\u0002\b\u0003\u0001u\u0019\"\u0001\b\u0010\u0011\u0005}\u0001S\"\u0001\u0003\n\u0005\u0005\"!aA\"M\u0013\")!\u0004\bC\u0001GQ\tA\u0005\u0005\u0002\r9!9a\u0005\ba\u0001\n\u00039\u0013a\u00022s_.,'o]\u000b\u0002QA\u0011\u0011\u0006\f\b\u0003#)J!a\u000b\n\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003WIAq\u0001\r\u000fA\u0002\u0013\u0005\u0011'A\u0006ce>\\WM]:`I\u0015\fHC\u0001\u001a6!\t\t2'\u0003\u00025%\t!QK\\5u\u0011\u001d1t&!AA\u0002!\n1\u0001\u001f\u00132\u0011\u0019AD\u0004)Q\u0005Q\u0005A!M]8lKJ\u001c\b\u0005C\u0004;9\u0001\u0007I\u0011A\u0014\u0002\u000bQ|\u0007/[2\t\u000fqb\u0002\u0019!C\u0001{\u0005IAo\u001c9jG~#S-\u001d\u000b\u0003eyBqAN\u001e\u0002\u0002\u0003\u0007\u0001\u0006\u0003\u0004A9\u0001\u0006K\u0001K\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f\tc\u0002\u0019!C\u0001\u0007\u0006I\u0001/\u0019:uSRLwN\\\u000b\u0002\tB\u0011\u0011#R\u0005\u0003\rJ\u00111!\u00138u\u0011\u001dAE\u00041A\u0005\u0002%\u000bQ\u0002]1si&$\u0018n\u001c8`I\u0015\fHC\u0001\u001aK\u0011\u001d1t)!AA\u0002\u0011Ca\u0001\u0014\u000f!B\u0013!\u0015A\u00039beRLG/[8oA!9a\n\ba\u0001\n\u0003y\u0015A\u00037bgR|eMZ:fiV\t\u0001\u000b\u0005\u0002\u0012#&\u0011!K\u0005\u0002\u0005\u0019>tw\rC\u0004U9\u0001\u0007I\u0011A+\u0002\u001d1\f7\u000f^(gMN,Go\u0018\u0013fcR\u0011!G\u0016\u0005\bmM\u000b\t\u00111\u0001Q\u0011\u0019AF\u0004)Q\u0005!\u0006YA.Y:u\u001f\u001a47/\u001a;!\u0011\u001dQF\u00041A\u0005\u0002m\u000b!B[1bg\u000e{gNZ5h+\u0005a\u0006cA\t^Q%\u0011aL\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0001d\u0002\u0019!C\u0001C\u0006q!.Y1t\u0007>tg-[4`I\u0015\fHC\u0001\u001ac\u0011\u001d1t,!AA\u0002qCa\u0001\u001a\u000f!B\u0013a\u0016a\u00036bCN\u001cuN\u001c4jO\u0002BqA\u001a\u000fC\u0002\u0013\u0005q-A\u0007d_:\u001cX/\\3s!J|\u0007o]\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005kRLGNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=T'A\u0003)s_B,'\u000f^5fg\"1\u0011\u000f\bQ\u0001\n!\fabY8ogVlWM\u001d)s_B\u001c\b\u0005C\u0004t9\t\u0007I\u0011A4\u0002\u001bA\u0014x\u000eZ;dKJ\u0004&o\u001c9t\u0011\u0019)H\u0004)A\u0005Q\u0006q\u0001O]8ek\u000e,'\u000f\u0015:paN\u0004\u0003bB<\u001d\u0005\u0004%\t\u0001_\u0001\u0013aJ|G-^2feB\u0013x\u000e]3si&,7/F\u0001z!\r\tRL\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{2\f!![8\n\u0005}d(aC%oaV$8\u000b\u001e:fC6Dq!a\u0001\u001dA\u0003%\u00110A\nqe>$WoY3s!J|\u0007/\u001a:uS\u0016\u001c\b\u0005\u0003\u0005\u0002\bq\u0011\r\u0011\"\u0001y\u0003I\u0019wN\\:v[\u0016\u0014\bK]8qKJ$\u0018.Z:\t\u000f\u0005-A\u0004)A\u0005s\u0006\u00192m\u001c8tk6,'\u000f\u0015:pa\u0016\u0014H/[3tA!I\u0011q\u0002\u000fC\u0002\u0013\u0005\u0011\u0011C\u0001\u0005kVLG-\u0006\u0002\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a1\fA\u0001\\1oO&\u0019Q&a\u0006\t\u0011\u0005}A\u0004)A\u0005\u0003'\tQ!^;jI\u0002B\u0001\"a\t\u001d\u0005\u0004%\taT\u0001\u0006KB|7\r\u001b\u0005\b\u0003Oa\u0002\u0015!\u0003Q\u0003\u0019)\u0007o\\2iA!I\u00111\u0006\u000fC\u0002\u0013\u0005\u0011\u0011C\u0001\u0005I\u0006$X\r\u0003\u0005\u00020q\u0001\u000b\u0011BA\n\u0003\u0015!\u0017\r^3!\u0011!\t\u0019\u0004\bb\u0001\n\u00039\u0013AA5e\u0011\u001d\t9\u0004\bQ\u0001\n!\n1!\u001b3!\u0011!\tY\u0004\bb\u0001\n\u00039\u0013aA7tO\"9\u0011q\b\u000f!\u0002\u0013A\u0013\u0001B7tO\u0002Bq!a\u0011\u001d\t\u0003\n)%\u0001\u0006bI\u0012|\u0005\u000f^5p]N$\u0012A\r\u0005\b\u0003\u0013bB\u0011IA#\u0003-\u0001(o\\2fgN\f%oZ:\t\u000f\u00055C\u0004\"\u0001\u0002F\u0005IAn\\1e!J|\u0007o\u001d\u0005\b\u0003#bB\u0011AA#\u0003%\u0019X\r^;q\u0015\u0006\f7\u000fC\u0004\u0002Vq!\t%!\u0012\u0002\u0007I,h\u000eC\u0004\u0002Zq!\t!!\u0012\u0002\u000fI,h\u000eV3ti\"9\u0011Q\f\u000f\u0005\u0002\u0005}\u0013!C:vEN\u001c'/\u001b2f)\u001d\u0011\u0014\u0011MA?\u0003\u007fB\u0001\"a\u0019\u0002\\\u0001\u0007\u0011QM\u0001\tG>t7/^7feB1\u0011qMA=Q!j!!!\u001b\u000b\t\u0005\r\u00141\u000e\u0006\u0005\u0003[\ny'A\u0004dY&,g\u000e^:\u000b\u0007\r\t\tH\u0003\u0003\u0002t\u0005U\u0014AB1qC\u000eDWM\u0003\u0002\u0002x\u0005\u0019qN]4\n\t\u0005m\u0014\u0011\u000e\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\t\u0011i\nY\u0006%AA\u0002!B\u0001BQA.!\u0003\u0005\r\u0001\u0012\u0005\b\u0003\u0007cB\u0011AAC\u0003\u001d\u0001(o\u001c3vG\u0016$\u0012BMAD\u0003+\u000b9*!'\t\u0011\u0005%\u0015\u0011\u0011a\u0001\u0003\u0017\u000b\u0001\u0002\u001d:pIV\u001cWM\u001d\t\u0007\u0003\u001b\u000b\t\n\u000b\u0015\u000e\u0005\u0005=%\u0002BAE\u0003WJA!a%\u0002\u0010\ni1*\u00194lCB\u0013x\u000eZ;dKJD\u0001BOAA!\u0003\u0005\r\u0001\u000b\u0005\t\u0005\u0006\u0005\u0005\u0013!a\u0001\t\"I\u00111HAA!\u0003\u0005\r\u0001\u000b\u0005\b\u0003;cB\u0011AAP\u0003\u001d\u0019wN\\:v[\u0016$rAMAQ\u0003G\u000b)\u000b\u0003\u0005\u0002d\u0005m\u0005\u0019AA3\u0011!Q\u00141\u0014I\u0001\u0002\u0004A\u0003\u0002\u0003\"\u0002\u001cB\u0005\t\u0019\u0001#\t\u000f\u0005%F\u0004\"\u0001\u0002,\u0006aq-\u001a;SK\u000e|'\u000fZ'tOR\u0019A,!,\t\u0011\u0005=\u0016q\u0015a\u0001\u0003c\u000bqA]3d_J$7\u000f\u0005\u0004\u0002h\u0005M\u0006\u0006K\u0005\u0005\u0003k\u000bIGA\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3t\u0011%\tI\fHI\u0001\n\u0003\tY,A\ntk\n\u001c8M]5cK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002>*\u001a\u0001&a0,\u0005\u0005\u0005\u0007\u0003BAb\u0003\u001bl!!!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a3\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\f)MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a5\u001d#\u0003%\t!!6\u0002'M,(m]2sS\n,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005]'f\u0001#\u0002@\"I\u00111\u001c\u000f\u0012\u0002\u0013\u0005\u00111X\u0001\u0012aJ|G-^2fI\u0011,g-Y;mi\u0012\u0012\u0004\"CAp9E\u0005I\u0011AAk\u0003E\u0001(o\u001c3vG\u0016$C-\u001a4bk2$He\r\u0005\n\u0003Gd\u0012\u0013!C\u0001\u0003w\u000b\u0011\u0003\u001d:pIV\u001cW\r\n3fM\u0006,H\u000e\u001e\u00135\u0011%\t9\u000fHI\u0001\n\u0003\tY,A\td_:\u001cX/\\3%I\u00164\u0017-\u001e7uIIB\u0011\"a;\u001d#\u0003%\t!!6\u0002#\r|gn];nK\u0012\"WMZ1vYR$3\u0007")
public class CheckKafka
extends CLI {
    private String brokers = "";
    private String topic = "";
    private int partition = 0;
    private long lastOffset = 0L;
    private Option<String> jaasConfig = None$.MODULE$;
    private final Properties consumerProps = new Properties();
    private final Properties producerProps = new Properties();
    private final Option<InputStream> producerProperties;
    private final Option<InputStream> consumerProperties;
    private final String uuid;
    private final long epoch;
    private final String date;
    private final String id;
    private final String msg;

    public static void main(String[] stringArray) {
        CheckKafka$.MODULE$.main(stringArray);
    }

    public static void delayedInit(Function0<BoxedUnit> function0) {
        CheckKafka$.MODULE$.delayedInit(function0);
    }

    public static String[] args() {
        return CheckKafka$.MODULE$.args();
    }

    public static void scala$App$_setter_$executionStart_$eq(long l) {
        CheckKafka$.MODULE$.scala$App$_setter_$executionStart_$eq(l);
    }

    public static long executionStart() {
        return CheckKafka$.MODULE$.executionStart();
    }

    public String brokers() {
        return this.brokers;
    }

    public void brokers_$eq(String x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String x$1) {
        this.topic = x$1;
    }

    public int partition() {
        return this.partition;
    }

    public void partition_$eq(int x$1) {
        this.partition = x$1;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long x$1) {
        this.lastOffset = x$1;
    }

    public Option<String> jaasConfig() {
        return this.jaasConfig;
    }

    public void jaasConfig_$eq(Option<String> x$1) {
        this.jaasConfig = x$1;
    }

    public Properties consumerProps() {
        return this.consumerProps;
    }

    public Properties producerProps() {
        return this.producerProps;
    }

    public Option<InputStream> producerProperties() {
        return this.producerProperties;
    }

    public Option<InputStream> consumerProperties() {
        return this.consumerProperties;
    }

    public String uuid() {
        return this.uuid;
    }

    public long epoch() {
        return this.epoch;
    }

    public String date() {
        return this.date;
    }

    public String id() {
        return this.id;
    }

    public String msg() {
        return this.msg;
    }

    @Override
    public void addOptions() {
        this.options.addOption("B", "brokers", true, "Kafka broker list in the format host1:port1,host2:port2 ...");
        this.options.addOption("T", "topic", true, "Kafka topic to test");
        this.options.addOption("P", "partition", true, "Kafka partition to test (default: 0)");
        this.options.addOption("l", "list-topics", false, "List Kafka topics and exit");
        this.options.addOption("p", "list-partitions", false, "List Kafka partitions for the given topic and exit (requires --topic)");
        this.options.addOption("K", "kerberos-plaintext", false, "Use Kerberos");
        this.options.addOption("S", "kerberos-ssl", false, "Use Kerberos + SSL");
    }

    @Override
    public void processArgs() {
        Object object;
        Object object2;
        if (this.cmd.hasOption("brokers")) {
            this.brokers_$eq(this.cmd.getOptionValue("brokers", ""));
        }
        Utils.validateNodePortList(this.brokers(), "kafka");
        if (this.cmd.hasOption("topic")) {
            this.topic_$eq(this.cmd.getOptionValue("topic", ""));
        }
        if (this.topic().isEmpty()) {
            this.usage("topic not defined");
        }
        String partitionStr = this.cmd.getOptionValue("partition", "0");
        Utils.validateInt(this.partition(), "partition", 0, 10000);
        this.partition_$eq(Integer.parseInt(partitionStr));
        if (this.cmd.hasOption("kerberos-plaintext")) {
            this.consumerProps().put("security.protocol", "SASL_PLAINTEXT");
            object2 = this.producerProps().put("security.protocol", "SASL_PLAINTEXT");
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (this.cmd.hasOption("kerberos-ssl")) {
            this.consumerProps().put("security.protocol", "SASL_SSL");
            object = this.producerProps().put("security.protocol", "SASL_SSL");
        } else {
            object = BoxedUnit.UNIT;
        }
        this.loadProps();
        this.setupJaas();
    }

    public void loadProps() {
        this.consumerProps().put("bootstrap.servers", this.brokers());
        this.producerProps().put("bootstrap.servers", this.brokers());
        Properties consumerPropsArgs = (Properties)this.consumerProps().clone();
        this.consumerProps().load(this.consumerProperties().get());
        if (Utils.log.isDebugEnabled()) {
            Utils.log.debug("Loaded Consumer Properties from resource file:");
            JavaConversions$.MODULE$.propertiesAsScalaMap(this.consumerProps()).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = tuple2._1();
                        String v = tuple2._2();
                        Utils.log.debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{k, v})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            Utils.log.debug("Loading Consumer Property args:");
            JavaConversions$.MODULE$.propertiesAsScalaMap(consumerPropsArgs).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x0$2) {
                    Tuple2<String, String> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String k = tuple2._1();
                        String v = tuple2._2();
                        Utils.log.debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{k, v})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
        PipedInputStream consumerIn = new PipedInputStream();
        PipedOutputStream consumerOut = new PipedOutputStream(consumerIn);
        new Thread(new Runnable(this, consumerPropsArgs, consumerOut){
            private final Properties consumerPropsArgs$1;
            private final PipedOutputStream consumerOut$1;

            public void run() {
                this.consumerPropsArgs$1.store(this.consumerOut$1, "");
                this.consumerOut$1.close();
            }
            {
                this.consumerPropsArgs$1 = consumerPropsArgs$1;
                this.consumerOut$1 = consumerOut$1;
            }
        }).start();
        this.consumerProps().load(consumerIn);
        String groupId = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.uuid(), this.date()}));
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group id='", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{groupId})));
        this.consumerProps().put("group.id", groupId);
        Properties producerPropsArgs = (Properties)this.producerProps().clone();
        this.producerProps().load(this.producerProperties().get());
        if (Utils.log.isDebugEnabled()) {
            Utils.log.debug("Loaded Producer Properties from resource file:");
            JavaConversions$.MODULE$.propertiesAsScalaMap(this.producerProps()).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x0$3) {
                    Tuple2<String, String> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String k = tuple2._1();
                        String v = tuple2._2();
                        Utils.log.debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{k, v})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            Utils.log.debug("Loading Producer Property args:");
            JavaConversions$.MODULE$.propertiesAsScalaMap(producerPropsArgs).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x0$4) {
                    Tuple2<String, String> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String k = tuple2._1();
                        String v = tuple2._2();
                        Utils.log.debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{k, v})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
        PipedInputStream producerIn = new PipedInputStream();
        PipedOutputStream producerOut = new PipedOutputStream(producerIn);
        new Thread(new Runnable(this, producerPropsArgs, producerOut){
            private final Properties producerPropsArgs$1;
            private final PipedOutputStream producerOut$1;

            public void run() {
                this.producerPropsArgs$1.store(this.producerOut$1, "");
                this.producerOut$1.close();
            }
            {
                this.producerPropsArgs$1 = producerPropsArgs$1;
                this.producerOut$1 = producerOut$1;
            }
        }).start();
        this.producerProps().load(producerIn);
    }

    public void setupJaas() {
        File hdpJaasFile;
        Utils.log.debug("setting up JAAS for Kerberos security");
        String defaultJaasFile = "kafka_cli_jaas.conf";
        String hdpJaasPath = "/usr/hdp/current/kafka-broker/config/kafka_client_jaas.conf";
        File srcpath = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        File jar = srcpath.toString().contains("/target/") ? srcpath.getParentFile().getParentFile() : srcpath;
        String jaasDefaultConfig = ((Object)Paths.get(jar.getParentFile().getAbsolutePath(), "conf", defaultJaasFile)).toString();
        Option<String> jaasProp = Option$.MODULE$.apply(System.getProperty("java.security.auth.login.config"));
        if (this.jaasConfig().nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(this.jaasConfig().getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }))).nonEmpty()) {
            Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using JAAS config file arg '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.jaasConfig()})));
        } else if (jaasProp.nonEmpty()) {
            String jaasFilePath = jaasProp.getOrElse(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            File jaasFile = new File(jaasFilePath);
            if (jaasFile.exists() && jaasFile.isFile()) {
                this.jaasConfig_$eq(Option$.MODULE$.apply(jaasFilePath));
                Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using JAAS config file from System property java.security.auth.login.config = '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.jaasConfig()})));
            } else {
                Utils.log.warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JAAS path specified in System property java.security.auth.login.config = '", "' does not exist!"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{jaasProp})));
            }
        }
        if ((this.jaasConfig().isEmpty() || this.jaasConfig().getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }).isEmpty()) && (hdpJaasFile = new File(hdpJaasPath)).exists() && hdpJaasFile.isFile()) {
            Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found HDP Kafka kerberos config '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{hdpJaasPath})));
            this.jaasConfig_$eq(Option$.MODULE$.apply(hdpJaasPath));
        }
        if (this.jaasConfig().isEmpty() || this.jaasConfig().getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }).isEmpty()) {
            File jaasDefaultFile = new File(jaasDefaultConfig);
            if (jaasDefaultFile.exists() && jaasDefaultFile.isFile()) {
                Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using default JaaS config file '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{jaasDefaultConfig})));
                this.jaasConfig_$eq(Option$.MODULE$.apply(jaasDefaultConfig));
            } else {
                Utils.log.warn("cannot find default JAAS file and none supplied");
            }
        }
        if (this.jaasConfig().nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(this.jaasConfig().getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }))).nonEmpty()) {
            System.setProperty("java.security.auth.login.config", this.jaasConfig().get());
        } else {
            Utils.log.warn("no JAAS config defined");
        }
    }

    @Override
    public void run() {
        Try<BoxedUnit> try_;
        block10: {
            block9: {
                block8: {
                    BoxedUnit t;
                    Try<BoxedUnit> result2 = Try$.MODULE$.apply(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CheckKafka $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.runTest();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    try_ = result2;
                    if (!(try_ instanceof Success)) break block8;
                    Success success2 = (Success)try_;
                    BoxedUnit boxedUnit = t = (BoxedUnit)success2.value();
                    break block9;
                }
                if (!(try_ instanceof Failure)) break block10;
                Failure failure2 = (Failure)try_;
                Throwable t = failure2.exception();
                Throwable throwable = t;
                if (throwable instanceof KafkaException) {
                    KafkaException kafkaException = (KafkaException)throwable;
                    Utils.println(new StringBuilder().append((Object)"CRITICAL: ").append((Object)ExceptionUtils.getRootCauseMessage(kafkaException)).toString());
                    if (Utils.log.isDebugEnabled()) {
                        Utils.println("Caught Kafka Exception: ");
                        kafkaException.printStackTrace();
                    }
                    System.exit(2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                    if (option.isEmpty()) {
                        throw new MatchError((Object)throwable);
                    }
                    Throwable e = option.get();
                    Utils.println(new StringBuilder().append((Object)"CRITICAL: ").append((Object)ExceptionUtils.getRootCauseMessage(e)).toString());
                    if (Utils.log.isDebugEnabled()) {
                        Utils.println("Caught unexpected Exception: ");
                        e.printStackTrace();
                    }
                    System.exit(2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(try_);
    }

    public void runTest() {
        Utils.log.debug("runTest()");
        long startTime = System.currentTimeMillis();
        Utils.log.info("creating Kafka consumer");
        KafkaConsumer<String, String> consumer = new KafkaConsumer<String, String>(this.consumerProps());
        Utils.log.info("creating Kafka producer");
        KafkaProducer<String, String> producer = new KafkaProducer<String, String>(this.producerProps());
        this.subscribe(consumer, this.topic(), this.partition());
        long startWrite = System.currentTimeMillis();
        this.produce(producer, this.topic(), this.partition(), this.msg());
        double writeTime = (double)(System.currentTimeMillis() - startWrite) / 1000.0;
        long readStartTime = System.currentTimeMillis();
        this.consume(consumer, this.topic(), this.partition());
        long endTime = System.currentTimeMillis();
        double readTime = (double)(endTime - readStartTime) / 1000.0;
        double totalTime = (double)(endTime - startTime) / 1000.0;
        String plural = this.consumerProps().get("bootstrap.servers") instanceof String && ((String)this.consumerProps().get("bootstrap.servers")).split("\\s*,\\s*").length > 1 ? "s" : "";
        String brokermsg = this.getVerbose() > 0 ? new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker", " '"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{plural}))).append((Object)this.brokers()).append((Object)"'").toString() : new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{plural}));
        String withSasl = this.consumerProps().getProperty("security.protocol", "").contains("SASL") && this.producerProps().getProperty("security.protocol", "").contains("SASL") ? " with sasl authentication" : "";
        String output = new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OK: Kafka ", " successfully returned unique message via topic '", "' partition '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{brokermsg, this.topic(), BoxesRunTime.boxToInteger(this.partition())}))).append((Object)withSasl).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{", write time = ", "s, read time = ", "s, total time = ", "s "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(writeTime), BoxesRunTime.boxToDouble(readTime), BoxesRunTime.boxToDouble(totalTime)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| write_time=", "s read_time=", "s total_time=", "s"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(writeTime), BoxesRunTime.boxToDouble(readTime), BoxesRunTime.boxToDouble(totalTime)}))).toString();
        Utils.println(output);
    }

    public void subscribe(KafkaConsumer<String, String> consumer, String topic, int partition2) {
        Utils.log.debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subscribe(consumer, ", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
        TopicPartition topicPartition = new TopicPartition(topic, partition2);
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumer assigning topic '", "' partition '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
        consumer.assign(Arrays.asList((Object[])new TopicPartition[]{topicPartition}));
        this.lastOffset_$eq(consumer.position(topicPartition));
    }

    public String subscribe$default$2() {
        return this.topic();
    }

    public int subscribe$default$3() {
        return this.partition();
    }

    public void produce(KafkaProducer<String, String> producer, String topic, int partition2, String msg) {
        Utils.log.debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"produce(producer, ", ", ", ", ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2), msg})));
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sending message to topic ", " partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
        producer.send(new ProducerRecord<String, String>(topic, Predef$.MODULE$.int2Integer(partition2), this.id(), msg));
        Utils.log.info("producer.flush()");
        producer.flush();
        Utils.log.info("producer.close()");
        producer.close();
    }

    public String produce$default$2() {
        return this.topic();
    }

    public int produce$default$3() {
        return this.partition();
    }

    public String produce$default$4() {
        return this.msg();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void consume(KafkaConsumer<String, String> consumer, String topic, int partition2) {
        Utils.log.debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumer(consumer, ", ", ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
        TopicPartition topicPartition = new TopicPartition(topic, partition2);
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seeking to last known offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.lastOffset())})));
        consumer.seek(topicPartition, this.lastOffset());
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consuming from offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.lastOffset())})));
        ConsumerRecords<String, String> records = consumer.poll(200L);
        Utils.log.info("closing consumer");
        consumer.close();
        int consumedRecordCount = records.count();
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumed record count = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(consumedRecordCount)})));
        Predef$.MODULE$.assert(consumedRecordCount != 0);
        Option<String> msg2 = this.getRecordMsg(records);
        Utils.log.info(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message returned: "})).s(Nil$.MODULE$)).append((Object)msg2.getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString());
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message expected: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.msg()})));
        Option<String> option = msg2;
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            Utils.println("CRITICAL: message not returned by Kafka");
            System.exit(2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String string2 = (String)some.x();
            String string3 = this.msg();
            String string4 = string2;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        Utils.println("CRITICAL: message returned does not equal message sent!");
        System.exit(2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public String consume$default$2() {
        return this.topic();
    }

    public int consume$default$3() {
        return this.partition();
    }

    public Option<String> getRecordMsg(ConsumerRecords<String, String> records) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                JavaConversions$.MODULE$.iterableAsScalaIterable(records).withFilter((Function1<ConsumerRecord<String, String>, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ConsumerRecord<String, String> check$ifrefutable$1) {
                        ConsumerRecord<String, String> consumerRecord = check$ifrefutable$1;
                        boolean bl = consumerRecord != null;
                        return bl;
                    }
                })).foreach(new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CheckKafka $outer;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(ConsumerRecord<String, String> record) {
                        String recordTopic = record.topic();
                        String value2 = record.value();
                        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found message, topic '", "', value = '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{recordTopic, value2})));
                        Predef$.MODULE$.assert(this.$outer.topic().equals(recordTopic));
                        if (this.$outer.msg().equals(value2)) {
                            throw new NonLocalReturnControl<Option<String>>(this.nonLocalReturnKey1$1, Option$.MODULE$.apply(value2));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public CheckKafka() {
        this.usage_msg = "check_kafka --brokers localhost:9092 --topic test <options>";
        if (this.consumerProps() == this.producerProps()) {
            throw new IllegalArgumentException("Consumer + Producer props should not be the same object");
        }
        this.producerProperties = Option$.MODULE$.apply(this.getClass().getResourceAsStream("/producer.properties"));
        if (this.producerProperties().isEmpty()) {
            Utils.log.error("could not find producer.properties file");
            System.exit(2);
        }
        this.consumerProperties = Option$.MODULE$.apply(this.getClass().getResourceAsStream("/consumer.properties"));
        if (this.consumerProperties().isEmpty()) {
            Utils.log.error("could not find consumer.properties file");
            System.exit(2);
        }
        this.uuid = UUID.randomUUID().toString();
        this.epoch = System.currentTimeMillis();
        this.date = new SimpleDateFormat("yyyy-dd-MM HH:MM:ss.SSS Z").format(BoxesRunTime.boxToLong(this.epoch()));
        this.id = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hari Sekhon check_kafka (scala) - random token=", ", ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.uuid(), this.date()}));
        this.msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test message generated by ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.id()}));
        Utils.log.info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test message => '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.msg()})));
    }
}

