/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.application;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.authentication.filter.JustSAMLEntryPoint;
import de.justsoftware.authentication.filter.JustSAMLProcessingFilter;
import de.justsoftware.authentication.filter.JustSAMLWebSSOHoKProcessingFilter;
import de.justsoftware.authentication.filter.RefreshingMetadataDisplayFilter;
import de.justsoftware.authentication.service.RedisSAMLMessageStorageFactory;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.Filter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLDiscovery;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLLogoutFilter;
import org.springframework.security.saml.SAMLLogoutProcessingFilter;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.SAMLWebSSOHoKProcessingFilter;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.parser.ParserPoolHolder;
import org.springframework.security.saml.processor.HTTPArtifactBinding;
import org.springframework.security.saml.processor.HTTPPAOS11Binding;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;
import org.springframework.security.saml.processor.SAMLBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.processor.SAMLProcessorImpl;
import org.springframework.security.saml.storage.SAMLMessageStorageFactory;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;
import org.springframework.security.saml.websso.ArtifactResolutionProfileImpl;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.saml.websso.SingleLogoutProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import org.springframework.security.saml.websso.WebSSOProfileHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configurable
@Configuration
@EnableWebSecurity
@ParametersAreNonnullByDefault
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider());
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.samlEntryPoint());
        http.csrf().disable();
        http.addFilterAfter((Filter)this.samlFilter(), BasicAuthenticationFilter.class);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/manage/**"})).permitAll().antMatchers(new String[]{"/heartbeat"})).permitAll().antMatchers(new String[]{"/logout"})).permitAll().antMatchers(new String[]{"/error"})).permitAll().antMatchers(new String[]{"/saml/**"})).permitAll().antMatchers(new String[]{"/test/session"})).permitAll().antMatchers(new String[]{"/adfs/error"})).permitAll().anyRequest()).fullyAuthenticated();
        http.logout().logoutSuccessHandler(this.successLogoutHandler());
    }

    @Nonnull
    @Bean(value={"samlFilter"})
    public FilterChainProxy samlFilter() throws Exception {
        return this.createAntFilterChain(ImmutableMap.builder().put((Object)"/saml/login/**", (Object)this.samlEntryPoint()).put((Object)"/saml/logout/**", (Object)this.samlLogoutFilter()).put((Object)"/saml/metadata/**", (Object)this.metadataDisplayFilter()).put((Object)"/saml/SSO/**", (Object)this.samlProcessingFilter()).put((Object)"/saml/HoKSSO/**", (Object)this.samlHoKProcessingFilter()).put((Object)"/saml/SingleLogout/**", (Object)this.samlLogoutProcessingFilter()).put((Object)"/saml/discovery/**", (Object)this.samlIDPDiscovery()).build());
    }

    @Nonnull
    private FilterChainProxy createAntFilterChain(ImmutableMap<String, Filter> mappedFilter) {
        return new FilterChainProxy(mappedFilter.entrySet().stream().map(entry -> new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher((String)entry.getKey()), new Filter[]{(Filter)entry.getValue()})).collect(Collectors.toList()));
    }

    @Nonnull
    @Bean(value={"samlEntryPoint"})
    public SAMLEntryPoint samlEntryPoint() {
        WebSSOProfileOptions defaultProfileOptions = new WebSSOProfileOptions();
        defaultProfileOptions.setIncludeScoping(Boolean.FALSE);
        JustSAMLEntryPoint samlEntryPoint = new JustSAMLEntryPoint();
        samlEntryPoint.setDefaultProfileOptions(defaultProfileOptions);
        return samlEntryPoint;
    }

    @Nonnull
    @Bean(value={"samlLogoutFilter"})
    public SAMLLogoutFilter samlLogoutFilter() {
        LogoutHandler[] logoutHandler = new LogoutHandler[]{this.logoutHandler()};
        return new SAMLLogoutFilter(this.successLogoutHandler(), logoutHandler, logoutHandler);
    }

    @Nonnull
    @Bean(value={"metadataDisplayFilter"})
    public MetadataDisplayFilter metadataDisplayFilter() {
        return new RefreshingMetadataDisplayFilter();
    }

    @Nonnull
    @Bean(value={"samlWebSSOProcessingFilter"})
    public SAMLProcessingFilter samlProcessingFilter() throws Exception {
        JustSAMLProcessingFilter samlProcessingFilter = new JustSAMLProcessingFilter();
        samlProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlProcessingFilter.setAuthenticationSuccessHandler(this.successRedirectHandler());
        samlProcessingFilter.setAuthenticationFailureHandler(this.failureRedirectHandler());
        return samlProcessingFilter;
    }

    @Nonnull
    @Bean(value={"samlWebSSOHoKProcessingFilter"})
    public SAMLWebSSOHoKProcessingFilter samlHoKProcessingFilter() throws Exception {
        JustSAMLWebSSOHoKProcessingFilter samlProcessingFilter = new JustSAMLWebSSOHoKProcessingFilter();
        samlProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlProcessingFilter.setAuthenticationSuccessHandler(this.successRedirectHandler());
        samlProcessingFilter.setAuthenticationFailureHandler(this.failureRedirectHandler());
        return samlProcessingFilter;
    }

    @Nonnull
    @Bean(value={"samlLogoutProcessingFilter"})
    public SAMLLogoutProcessingFilter samlLogoutProcessingFilter() {
        return new SAMLLogoutProcessingFilter(this.successLogoutHandler(), new LogoutHandler[]{this.logoutHandler()});
    }

    @Nonnull
    @Bean(value={"samlIDPDiscovery"})
    public SAMLDiscovery samlIDPDiscovery() {
        return new SAMLDiscovery();
    }

    @Nonnull
    @Bean(value={"successRedirectHandler"})
    public AuthenticationSuccessHandler successRedirectHandler() {
        SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
        handler.setDefaultTargetUrl("/");
        return handler;
    }

    @Nonnull
    @Bean(value={"failureRedirectHandler"})
    public AuthenticationFailureHandler failureRedirectHandler() {
        SimpleUrlAuthenticationFailureHandler handler = new SimpleUrlAuthenticationFailureHandler();
        handler.setUseForward(true);
        handler.setDefaultFailureUrl("/error");
        return handler;
    }

    @Nonnull
    @Bean(value={"successLogoutHandler"})
    public LogoutSuccessHandler successLogoutHandler() {
        SimpleUrlLogoutSuccessHandler handler = new SimpleUrlLogoutSuccessHandler();
        handler.setDefaultTargetUrl("/");
        return handler;
    }

    @Nonnull
    @Bean(value={"logoutHandler"})
    public LogoutHandler logoutHandler() {
        SecurityContextLogoutHandler handler = new SecurityContextLogoutHandler();
        handler.setInvalidateHttpSession(true);
        return handler;
    }

    @Bean
    @Nonnull
    public SAMLAuthenticationProvider samlAuthenticationProvider() {
        SAMLAuthenticationProvider samlAuthenticationProvider = new SAMLAuthenticationProvider();
        samlAuthenticationProvider.setForcePrincipalAsString(false);
        return samlAuthenticationProvider;
    }

    @Nonnull
    @Bean(value={"samlContextProvider"})
    public SAMLContextProvider samlContextProvider(RedisSAMLMessageStorageFactory storageFactory) {
        SAMLContextProviderImpl samlContextProvider = new SAMLContextProviderImpl();
        samlContextProvider.setStorageFactory((SAMLMessageStorageFactory)storageFactory);
        return samlContextProvider;
    }

    @Nonnull
    @Bean(name={"processor"})
    public SAMLProcessor samlProcessor(@Qualifier(value="redirectBinding") SAMLBinding redirectBinding, @Qualifier(value="postBinding") SAMLBinding postBinding, @Qualifier(value="artifactBinding") SAMLBinding artifactBinding, @Qualifier(value="soapBinding") SAMLBinding soapBinding, @Qualifier(value="paosBinding") SAMLBinding paosBinding) {
        return new SAMLProcessorImpl((Collection)ImmutableList.of((Object)redirectBinding, (Object)postBinding, (Object)artifactBinding, (Object)soapBinding, (Object)paosBinding));
    }

    @Nonnull
    @Bean(value={"webSSOprofileConsumer"})
    public WebSSOProfileConsumer webSSOProfileConsumer(@Value(value="${sso.maxAuthenticationAge:28800}") long maxAuthenticationAge) {
        WebSSOProfileConsumerImpl webSSOProfileConsumer = new WebSSOProfileConsumerImpl();
        webSSOProfileConsumer.setMaxAuthenticationAge(maxAuthenticationAge);
        return webSSOProfileConsumer;
    }

    @Nonnull
    @Bean(value={"hokWebSSOprofileConsumer"})
    public WebSSOProfileConsumer hokWebSSOProfileConsumer(@Value(value="${sso.maxAuthenticationAge:28800}") long maxAuthenticationAge) {
        WebSSOProfileConsumerHoKImpl webSSOProfileConsumerHoK = new WebSSOProfileConsumerHoKImpl();
        webSSOProfileConsumerHoK.setMaxAuthenticationAge(maxAuthenticationAge);
        return webSSOProfileConsumerHoK;
    }

    @Nonnull
    @Bean(value={"webSSOprofile"})
    public WebSSOProfile webSSOProfile() {
        return new WebSSOProfileImpl();
    }

    @Nonnull
    @Bean(value={"hokWebSSOProfile"})
    public WebSSOProfile hokWebSSOProfile() {
        return new WebSSOProfileHoKImpl();
    }

    @Nonnull
    @Bean(value={"ecpprofile"})
    public WebSSOProfile ecpProfile() {
        return new WebSSOProfileECPImpl();
    }

    @Nonnull
    @Bean(value={"logoutprofile"})
    public SingleLogoutProfile logoutProfile() {
        return new SingleLogoutProfileImpl();
    }

    @Nonnull
    @Bean(name={"parserPool"}, initMethod="initialize")
    public ParserPool parserPool() {
        return new StaticBasicParserPool();
    }

    @Nonnull
    @Bean(name={"velocityEngine"})
    public VelocityEngine velocityEngine() {
        return VelocityFactory.getEngine();
    }

    @Nonnull
    @Bean(value={"postBinding"})
    public SAMLBinding postBinding(ParserPool parserPool, VelocityEngine velocityEngine) {
        return new HTTPPostBinding(parserPool, velocityEngine);
    }

    @Nonnull
    @Bean(value={"redirectBinding"})
    public SAMLBinding redirectBinding(ParserPool parserPool) {
        return new HTTPRedirectDeflateBinding(parserPool);
    }

    @Nonnull
    @Bean(name={"multiThreadedHttpConnectionManager"}, destroyMethod="shutdown")
    public MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager() {
        return new MultiThreadedHttpConnectionManager();
    }

    @Nonnull
    @Bean(name={"multiThreadedHttpClient"})
    public HttpClient multiThreadedHttpClient(@Qualifier(value="multiThreadedHttpConnectionManager") HttpConnectionManager httpCnnectionManager) {
        return new HttpClient(httpCnnectionManager);
    }

    @Nonnull
    @Bean(value={"artifactBinding"})
    public SAMLBinding artifactBinding(ParserPool parserPool, VelocityEngine velocityEngine, @Qualifier(value="soapBinding") SAMLBinding soapBinding, @Qualifier(value="multiThreadedHttpClient") HttpClient httpClient) {
        ArtifactResolutionProfileImpl artifactProfile = new ArtifactResolutionProfileImpl(httpClient);
        artifactProfile.setProcessor((SAMLProcessor)new SAMLProcessorImpl(soapBinding));
        return new HTTPArtifactBinding(parserPool, velocityEngine, (ArtifactResolutionProfile)artifactProfile);
    }

    @Nonnull
    @Bean(value={"soapBinding"})
    public SAMLBinding soapBinding(ParserPool parserPool) {
        return new HTTPSOAP11Binding(parserPool);
    }

    @Nonnull
    @Bean(value={"paosBinding"})
    public SAMLBinding paosBinding(ParserPool parserPool) {
        return new HTTPPAOS11Binding(parserPool);
    }

    @Nonnull
    @Bean(value={"parserPoolHolder"})
    public ParserPoolHolder parserPoolHolder() {
        return new ParserPoolHolder();
    }
}

