/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.application;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.catalina.connector.Connector;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"standalone"})
@ConfigurationProperties
@ParametersAreNonnullByDefault
public class StandaloneConfiguration {
    @Nonnull
    @Bean(value={"tomcatFactory"})
    public EmbeddedServletContainerFactory servletContainer(@Value(value="${server.ajpPort:6009}") int ajpPort, @Value(value="${server.ajpPacketSize:65536}") int ajpPacketSize) {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        Connector ajpConnector = new Connector("AJP/1.3");
        ajpConnector.setPort(ajpPort);
        ajpConnector.setAttribute("packetSize", (Object)ajpPacketSize);
        tomcat.addAdditionalTomcatConnectors(new Connector[]{ajpConnector});
        return tomcat;
    }
}

