#!/bin/sh
mkdir -p ~/backup/db

echo "Attempting to dump databases. Disregard connection error messages if specific database does not exist on this system."

# justconnect
if psql -h localhost -U justconnect --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/db-`date +%Y-%m-%d_%H%M%S`.dump -U justconnect justconnect
fi

# drive
if psql -h localhost -U justdrive --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/drive-db-`date +%Y-%m-%d_%H%M%S`.dump -U justdrive justdrive
fi

# people
if psql -h localhost -U justpeople --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/people-db-`date +%Y-%m-%d_%H%M%S`.dump -U justpeople justpeople
fi

# import
if psql -h localhost -U justimport --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/import-db-`date +%Y-%m-%d_%H%M%S`.dump -U justimport justimport
fi

# notification
if psql -h localhost -U justnotification --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/notification-db-`date +%Y-%m-%d_%H%M%S`.dump -U justnotification justnotification
fi

# wiki
if psql -h localhost -U justwiki --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/wiki-db-`date +%Y-%m-%d_%H%M%S`.dump -U justwiki justwiki
fi

# chat
if psql -h localhost -U justchat --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/chat-db-`date +%Y-%m-%d_%H%M%S`.dump -U justchat justchat
fi

# admin
if psql -h localhost -U justadmin --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/admin-db-`date +%Y-%m-%d_%H%M%S`.dump -U justadmin justadmin
fi

# news
if psql -h localhost -U justnews --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/news-db-`date +%Y-%m-%d_%H%M%S`.dump -U justnews justnews
fi

# search-ltr
if psql -h localhost -U justsearchltr --quiet --no-password -c '' 2>&1; then
    /usr/bin/pg_dump --format custom -v -h localhost -f ~/backup/db/search-ltr-db-`date +%Y-%m-%d_%H%M%S`.dump -U justsearchltr justsearchltr
fi
