/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent;

import com.freiheit.superoperty.InheritanceType;
import com.freiheit.superoperty.MetaProperty;
import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.SuperopertyContainer;
import com.freiheit.superoperty.uicomponent.AuthorizationAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wings.SIcon;
import org.wings.SResourceIcon;

public class PropertyTreeModel
implements TreeModel {
    private static final Log LOG = LogFactory.getLog(PropertyTreeModel.class);
    private static final String RES_PATH = "com/freiheit/superoperty/uicomponent";
    private static final SIcon ROOT_ICON = new SResourceIcon("com/freiheit/superoperty/uicomponent/icons/contents.gif");
    private final Node _rootNode = new Node("/", null, "Properties", ROOT_ICON);

    public PropertyTreeModel(final SuperopertyContainer container, final AuthorizationAdapter auth) {
        this(new Iterator<Node>(){
            final Iterator<MetaProperty> _baseIt;
            MetaProperty _nextMeta;
            {
                this._baseIt = container.getMetaProperties().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this._baseIt.hasNext()) {
                    this._nextMeta = this._baseIt.next();
                    String path = this._nextMeta.getName();
                    if (!auth.mayViewBaseProperty(path)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Node next() {
                return new Node(this._nextMeta.getName(), container.getBaseProperty(this._nextMeta));
            }

            @Override
            public void remove() {
            }
        });
    }

    public PropertyTreeModel(final SuperopertyContainer container, final String domain, final AuthorizationAdapter auth) {
        this(new Iterator<Node>(){
            final Iterator<MetaProperty> _baseIt;
            MetaProperty _nextMeta;
            {
                this._baseIt = container.getMetaProperties().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this._baseIt.hasNext()) {
                    this._nextMeta = this._baseIt.next();
                    String path = this._nextMeta.getName();
                    if (this._nextMeta.getInheritance() == InheritanceType.FINAL) {
                        LOG.debug((Object)("[" + domain + "] ignoring final " + path));
                        continue;
                    }
                    if (auth.mayViewDomainProperty(path, domain)) {
                        return true;
                    }
                    LOG.debug((Object)("[" + domain + "] may not view " + path));
                }
                return false;
            }

            @Override
            public Node next() {
                return new Node(this._nextMeta.getName(), container.getDomainProperty(this._nextMeta, domain));
            }

            @Override
            public void remove() {
            }
        });
    }

    private PropertyTreeModel(Iterator<Node> nodes) {
        String path;
        TreeMap<String, Node> sortedNodes = new TreeMap<String, Node>();
        while (nodes.hasNext()) {
            try {
                Node node = nodes.next();
                String name = node.getProperty().getMetaProperty().getName();
                if (name.startsWith("/junit")) continue;
                sortedNodes.put(name, node);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Fehler beim Erzeugen des PropertyTreeModels", (Throwable)e);
            }
        }
        TreeMap<String, Node> missingNodes = new TreeMap<String, Node>();
        missingNodes.put("/", this._rootNode);
        for (String key : sortedNodes.keySet()) {
            path = "";
            int index = 0;
            while ((index = key.indexOf(47, index + 1)) > 0) {
                path = key.substring(0, index);
                if (sortedNodes.containsKey(path) || missingNodes.containsKey(path)) continue;
                missingNodes.put(path, new Node(path, null));
            }
        }
        sortedNodes.putAll(missingNodes);
        for (Node node : sortedNodes.values()) {
            path = node.getPath();
            String parentPath = "/";
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash > 0) {
                parentPath = path.substring(0, lastSlash);
            }
            Node parent = (Node)sortedNodes.get(parentPath);
            node.setParent(parent);
        }
        this._rootNode.sortKids();
    }

    @Override
    public Object getRoot() {
        return this._rootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((Node)parent).getKid(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((Node)parent).getKidCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((Node)parent).getKidIndex((Node)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public static class Node {
        private Node _parent;
        private final String _path;
        private final String _name;
        private final Property _property;
        private final List<Node> _kids;
        private final SIcon _icon;

        public Node(String path, Property prop) {
            this(path, prop, null);
        }

        public Node(String path, Property prop, SIcon icon) {
            this(path, prop, null, icon);
        }

        public Node(String path, Property prop, String name, SIcon icon) {
            this._path = path;
            this._icon = icon;
            this._property = prop;
            this._kids = new ArrayList<Node>();
            boolean startsWithSlash = this._path.startsWith("/");
            int lastSlash = this._path.lastIndexOf(47);
            this._name = name != null ? name : (lastSlash <= 0 ? (startsWithSlash ? this._path.substring(1) : this._path) : this._path.substring(lastSlash + 1));
        }

        public void sortKids() {
            Collections.sort(this._kids, KidComparator.INSTANCE);
            for (Node n : this._kids) {
                n.sortKids();
            }
        }

        public String getPath() {
            return this._path;
        }

        public SIcon getIcon() {
            return this._icon;
        }

        public Node getParent() {
            return this._parent;
        }

        public void setParent(Node parent) {
            if (parent == this) {
                return;
            }
            this._parent = parent;
            if (this._parent != null) {
                this._parent.addKid(this);
            }
        }

        public Node getKid(int index) {
            return this._kids.get(index);
        }

        public void addKid(Node kid) {
            this._kids.add(kid);
        }

        public int getKidCount() {
            return this._kids.size();
        }

        public int getKidIndex(Node kid) {
            return this._kids.indexOf(kid);
        }

        public Property getProperty() {
            return this._property;
        }

        public String getName() {
            return this._name;
        }

        private static class KidComparator
        implements Comparator<Node> {
            public static final Comparator<Node> INSTANCE = new KidComparator();

            private KidComparator() {
            }

            @Override
            public int compare(Node na, Node nb) {
                int akids = na.getKidCount();
                int bkids = nb.getKidCount();
                if (akids == 0 && bkids > 0) {
                    return 1;
                }
                if (akids > 0 && bkids == 0) {
                    return -1;
                }
                return na.getPath().compareTo(nb.getPath());
            }
        }
    }
}

