/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent;

import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.uicomponent.PropertyTreeModel;
import org.wings.SComponent;
import org.wings.STree;
import org.wings.tree.SDefaultTreeCellRenderer;

class PropertyTreeCellRenderer
extends SDefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    PropertyTreeCellRenderer() {
    }

    private String cut(String val, int len) {
        if (val == null) {
            return "";
        }
        if (val.length() > len) {
            return val.substring(0, len - 1) + "...";
        }
        return val;
    }

    public String createStringValue(PropertyTreeModel.Node node) {
        boolean raw = false;
        Object value = "";
        Property property = node.getProperty();
        if (property != null) {
            if (property.isValueInherited()) {
                Property showProp = property;
                while (showProp.isValueInherited() && showProp.getParentProperty() != null) {
                    showProp = showProp.getParentProperty() != null ? showProp.getParentProperty() : showProp;
                }
                value = " [ " + this.cut(showProp.getStringValue(), 10) + " ]";
            } else {
                value = " <b>( " + this.cut(this.escapeHTML(property.getStringValue()), 10) + " )</b>";
                raw = true;
            }
        }
        if (raw) {
            return "<html>" + node.getName() + (String)value;
        }
        return node.getName() + (String)value;
    }

    private String escapeHTML(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    public SComponent getTreeCellRendererComponent(STree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        PropertyTreeModel.Node node = (PropertyTreeModel.Node)value;
        if (node.getIcon() != null) {
            this.setIcon(node.getIcon());
        }
        this.setText(this.createStringValue(node));
        return this;
    }
}

