/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent;

import com.freiheit.superoperty.uicomponent.PropertyTreeCellRenderer;
import com.freiheit.superoperty.uicomponent.PropertyTreeModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.wings.SButton;
import org.wings.SIcon;
import org.wings.SResourceIcon;
import org.wings.STree;
import org.wings.tree.SDefaultTreeSelectionModel;
import org.wings.tree.STreeCellRenderer;
import org.wings.tree.STreeSelectionModel;

class PropertyTree
extends STree {
    private static final long serialVersionUID = 1L;
    private static final SIcon ARROW_DOWN = new SResourceIcon("org/wings/icons/ArrowDown.gif");
    private static final SIcon ARROW_RIGHT = new SResourceIcon("org/wings/icons/ArrowRight.gif");
    private static final String AUSKLAPP = " alle ausklappen";
    private static final String UNSELEINKLAPP = " unselektierte einklappen";
    private final SButton _expander;
    private boolean _expandToggle;
    private boolean _inModifySelection = false;

    public PropertyTree(final TreeModel treeModel) {
        super(treeModel);
        this.setNodeIndentDepth(16);
        SDefaultTreeSelectionModel single = new SDefaultTreeSelectionModel();
        single.setSelectionMode(1);
        this.setSelectionModel((STreeSelectionModel)single);
        this.setCellRenderer((STreeCellRenderer)new PropertyTreeCellRenderer());
        this._expander = new SButton(AUSKLAPP);
        this._expander.setIcon(ARROW_RIGHT);
        this._expandToggle = false;
        this._expander.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PropertyTree.this._expandToggle = !PropertyTree.this._expandToggle;
                PropertyTree.this.expandAll(PropertyTree.this._expandToggle);
                if (!PropertyTree.this._expandToggle) {
                    PropertyTree.this.expandRow(new TreePath(treeModel.getRoot()));
                    TreePath selPath = PropertyTree.this.getSelectionPath();
                    if (selPath != null) {
                        PropertyTree.this.expandUpTo(selPath.getParentPath());
                    }
                }
                PropertyTree.this._expander.setIcon(PropertyTree.this._expandToggle ? ARROW_DOWN : ARROW_RIGHT);
                PropertyTree.this._expander.setText(PropertyTree.this._expandToggle ? PropertyTree.UNSELEINKLAPP : PropertyTree.AUSKLAPP);
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PropertyTreeModel.Node node = (PropertyTreeModel.Node)e.getPath().getLastPathComponent();
                if (node.getKidCount() != 0) {
                    PropertyTree.this.toggleFolderExpansion(e.getPath());
                }
            }
        });
    }

    public SButton getExpanderButton() {
        return this._expander;
    }

    private void toggleFolderExpansion(TreePath path) {
        if (this.isExpanded(path)) {
            this.collapseRow(path);
        } else {
            this.expandRow(path);
        }
        this.ensureSelected(path, false);
    }

    public void addTreeSelectionListener(final TreeSelectionListener listener) {
        super.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (PropertyTree.this._inModifySelection) {
                    return;
                }
                listener.valueChanged(e);
            }
        });
    }

    public void ensureSelected(TreePath path, boolean requestSelected) {
        if (this.isPathSelected(path) == requestSelected) {
            return;
        }
        try {
            this._inModifySelection = true;
            if (requestSelected) {
                this.addSelectionPath(path);
            } else {
                this.removeSelectionPath(path);
            }
        }
        finally {
            this._inModifySelection = false;
        }
    }

    private void expandUpTo(TreePath path) {
        if (path == null) {
            return;
        }
        if (path.getPathCount() != 0) {
            this.expandUpTo(path.getParentPath());
        }
        this.expandRow(path);
    }

    private void expandAll(boolean expand) {
        TreeModel treeModel = this.getModel();
        Object root = treeModel.getRoot();
        this.expandAll(new TreePath(root), treeModel, expand);
    }

    private void expandAll(TreePath parentPath, TreeModel treeModel, boolean expand) {
        Object parentNode = parentPath.getLastPathComponent();
        int kids = treeModel.getChildCount(parentNode);
        for (int i = 0; i < kids; ++i) {
            Object child = treeModel.getChild(parentNode, i);
            TreePath subPath = parentPath.pathByAddingChild(child);
            this.expandAll(subPath, treeModel, expand);
        }
        if (expand) {
            this.expandRow(parentPath);
        } else {
            this.collapseRow(parentPath);
        }
    }
}

