/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent;

import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.SuperopertyContainer;
import com.freiheit.superoperty.uicomponent.AuthorizationAdapter;
import com.freiheit.superoperty.uicomponent.DomainEditorPanel;
import com.freiheit.superoperty.uicomponent.PropertyTree;
import com.freiheit.superoperty.uicomponent.PropertyTreeModel;
import com.freiheit.superoperty.uicomponent.SimpleAuthorizationAdapter;
import java.io.IOException;
import java.net.URL;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.SPanel;
import org.wings.STemplateLayout;
import org.wings.STree;

public class DomainPropertyEditorPane
extends SPanel {
    private static final long serialVersionUID = 1L;
    private final PropertyTree _tree;

    public DomainPropertyEditorPane(SuperopertyContainer container, String domain, AuthorizationAdapter auth, STemplateLayout pageLayout, STemplateLayout editorLayout) {
        super((SLayoutManager)pageLayout);
        this._tree = new PropertyTree(new PropertyTreeModel(container, domain, auth));
        final DomainEditorPanel editorPanel = new DomainEditorPanel(editorLayout, auth, domain);
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PropertyTreeModel.Node node = (PropertyTreeModel.Node)e.getPath().getLastPathComponent();
                Property property = node.getProperty();
                editorPanel.setProperty(property);
                if (property != null) {
                    DomainPropertyEditorPane.this._tree.ensureSelected(e.getPath(), true);
                }
            }
        });
        this.add((SComponent)new SLabel("Konfigurationseinstellungen"), "prop-header");
        this.add((SComponent)this._tree, "prop-tree");
        this.add((SComponent)this._tree.getExpanderButton(), "prop-tree-unfoldbutton");
        this.add((SComponent)editorPanel, "prop-editor");
    }

    public DomainPropertyEditorPane(SuperopertyContainer container, String domain, AuthorizationAdapter auth) {
        this(container, domain, auth, DomainPropertyEditorPane.createTemplateLayout("PropertyPane.html"), DomainPropertyEditorPane.createTemplateLayout("DomainEditorPanel.html"));
    }

    public DomainPropertyEditorPane(SuperopertyContainer container, String domain) {
        this(container, domain, new SimpleAuthorizationAdapter(true));
    }

    public STree getTree() {
        return this._tree;
    }

    public SButton getExpanderButton() {
        return this._tree.getExpanderButton();
    }

    private static STemplateLayout createTemplateLayout(String templateName) {
        try {
            URL resource = DomainPropertyEditorPane.class.getClassLoader().getResource(templateName);
            return new STemplateLayout(resource);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException(e);
        }
    }
}

