/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent;

import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.uicomponent.AbstractEditorPanel;
import com.freiheit.superoperty.uicomponent.AuthorizationAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.wings.SAbstractButton;
import org.wings.SButtonGroup;
import org.wings.SComponent;
import org.wings.SPanel;
import org.wings.SRadioButton;
import org.wings.STemplateLayout;

class DomainEditorPanel
extends AbstractEditorPanel {
    private static final long serialVersionUID = 200407232205L;
    private final SPanel _defaultDisplayArea = new SPanel();
    private final SRadioButton _inheritValue;
    private final SRadioButton _overrideValue;
    private final SButtonGroup _overrideGroup = new SButtonGroup();

    public DomainEditorPanel(STemplateLayout layoutParam, AuthorizationAdapter authAdapter, String domain) {
        super(layoutParam, authAdapter);
        this.add((SComponent)this._defaultDisplayArea, "default-value");
        this._inheritValue = this.createRadio(this._overrideGroup, "Diesen Default-Wert verwenden", "F\u00fcr diesen Mandanten den Default Wert verwenden");
        this._overrideValue = this.createRadio(this._overrideGroup, "Mandantenspezifisch \u00fcberschreiben", "Den Wert spezifisch f\u00fcr diesen Mandanten durch einen anderen Wert ersetzen");
        this._inheritValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DomainEditorPanel.this.getCurrentProperty() != null) {
                    DomainEditorPanel.this.setMandantEditable(false);
                }
            }
        });
        this._overrideValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DomainEditorPanel.this.getCurrentProperty() != null) {
                    DomainEditorPanel.this.setMandantEditable(true);
                }
            }
        });
        this.add((SComponent)this._inheritValue, "inherit-radio");
        this.add((SComponent)this._overrideValue, "override-radio");
        this._inheritValue.setEnabled(this.getAuthAdapter().mayEditDomainProperties(domain));
        this._overrideValue.setEnabled(this.getAuthAdapter().mayEditDomainProperties(domain));
    }

    @Override
    public void setProperty(Property prop) {
        super.setProperty(prop);
        if (prop != null) {
            Property showProp = prop.getParentProperty();
            if (showProp != null) {
                while (showProp.isValueInherited() && showProp.getParentProperty() != null) {
                    showProp = showProp.getParentProperty() != null ? showProp.getParentProperty() : showProp;
                }
            }
            String baseValue = showProp != null ? showProp.getStringValue() : null;
            SComponent displayComp = this._currentEditorFactory.createEditComponent(baseValue);
            displayComp.setEnabled(false);
            this._defaultDisplayArea.removeAll();
            this._defaultDisplayArea.add(displayComp);
            this.setMandantEditable(!prop.isValueInherited());
        } else {
            this._defaultDisplayArea.removeAll();
        }
    }

    @Override
    protected boolean mayEditCurrent() {
        String domain = this.getCurrentProperty().getDomain();
        return this.getAuthAdapter().mayEditDomainProperties(domain) && this.getAuthAdapter().mayEditDomainProperty(this.getCurrentProperty().getMetaProperty().getName(), domain);
    }

    @Override
    protected boolean mayViewCurrent() {
        String domain = this.getCurrentProperty().getDomain();
        return this.getAuthAdapter().mayViewDomainProperties(domain) && this.getAuthAdapter().mayViewDomainProperty(this.getCurrentProperty().getMetaProperty().getName(), domain);
    }

    private void setMandantEditable(boolean mandantOverride) {
        if (!mandantOverride) {
            this.getCurrentProperty().clearLocalValue();
        }
        this._editorDescription.setVisible(mandantOverride);
        this.enableEditing(mandantOverride, mandantOverride && this.mayViewCurrent());
        this._saveError.setVisible(mandantOverride);
        if (mandantOverride) {
            this._overrideValue.setSelected(true);
        } else {
            this._inheritValue.setSelected(true);
        }
    }

    private SRadioButton createRadio(SButtonGroup group, String text, String toolTip) {
        SRadioButton button = new SRadioButton(text);
        button.setToolTipText(toolTip);
        button.setShowAsFormComponent(false);
        group.add((SAbstractButton)button);
        return button;
    }
}

