/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.editor;

import com.freiheit.superoperty.editor.UIEditorFactory;
import org.wings.SComponent;
import org.wings.STextField;

public class StringEditorFactory
implements UIEditorFactory {
    private static final int LENGTH_LIMIT = 4000;
    private static final int DISPLAY_COLS = 49;
    private final String _userHint;
    private final int _maxLength;

    public StringEditorFactory(String userHint, int maxLength) {
        this._userHint = userHint;
        this._maxLength = maxLength;
    }

    @Override
    public String getUserHint() {
        return this._userHint;
    }

    @Override
    public SComponent createEditComponent(String value) {
        STextField field = new STextField();
        if (value != null) {
            field.setText(value);
        }
        if (this._maxLength > 0) {
            field.setMaxColumns(this._maxLength);
            field.setColumns(this._maxLength <= 47 ? this._maxLength + 2 : 49);
        } else {
            field.setMaxColumns(4000);
            field.setColumns(49);
        }
        return field;
    }

    @Override
    public String extractEditedValue(SComponent comp) {
        return ((STextField)comp).getText();
    }
}

