/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.editor;

import com.freiheit.superoperty.editor.UIEditorFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.SList;
import org.wings.SListCellRenderer;
import org.wings.SPanel;
import org.wings.STemplateLayout;
import org.wings.STextField;

public class OrderedSetTranslationEditor
implements UIEditorFactory {
    private final String _userHint;
    private final Set<String> _validValues;

    public OrderedSetTranslationEditor(Set<String> validValues, String userHint) {
        this._userHint = userHint;
        this._validValues = validValues;
    }

    @Override
    public String getUserHint() {
        return this._userHint;
    }

    @Override
    public SComponent createEditComponent(String value) {
        return new OrderComponent(value);
    }

    @Override
    public String extractEditedValue(SComponent comp) {
        String[][] values = ((OrderComponent)comp).getResult();
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        for (String[] pair : values) {
            if (!isFirst) {
                buf.append("|");
            }
            buf.append(pair[0]).append(":").append(pair[1]);
            isFirst = false;
        }
        return buf.toString();
    }

    private String[] extractValue(String val) {
        String[] result = new String[2];
        int colonIndex = val.indexOf(58);
        if (colonIndex < 0) {
            result[0] = result[1] = val;
        } else {
            result[0] = val.substring(0, colonIndex);
            result[1] = val.substring(colonIndex + 1);
        }
        return result;
    }

    private String[][] convert(String stringRepresentation) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        StringTokenizer tokenizer = new StringTokenizer(stringRepresentation, "|");
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            String[] nameValue = this.extractValue(tok);
            result.add(nameValue);
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    private static STemplateLayout createTemplateLayout(String templateName) {
        URL resource = OrderedSetTranslationEditor.class.getClassLoader().getResource(templateName);
        try {
            return new STemplateLayout(resource);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class Renderer
    implements SListCellRenderer {
        private final SLabel label = new SLabel();

        private Renderer() {
        }

        public SComponent getListCellRendererComponent(SComponent list, Object value, boolean isSelected, int index) {
            String[] val = (String[])value;
            this.label.setText(val[0] + " = " + val[1]);
            return this.label;
        }
    }

    private class OrderComponent
    extends SPanel {
        private static final long serialVersionUID = 1L;
        private final DefaultListModel<String[]> _resultModel;
        private boolean _sourceIsEnabled;
        private final SList _source;
        private final STextField _translation;
        private final SButton _hinzu;
        private final SButton _up;
        private final SButton _down;
        private final SButton _weg;
        private final SList _target;

        public OrderComponent(String value) {
            super((SLayoutManager)OrderedSetTranslationEditor.createTemplateLayout("OrderedSetTranslationEditor.html"));
            this._up = new SButton("^");
            this._down = new SButton("v");
            this._translation = new STextField();
            this._translation.setColumns(15);
            this._hinzu = new SButton("Hinzuf\u00fcgen->");
            this._weg = new SButton("^-Herausnehmen");
            final DefaultListModel<String> modelA = new DefaultListModel<String>();
            for (String str : OrderedSetTranslationEditor.this._validValues) {
                modelA.addElement(str);
            }
            final DefaultListModel<String[]> modelB = new DefaultListModel<String[]>();
            for (String[] pair : OrderedSetTranslationEditor.this.convert(value)) {
                modelB.addElement(pair);
                modelA.removeElement(pair[0]);
            }
            this._resultModel = modelB;
            this._source = new SList(modelA);
            this._source.setVisibleRowCount(1);
            this._source.setSelectionMode(0);
            this._target = new SList(modelB);
            this._target.setCellRenderer((SListCellRenderer)new Renderer());
            this._target.setSelectionMode(0);
            this._hinzu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int idx = OrderComponent.this._source.getSelectedIndex();
                    if (idx < 0) {
                        return;
                    }
                    String modelName = (String)modelA.remove(idx);
                    String modelValue = OrderComponent.this._translation.getText();
                    if (modelValue == null || modelValue.trim().length() == 0) {
                        modelValue = modelName;
                    }
                    modelB.addElement(new String[]{modelName, modelValue});
                    OrderComponent.this._translation.setText("");
                    OrderComponent.this.setSourceEnabled(modelA.getSize() > 0);
                    OrderComponent.this._source.setSelectedIndex(modelA.getSize() - 1);
                    OrderComponent.this._target.setSelectedIndex(modelB.getSize() - 1);
                }
            });
            this._weg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int idx = OrderComponent.this._target.getSelectedIndex();
                    if (idx < 0) {
                        return;
                    }
                    String[] pair = (String[])modelB.remove(idx);
                    modelA.addElement(pair[0]);
                    OrderComponent.this._translation.setText(pair[1]);
                    OrderComponent.this.setSourceEnabled(modelA.getSize() > 0);
                    OrderComponent.this._source.setSelectedIndex(modelA.getSize() - 1);
                    OrderComponent.this._target.setSelectedIndex(modelB.getSize() - 1);
                }
            });
            this._up.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int idx = OrderComponent.this._target.getSelectedIndex();
                    if (idx <= 0) {
                        return;
                    }
                    String[] before = (String[])modelB.remove(idx - 1);
                    String[] element = (String[])modelB.remove(idx - 1);
                    modelB.add(idx - 1, before);
                    modelB.add(idx - 1, element);
                    OrderComponent.this._target.setSelectedIndex(idx - 1);
                }
            });
            this._down.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int idx = OrderComponent.this._target.getSelectedIndex();
                    if (idx < 0 || idx > modelB.getSize() - 2) {
                        return;
                    }
                    String[] element = (String[])modelB.remove(idx);
                    String[] after = (String[])modelB.remove(idx);
                    modelB.add(idx, element);
                    modelB.add(idx, after);
                    OrderComponent.this._target.setSelectedIndex(idx + 1);
                }
            });
            this.add((SComponent)this._source, "source-set");
            this.add((SComponent)this._target, "target-set");
            this.add((SComponent)this._translation, "element-name");
            this.add((SComponent)this._up, "button-up");
            this.add((SComponent)this._down, "button-down");
            this.add((SComponent)this._hinzu, "element-hinzu");
            this.add((SComponent)this._weg, "element-weg");
            this.setSourceEnabled(modelA.getSize() > 0);
        }

        public void setEnabled(boolean e) {
            super.setEnabled(e);
            this.setSourceElementsEnabled(this._sourceIsEnabled && e);
            this.setTargetElementsEnabled(e);
        }

        private void setTargetElementsEnabled(boolean e) {
            this._up.setEnabled(e);
            this._down.setEnabled(e);
            this._weg.setEnabled(e);
            this._target.setEnabled(e);
        }

        private void setSourceElementsEnabled(boolean e) {
            this._source.setEnabled(e);
            this._translation.setEnabled(e);
            this._hinzu.setEnabled(e);
            this._hinzu.setVisible(e);
        }

        private void setSourceEnabled(boolean e) {
            this.setSourceElementsEnabled(e);
            this._sourceIsEnabled = e;
        }

        public String[][] getResult() {
            String[][] result = new String[this._resultModel.size()][];
            int len = this._resultModel.size();
            for (int i = 0; i < len; ++i) {
                result[i] = this._resultModel.get(i);
            }
            return result;
        }
    }
}

