/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.editor;

import com.freiheit.superoperty.editor.UIEditorFactory;
import org.wings.SComponent;
import org.wings.SFont;
import org.wings.SList;
import org.wings.STextField;

public class NumberEditorFactory
implements UIEditorFactory {
    private static final long COMBO_RANGE = 15L;
    private final String _expression;
    private final long _lowerBound;
    private final long _upperBound;

    public NumberEditorFactory(String expression, long lowerBound, long upperBound) {
        this._expression = expression;
        this._lowerBound = lowerBound;
        this._upperBound = upperBound;
    }

    public NumberEditorFactory() {
        this(null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public String getUserHint() {
        if (this._expression == null) {
            return "ganze Zahl";
        }
        return "Zahl ( " + this._expression + " )";
    }

    @Override
    public SComponent createEditComponent(String value) {
        if (this._lowerBound + 15L + 1L > this._upperBound) {
            Object[] values = new String[(int)(this._upperBound - this._lowerBound + 1L)];
            int selectedIndex = 0;
            for (long i = this._lowerBound; i <= this._upperBound; ++i) {
                String selValue = String.valueOf(i);
                int index = (int)(i - this._lowerBound);
                if (selValue.equals(value)) {
                    selectedIndex = index;
                }
                values[index] = selValue;
            }
            SList list = new SList(values);
            list.setFont(new SFont("Sans-Serif", 0, 10));
            list.setSelectionMode(0);
            list.setVisibleRowCount(1);
            list.setSelectedIndex(selectedIndex);
            return list;
        }
        return new STextField(value);
    }

    @Override
    public String extractEditedValue(SComponent comp) {
        if (comp instanceof SList) {
            SList list = (SList)comp;
            return (String)list.getSelectedValue();
        }
        STextField textField = (STextField)comp;
        return textField.getText();
    }
}

