/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.editor;

import com.freiheit.superoperty.converter.ListProvider;
import com.freiheit.superoperty.editor.UIEditorFactory;
import java.util.ArrayList;
import org.wings.SComponent;
import org.wings.SFont;
import org.wings.SList;

public class MultipleSelectionListEditorFactory
implements UIEditorFactory {
    private final ListProvider _listProvider;
    private final ArrayList<String> _listValues;

    public MultipleSelectionListEditorFactory(ListProvider listProvider) {
        this._listProvider = listProvider;
        this._listValues = new ArrayList();
        for (int i = 0; i < this._listProvider.getListItems().length; ++i) {
            this._listValues.add(this._listProvider.getListItems()[i][1]);
        }
    }

    @Override
    public String getUserHint() {
        return "";
    }

    @Override
    public SComponent createEditComponent(String value) {
        SList list = new SList(this._listValues);
        list.setSelectionMode(2);
        list.setVisibleRowCount(this._listValues.size());
        if (value != null) {
            ArrayList<Integer> indicesList = new ArrayList<Integer>();
            for (String splitValue : value.split(",")) {
                indicesList.add(this._listValues.indexOf(splitValue));
            }
            int[] indices = new int[indicesList.size()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indicesList.get(i);
            }
            list.setSelectedIndices(indices);
        } else {
            list.setSelectedIndex(0);
        }
        list.setFont(new SFont("Sans-Serif", 0, 10));
        return list;
    }

    @Override
    public String extractEditedValue(SComponent comp) {
        Object[] values = ((SList)comp).getSelectedValues();
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object val : values) {
            if (!first) {
                result.append(",");
            } else {
                first = false;
            }
            result.append((String)val);
        }
        return result.toString();
    }
}

