/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.editor.OrderedSetTranslationEditor;
import com.freiheit.superoperty.editor.UIEditorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class OrderedSetTranslationConverter
implements PropertyStringConverter {
    private final Set<String> _allowedStrings = new LinkedHashSet<String>();
    private UIEditorFactory _editorFactory;

    @Override
    public void setConfiguration(String config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("require pipe-delimited set of Strings");
        }
        StringTokenizer tokenizer = new StringTokenizer(config, "|");
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            this._allowedStrings.add(tok);
        }
    }

    private String[] extractValue(String val) {
        String[] result = new String[2];
        int colonIndex = val.indexOf(58);
        if (colonIndex < 0) {
            result[0] = result[1] = val;
        } else {
            result[0] = val.substring(0, colonIndex);
            result[1] = val.substring(colonIndex + 1);
        }
        return result;
    }

    @Override
    public String checkValid(String storeString) throws IllegalArgumentException {
        if (storeString == null) {
            return null;
        }
        this.convertToObject(storeString);
        return storeString;
    }

    @Override
    public Object convertToObject(String stringRepresentation) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        HashSet<String> addedValues = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(stringRepresentation, "|");
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            String[] nameValue = this.extractValue(tok);
            String name = nameValue[0];
            if (!this._allowedStrings.contains(name)) {
                throw new IllegalArgumentException("Wert '" + name + "' nicht erlaubt");
            }
            if (addedValues.contains(name)) {
                throw new IllegalArgumentException("Wert '" + name + "' mehrfach enthalten");
            }
            addedValues.add(name);
            result.add(nameValue);
        }
        return result.toArray((T[])new String[result.size()][]);
    }

    @Override
    public String convertFromObject(Object o) throws ClassCastException {
        return (String)o;
    }

    protected UIEditorFactory createEditorFactory() {
        StringBuffer buf = new StringBuffer("[");
        boolean isFirst = true;
        for (String s : this._allowedStrings) {
            if (!isFirst) {
                buf.append(", ");
            }
            buf.append(s);
            isFirst = false;
        }
        buf.append("]");
        return new OrderedSetTranslationEditor(this._allowedStrings, buf.toString());
    }

    @Override
    public final UIEditorFactory getEditorFactory() {
        if (this._editorFactory == null) {
            this._editorFactory = this.createEditorFactory();
        }
        return this._editorFactory;
    }
}

