/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.converter.AbstractListConverter;
import com.freiheit.superoperty.editor.MultipleSelectionListEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;
import java.util.ArrayList;

public class MultipleSelectionListConverter
extends AbstractListConverter
implements PropertyStringConverter {
    @Override
    public String checkValid(String stringRepresentation) throws IllegalArgumentException {
        if (this.getListProvider() == null) {
            throw new IllegalArgumentException("_listProvider is null");
        }
        int result = 0;
        for (String token : stringRepresentation.split(",")) {
            --result;
            for (String[] tuple : this.getListProvider().getListItems()) {
                if (!token.equals(tuple[1])) continue;
                ++result;
            }
            if (result < 0) {
                throw new IllegalArgumentException("value '" + token + "' not in list " + this.printTuples(this.getListProvider().getListItems()));
            }
            if (result <= 0) continue;
            throw new IllegalArgumentException("value '" + token + "' more than once in list " + this.printTuples(this.getListProvider().getListItems()));
        }
        return stringRepresentation;
    }

    @Override
    public Object convertToObject(String stringRepresentation) {
        if (this.getListProvider() != null) {
            ArrayList<String> objects = new ArrayList<String>();
            String[] tokens = stringRepresentation.split(",");
            ArrayList<String> listItems = new ArrayList<String>();
            for (String string : tokens) {
                listItems.add(string);
            }
            for (String string : this.getListProvider().getListItems()) {
                for (String rep : listItems) {
                    if (!rep.equals(string[1])) continue;
                    objects.add(string[0]);
                }
            }
            if (objects.size() == 0) {
                return null;
            }
            String[] result = new String[objects.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)objects.get(i);
            }
            return result;
        }
        return null;
    }

    @Override
    public String convertFromObject(Object o) throws ClassCastException {
        String[] objects = (String[])o;
        if (this.getListProvider() != null) {
            StringBuilder result = new StringBuilder();
            for (String obj : objects) {
                for (String[] tuple : this.getListProvider().getListItems()) {
                    if (!obj.equals(tuple[0])) continue;
                    result.append(tuple[1]);
                    result.append(",");
                }
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
                return result.toString();
            }
            return null;
        }
        return null;
    }

    @Override
    public UIEditorFactory getEditorFactory() {
        return new MultipleSelectionListEditorFactory(this.getListProvider());
    }
}

