/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.editor.StringEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;

public class FloatConverter
implements PropertyStringConverter {
    private boolean _minInclusive = false;
    private boolean _maxInclusive = false;
    private float _minValue = -2.1474836E9f;
    private float _maxValue = 2.1474836E9f;
    private String _tooltip;
    private final int _maxLength = 10;

    @Override
    public void setConfiguration(String s) throws IllegalArgumentException {
        String config = s;
        this._minValue = -2.1474836E9f;
        this._maxValue = 2.1474836E9f;
        if (config != null && (config = config.trim()).length() > 0) {
            boolean isEquals;
            int pos = 0;
            char firstChar = config.charAt(pos);
            boolean bl = isEquals = config.charAt(pos + 1) == '=';
            if (isEquals) {
                ++pos;
            }
            if (firstChar == '<') {
                this._maxValue = Float.parseFloat(config.substring(pos + 1).trim());
                this._maxInclusive = isEquals;
            } else if (firstChar == '>') {
                this._minValue = Float.parseFloat(config.substring(pos + 1).trim());
                this._minInclusive = isEquals;
            } else {
                pos = config.indexOf("..");
                this._minValue = Float.parseFloat(config.substring(0, pos).trim());
                this._maxValue = Float.parseFloat(config.substring(pos + 2).trim());
                this._minInclusive = true;
                this._maxInclusive = true;
            }
        }
        if (this._maxValue < this._minValue) {
            throw new IllegalArgumentException("Obere Grenze kleiner als untere (" + this._maxValue + "!>" + this._minValue + ")");
        }
        this._tooltip = config;
    }

    @Override
    public String checkValid(String stringRepresentation) throws IllegalArgumentException {
        if (stringRepresentation == null) {
            throw new IllegalArgumentException("Wert darf nicht null sein!");
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(stringRepresentation.trim());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("'" + stringRepresentation + "' ist keine Zahl!" + e);
        }
        if (this._minInclusive) {
            if (f < this._minValue) {
                throw new IllegalArgumentException("'" + stringRepresentation + "' ist kleiner als der Minimal-Wert (" + this._minValue + ")!");
            }
        } else if (f <= this._minValue) {
            throw new IllegalArgumentException("'" + stringRepresentation + "' ist kleiner oder gleich dem Minimal-Wert (" + this._minValue + ")!");
        }
        if (this._maxInclusive) {
            if (f > this._maxValue) {
                throw new IllegalArgumentException("'" + stringRepresentation + "' ist gr\u00f6\u00dfer als der Maximal-Wert (" + this._maxValue + ")!");
            }
        } else if (f >= this._maxValue) {
            throw new IllegalArgumentException("'" + stringRepresentation + "' ist gr\u00f6\u00dfer oder gleich dem Maximal-Wert (" + this._maxValue + ")!");
        }
        return String.valueOf(f);
    }

    @Override
    public Object convertToObject(String stringRepresentation) {
        return Float.valueOf(this.checkValid(stringRepresentation));
    }

    @Override
    public String convertFromObject(Object o) throws ClassCastException {
        return o.toString();
    }

    @Override
    public UIEditorFactory getEditorFactory() {
        return new StringEditorFactory(this._tooltip, 10);
    }
}

