/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.converter.ListProvider;

public abstract class AbstractListConverter {
    private ListProvider _listProvider;

    public void setConfiguration(String config) throws IllegalArgumentException {
        Class<?> c;
        try {
            c = Class.forName(config);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("unknown class " + config, e);
        }
        if (!ListProvider.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(config + " is not an implementor of " + ListProvider.class.getName());
        }
        try {
            this._listProvider = (ListProvider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("unable to instantiate " + config, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to instantiate " + config, e);
        }
    }

    protected ListProvider getListProvider() {
        return this._listProvider;
    }

    protected String printTuples(String[][] tuples) {
        StringBuilder result = new StringBuilder("[");
        for (String[] tuple : tuples) {
            result.append("(").append(tuple[0]);
            result.append(", ").append(tuple[1]).append(") ");
        }
        result.append("]");
        return result.toString();
    }
}

