/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty;

import com.freiheit.superoperty.InheritanceType;
import com.freiheit.superoperty.PropertyStringConverter;

public final class MetaProperty {
    private final String _name;
    private String _converterConfiguration;
    private Class<?> _converterClass;
    private PropertyStringConverter _converter;
    private String _description;
    private InheritanceType _inheritance;
    private boolean _isFixed;

    MetaProperty(String name) {
        this._name = name;
        this._isFixed = false;
    }

    public String getName() {
        return this._name;
    }

    void lockValues() {
        this._isFixed = true;
    }

    public boolean isFinallyDefined() {
        return this._isFixed;
    }

    public PropertyStringConverter getConverter() {
        return this._converter;
    }

    void setInheritance(InheritanceType inheritance) {
        this.assertNotFixed();
        this._inheritance = inheritance;
    }

    public InheritanceType getInheritance() {
        return this._inheritance;
    }

    boolean setAndCheckConverterClass(Class<?> converterClazz, String converterConfig) {
        this.assertNotFixed();
        if (converterClazz == this._converterClass && this.stringEqual(converterConfig, this._converterConfiguration)) {
            return false;
        }
        try {
            PropertyStringConverter converter = (PropertyStringConverter)converterClazz.newInstance();
            converter.setConfiguration(converterConfig);
            this._converterClass = converterClazz;
            this._converter = converter;
            this._converterConfiguration = converterConfig;
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
        return true;
    }

    private boolean stringEqual(String a, String b) {
        if (a == b) {
            return true;
        }
        return a != null && a.equals(b);
    }

    public Class<?> getConverterClass() {
        return this._converterClass;
    }

    void setConverterConfiguration(String converterConfiguration) {
        this.assertNotFixed();
        this._converter.setConfiguration(converterConfiguration);
        this._converterConfiguration = converterConfiguration;
    }

    public String getConverterConfiguration() {
        return this._converterConfiguration;
    }

    void setDescription(String desc) {
        this.assertNotFixed();
        this._description = desc;
    }

    public String getDescription() {
        return this._description;
    }

    private void assertNotFixed() {
        if (this._isFixed) {
            throw new IllegalStateException(this.getName() + ": cannot change already fixed MetaProperty");
        }
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object other) {
        if (other instanceof MetaProperty) {
            return ((MetaProperty)other)._name.equals(this._name);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

