/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty;

import com.freiheit.superoperty.FinalOverrideException;
import com.freiheit.superoperty.InheritanceType;
import com.freiheit.superoperty.MetaProperty;
import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.SuperopertyChangeSupport;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DomainProperty
implements Property {
    private static final Log LOG = LogFactory.getLog(DomainProperty.class);
    private final Property _parentProperty;
    private final String _domain;
    private volatile boolean _containsValue;
    private volatile String _stringValue;
    private volatile Object _value;
    private boolean _isDefined;
    private final SuperopertyChangeSupport _changeSupport;
    private int _version;

    DomainProperty(Property parentProperty, String domain) {
        if (domain == null) {
            throw new NullPointerException("Domain must not be null!");
        }
        MetaProperty meta = parentProperty.getMetaProperty();
        if (meta.getInheritance() == InheritanceType.FINAL) {
            throw new FinalOverrideException(meta, "cannot create Domain property for domain '" + domain + "', since the property is final and thus cannot be overridden");
        }
        this._parentProperty = parentProperty;
        this._domain = domain;
        this._isDefined = false;
        this._changeSupport = new SuperopertyChangeSupport();
        this._version = 0;
    }

    @Override
    public String getDomain() {
        return this._domain;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public Property getParentProperty() {
        return this._parentProperty;
    }

    @Override
    public MetaProperty getMetaProperty() {
        return this._parentProperty.getMetaProperty();
    }

    @Override
    public boolean isValueInherited() {
        return !this._containsValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLocalValue() {
        DomainProperty domainProperty = this;
        synchronized (domainProperty) {
            if (this._containsValue) {
                this._containsValue = false;
                ++this._version;
                this._changeSupport.fireValueRemoved(this, this._domain, this._stringValue, this._value);
            }
        }
    }

    void setDefined() {
        this._isDefined = true;
    }

    boolean isAlreadyDefined() {
        return this._isDefined;
    }

    @Override
    public Object getValue() {
        return this._containsValue ? this._value : this._parentProperty.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) throws IllegalArgumentException {
        DomainProperty domainProperty = this;
        synchronized (domainProperty) {
            String oldString = this._stringValue;
            Object oldValue = this._value;
            this._stringValue = this.getMetaProperty().getConverter().convertFromObject(value);
            this._value = value;
            this.informValueChanged(oldString, oldValue);
        }
    }

    @Override
    public String getStringValue() {
        if (this.isValueInherited()) {
            LOG.error((Object)(this._parentProperty.getMetaProperty() + ": attempt to access property that is not set"));
        }
        return this._stringValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(String value) throws IllegalArgumentException {
        DomainProperty domainProperty = this;
        synchronized (domainProperty) {
            String oldString = this._stringValue;
            Object oldValue = this._value;
            PropertyStringConverter converter = this.getMetaProperty().getConverter();
            String newValue = converter.checkValid(value);
            this._value = converter.convertToObject(newValue);
            this._stringValue = newValue;
            this.informValueChanged(oldString, oldValue);
        }
    }

    private void informValueChanged(String oldString, Object oldValue) {
        ++this._version;
        if (this._containsValue) {
            if (!this._changeSupport.fireIfValueChanged(this, this._domain, oldString, oldValue, this._stringValue, this._value)) {
                --this._version;
            }
        } else {
            this._containsValue = true;
            this._changeSupport.fireValueAdded(this, this._domain, this._stringValue, this._value);
        }
    }

    @Override
    public void addSuperopertyChangeListener(SuperopertyChangeListener listener) {
        this._changeSupport.addSuperopertyChangeListener(listener);
    }

    @Override
    public void removeSuperopertyChangeListener(SuperopertyChangeListener listener) {
        this._changeSupport.removeSuperopertyChangeListener(listener);
    }
}

