/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.ibatis.support.AbstractLobTypeHandler;

public class BlobSerializableTypeHandler
extends AbstractLobTypeHandler {
    public BlobSerializableTypeHandler() {
    }

    protected BlobSerializableTypeHandler(LobHandler lobHandler) {
        super(lobHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setParameterInternal(PreparedStatement ps, int index, Object value, String jdbcType, LobCreator lobCreator) throws SQLException, IOException {
        if (value != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(value);
                oos.flush();
                lobCreator.setBlobAsBytes(ps, index, baos.toByteArray());
            }
        } else {
            lobCreator.setBlobAsBytes(ps, index, null);
        }
    }

    @Override
    protected Object getResultInternal(ResultSet rs, int index, LobHandler lobHandler) throws SQLException, IOException {
        InputStream is = lobHandler.getBlobAsBinaryStream(rs, index);
        if (is != null) {
            try (ObjectInputStream ois = new ObjectInputStream(is);){
                Object object = ois.readObject();
                return object;
            }
        }
        return null;
    }

    public Object valueOf(String s) {
        return s;
    }
}

