/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.app.search.model.SearchFilterOption;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelectedSearchFilterOptions {
    private final String _id;
    private final ImmutableList<String> _options;

    @JsonCreator
    public SelectedSearchFilterOptions(@JsonProperty(value="id") String id, @JsonProperty(value="options") Iterable<String> options) {
        this._id = id;
        this._options = ImmutableList.copyOf(options);
    }

    @Nonnull
    public String getId() {
        return this._id;
    }

    @Nonnull
    public ImmutableList<String> getOptions() {
        return this._options;
    }

    @Nonnull
    @JsonIgnore
    public static SelectedSearchFilterOptions of(String filterId, String optionValue) {
        return new SelectedSearchFilterOptions(filterId, (Iterable<String>)ImmutableList.of((Object)optionValue));
    }

    @Nonnull
    @JsonIgnore
    public static SelectedSearchFilterOptions of(SearchFilterOption option) {
        return SelectedSearchFilterOptions.of(option.getFilterId(), option.getOptionValue());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("options", this._options).toString();
    }
}

