/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.app.search.model.SearchFilterOption;
import de.justsoftware.app.search.model.SearchFilterSelectType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchFilter {
    private final String _id;
    private final String _name;
    private final SearchFilterSelectType _selectType;
    private final String _documentType;
    private final String _documentAttribute;
    private final boolean _optionsTranslatable;
    private final String _defaultOptionValue;
    private final ArrayList<SearchFilterOption> _options;

    public SearchFilter(String id, SearchFilterSelectType selectType, @Nullable String defaultOptionValue) {
        this(id, id, selectType, true, defaultOptionValue, null, null);
    }

    public SearchFilter(String id, String name, SearchFilterSelectType selectType, boolean optionsTranslatable, @Nullable String defaultOptionValue, @Nullable String documentType, @Nullable String documentAttribute) {
        this(id, name, selectType, optionsTranslatable, defaultOptionValue, documentType, documentAttribute, null);
    }

    @JsonCreator
    public SearchFilter(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="selectType") SearchFilterSelectType selectType, @JsonProperty(value="optionsTranslatable") boolean optionsTranslatable, @Nullable @JsonProperty(value="defaultOptionValue", required=false) String defaultOptionValue, @Nullable @JsonProperty(value="documentType", required=false) String documentType, @Nullable @JsonProperty(value="documentAttribute", required=false) String documentAttribute, @Nullable @JsonProperty(value="options") List<SearchFilterOption> options) {
        this._id = id;
        this._name = name;
        this._selectType = selectType;
        this._optionsTranslatable = optionsTranslatable;
        this._defaultOptionValue = defaultOptionValue;
        this._options = options != null ? new ArrayList<SearchFilterOption>(options) : new ArrayList();
        this._documentAttribute = documentAttribute;
        this._documentType = documentType;
    }

    @Nonnull
    public String getId() {
        return this._id;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public SearchFilterSelectType getSelectType() {
        return this._selectType;
    }

    @Nonnull
    public ImmutableList<SearchFilterOption> getOptions() {
        return ImmutableList.copyOf(this._options);
    }

    public void addOption(SearchFilterOption option) {
        this._options.add(option);
    }

    public boolean isOptionsTranslatable() {
        return this._optionsTranslatable;
    }

    @CheckForNull
    public String getDefaultOptionValue() {
        return this._defaultOptionValue;
    }

    @CheckForNull
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDocumentAttribute() {
        return this._documentAttribute;
    }

    @CheckForNull
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDocumentType() {
        return this._documentType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("name", (Object)this._name).add("selectType", (Object)this._selectType).add("options", this._options).add("documentType", (Object)this._documentType).add("documentAttribute", (Object)this._documentAttribute).add("optionsTranslatable", this._optionsTranslatable).add("defaultOptionValue", (Object)this._defaultOptionValue).toString();
    }
}

