/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.business.impl;

import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.app.search.business.SearchFilterService;
import de.justsoftware.app.search.business.SearchService;
import de.justsoftware.app.search.model.SearchFilter;
import de.justsoftware.app.search.model.SearchRequest;
import de.justsoftware.app.search.model.SearchRequestAndResult;
import de.justsoftware.app.search.model.SearchResult;
import de.justsoftware.app.search.model.SearchTeaser;
import de.justsoftware.app.search.model.SelectedSearchFilterOptions;
import de.justsoftware.app.search.model.SuggestResults;
import de.justsoftware.app.search.model.SuggestTeaser;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.searchnew.business.CommonSearchService;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterSelector;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchServiceImpl
implements SearchService {
    private final CommonSearchService _commonSearchService;
    private final SearchFilterService _searchFilterService;
    private final SearchConfigurationProvider _searchConfigurationProvider;

    @Autowired
    public SearchServiceImpl(CommonSearchService commonSearchService, SearchFilterService searchFilterService, SearchConfigurationProvider searchConfigurationProvider) {
        this._commonSearchService = commonSearchService;
        this._searchFilterService = searchFilterService;
        this._searchConfigurationProvider = searchConfigurationProvider;
    }

    @Override
    public SearchResult doSearch(SearchRequest request, AuthorizationContext authCtx) {
        FilterType filterType = (FilterType)MoreObjects.firstNonNull((Object)this._searchFilterService.getFilterTypeOf((Iterable<SelectedSearchFilterOptions>)request.getSearchFilterOptions()), (Object)StaticFilterType.ALL);
        ImmutableMap<String, SearchFilter> searchFilters = this._searchFilterService.getSearchFilterDefinitions(filterType, authCtx);
        SearchParameters searchParameters = this.getSearchParameters(request, searchFilters, authCtx);
        return this.search(searchParameters, searchFilters, authCtx);
    }

    @Override
    public SearchRequestAndResult doSearchForToken(String token, AuthorizationContext authCtx) throws TokenUtil.TokenParseException {
        SearchParameters searchParameters = TokenUtilServer.INSTANCE.parseSearchParametersFromSearchToken(token, null);
        SearchRequest searchRequest = this.getSearchRequest(searchParameters, authCtx);
        SearchResult searchResult = this.search(searchParameters, authCtx);
        return new SearchRequestAndResult(searchRequest, searchResult);
    }

    @Nonnull
    private SearchResult search(SearchParameters searchParameters, AuthorizationContext authCtx) {
        ImmutableMap<String, SearchFilter> searchFilters = this._searchFilterService.getSearchFilterDefinitions(searchParameters.getFilterTypeOrAll(), authCtx);
        return this.search(searchParameters, searchFilters, authCtx);
    }

    @Nonnull
    private SearchResult search(SearchParameters searchParameters, ImmutableMap<String, SearchFilter> searchFilters, AuthorizationContext authCtx) {
        de.justsoftware.onx.searchnew.shared.model.SearchResult result = this._commonSearchService.search(searchParameters, 0, 0, null, (SearchAuthorizationCheckContext)authCtx);
        SearchFilter contextSearchFilter = this._searchFilterService.getContextSearchFilterDefinition(searchParameters.getSearchContextOrEntirePlatform());
        this._searchFilterService.addOptionsAndCountToSearchFilters((de.justsoftware.onx.searchnew.shared.model.SearchResult<FederatedSearchResultEntry>)result, searchFilters, contextSearchFilter, searchParameters);
        ImmutableList availableSearchFilters = ImmutableList.copyOf((Collection)searchFilters.values());
        ImmutableList<String> availableSortTypes = this._searchFilterService.getAvailableSortTypes(searchParameters);
        SortType sortType = searchParameters.getSortType();
        if (sortType == null || !availableSortTypes.contains((Object)sortType.name())) {
            sortType = SearchParameters.createDefaultSortType((SearchConfigurationProvider)this._searchConfigurationProvider, (String)searchParameters.getText(), (FilterType)searchParameters.getFilterType(), (DateSubFilter)searchParameters.getDateSubfilter());
        }
        return new SearchResult(0L, result.getNumberOfResults(), (Iterable<SearchTeaser>)ImmutableList.of(), (Iterable<SearchFilter>)availableSearchFilters, contextSearchFilter, (Iterable<String>)availableSortTypes, sortType.name(), TokenUtilServer.INSTANCE.createSearchToken(searchParameters, null));
    }

    @Nonnull
    private SearchParameters getSearchParameters(SearchRequest request, ImmutableMap<String, SearchFilter> searchFilters, AuthorizationContext authCtx) {
        String searchProvider;
        SortType sortType;
        Set<SelectedSearchFilterOptions> activeSelectedOptions = request.getSearchFilterOptions().stream().filter(selectedOption -> searchFilters.keySet().contains((Object)selectedOption.getId())).collect(Collectors.toSet());
        String searchString = request.getSearchString();
        FilterType filter = this._searchFilterService.getFilterTypeOf(activeSelectedOptions);
        SearchContext context = SearchContext.getByName((String)request.getContext());
        String contextId = request.getContextId();
        GlobalId contextGlobalId = contextId != null ? GlobalId.parse((String)contextId) : null;
        String sType = request.getSortType();
        ImmutableSet<SubFilter> subfilter = this._searchFilterService.getSubfilterOf(activeSelectedOptions, filter, authCtx);
        SortType sortType2 = sortType = sType != null ? (SortType)Enums.getIfPresent(SortType.class, (String)sType).orNull() : null;
        if (sortType == null) {
            DateSubFilter dateSubfilter = (DateSubFilter)SubFilterSelector.skipAll().selectDateSubFilter().first(subfilter, null);
            sortType = SearchParameters.createDefaultSortType((SearchConfigurationProvider)this._searchConfigurationProvider, (String)searchString, (FilterType)filter, (DateSubFilter)dateSubfilter);
        }
        SearchProviderId searchProviderId = (searchProvider = request.getSearchProvider()) != null ? new SearchProviderId(searchProvider) : null;
        SearchFacetParameters searchFacets = this._searchFilterService.getSearchFacetParameters(request.getSearchForOptions(), searchFilters);
        return new SearchParameters(searchString, filter, context, contextGlobalId, null, sortType, subfilter, searchProviderId, searchFacets);
    }

    @Nonnull
    private SearchRequest getSearchRequest(SearchParameters searchParameters, AuthorizationContext authCtx) {
        ImmutableList<SelectedSearchFilterOptions> selectedFilters = this._searchFilterService.getSelectedSearchFilterOptions(searchParameters, authCtx);
        return new SearchRequest(searchParameters.getText(), (Iterable<SelectedSearchFilterOptions>)selectedFilters, searchParameters.getSortType(), searchParameters.getSearchContextOrEntirePlatform(), searchParameters.getContextId(), searchParameters.getSearchProvider());
    }

    @Override
    public SuggestResults suggest(SearchRequest request, int offset, int count, AuthorizationContext authCtx) {
        FilterType filterType = (FilterType)MoreObjects.firstNonNull((Object)this._searchFilterService.getFilterTypeOf((Iterable<SelectedSearchFilterOptions>)request.getSearchFilterOptions()), (Object)StaticFilterType.ALL);
        ImmutableMap<String, SearchFilter> searchFilters = this._searchFilterService.getSearchFilterDefinitions(filterType, authCtx);
        SearchParameters searchParameters = this.getSearchParameters(request, searchFilters, authCtx);
        de.justsoftware.onx.searchnew.shared.model.SearchResult suggest = this._commonSearchService.suggest(searchParameters.getText(), searchParameters.getSearchContextModel(), ImmutableSet.of((Object)searchParameters.getFilterTypeOrAll()), searchParameters.getSortType(), (Collection)searchParameters.getSubfilter(), offset, count, (SearchAuthorizationCheckContext)authCtx);
        ImmutableList results = (ImmutableList)suggest.getResults().stream().map(SuggestTeaser::fromSuggestModel).collect(ImmutableList.toImmutableList());
        return new SuggestResults(request, offset, count, suggest.getNumberOfResults(), (ImmutableList<SuggestTeaser>)results);
    }
}

