/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.business.impl;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.app.search.business.SearchFilterService;
import de.justsoftware.app.search.model.SearchFilter;
import de.justsoftware.app.search.model.SearchFilterOption;
import de.justsoftware.app.search.model.SearchFilterOptionRequest;
import de.justsoftware.app.search.model.SearchFilterSelectType;
import de.justsoftware.app.search.model.SelectedSearchFilterOptions;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.searchnew.business.CommonSearchService;
import de.justsoftware.onx.searchnew.business.FilterConfiguration;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.BlockSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ChatUserSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CoadminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.InheritAdminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ModelBasedSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.ModificationDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.OrSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonIdSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonModelSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PublicationDateFilter;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetContainsParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SimpleSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StartAndEndDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StartDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterVisitor;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import de.justsoftware.onx.util.shared.Streams;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.shaded.com.google.common.base.Joiner;
import org.apache.curator.shaded.com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchFilterServiceImpl
implements SearchFilterService {
    private static final ImmutableSet<FilterType> ARCHIVE_STATIC_FILTER_TYPES = ImmutableSet.of((Object)StaticFilterType.ALL, (Object)StaticFilterType.DOCUMENTS, (Object)StaticFilterType.WORKSTREAMS);
    private static final ImmutableSet<ProfileAttributeType> TRANSLATABLE_OPTION_ATTRIBUTE_TYPES = ImmutableSet.of((Object)ProfileAttributeType.SELECT, (Object)ProfileAttributeType.TREE_SELECT, (Object)ProfileAttributeType.CHECKRADIO);
    private static final String SEPARATOR = ".";
    private static final String TYPE = "TYPE";
    private static final String MY_CONTENT = "MY_CONTENT";
    private static final String ALL = "ALL";
    private static final String PROFILE = "PROFILE";
    private static final String ENTITY = "ENTITY";
    private static final String MICROBLOG = "MICROBLOG";
    private static final String POSTS = "POSTS";
    private static final String CHANNELS = "CHANNELS";
    private static final String CONNECT = "CONNECT";
    private static final String CHAT = "CHAT";
    private static final String DRIVE = "DRIVE";
    private static final String WIKI = "WIKI_WIKI";
    private static final String CHAPTER = "WIKI_CHAPTER";
    private static final String ARTICLE = "WIKI_ARTICLE";
    private static final String DATE = "DATE";
    private static final String PERSON_ROLE = "PERSONROLE";
    private static final String MODIFICATION_DATE = "MODIFICATIONDATE";
    private static final String ENTITY_DYNAMIC_ATTRIBUTE = "ENTITYDYNAMICATTRIBUTE";
    private static final String ARCHIVE = "ARCHIVE";
    private static final String BLOCKED = "BLOCKED";
    private static final String ENTITY_STATUS = "ENTITYSTATUS";
    private static final String TAG = "TAG";
    private static final String FILE_TYPE = "FILETYPE";
    private static final String PROFILE_ATTRIBUTE = "PROFILEATTRIBUTE";
    private static final String DOCUMENT_FILE_TYPE = "DOCUMENTFILETYPE";
    private static final SearchContext DEFAULT_MY_CONTENT_SEARCH_CONTEXT = SearchContext.MY_CONTENT;
    private static final SearchContext DEFAULT_SEARCH_CONTEXT = SearchContext.ENTIRE_PLATFORM;
    private static final String DEFAULT_FILTER_TYPE = "ALL";
    private static final String DEFAULT_SINGLE_SELECT_OPTION = "ALL";
    private static final FilterTypeVisitor<KeyValue> FILTER_TYPE_TO_OPTION = new FilterTypeVisitor<KeyValue>(){

        public KeyValue visitDefault() {
            return new KeyValue("ALL", null);
        }

        public KeyValue visitAll() {
            return new KeyValue("ALL", null);
        }

        public KeyValue visitNewsPosts() {
            return new KeyValue(SearchFilterServiceImpl.POSTS, null);
        }

        public KeyValue visitNewsChannels() {
            return new KeyValue(SearchFilterServiceImpl.CHANNELS, null);
        }

        public KeyValue visitProfiles() {
            return new KeyValue(SearchFilterServiceImpl.PROFILE, null);
        }

        public KeyValue visitEntity(EntityType entityType) {
            return new KeyValue(SearchFilterServiceImpl.ENTITY, entityType.name());
        }

        public KeyValue visitMicroblogs() {
            return new KeyValue(SearchFilterServiceImpl.MICROBLOG, null);
        }

        public KeyValue visitConversations() {
            return new KeyValue(SearchFilterServiceImpl.CONNECT, null);
        }

        public KeyValue visitChats() {
            return new KeyValue(SearchFilterServiceImpl.CHAT, null);
        }

        public KeyValue visitDocuments() {
            return new KeyValue(SearchFilterServiceImpl.DRIVE, null);
        }

        public KeyValue visitWiki() {
            return new KeyValue(SearchFilterServiceImpl.WIKI, null);
        }

        public KeyValue visitChapter() {
            return new KeyValue(SearchFilterServiceImpl.CHAPTER, null);
        }

        public KeyValue visitArticle() {
            return new KeyValue(SearchFilterServiceImpl.ARTICLE, null);
        }
    };
    private static final SubFilterVisitor<SelectedSearchFilterOptions> SUBFILTER_TO_SELECTED_SEARCH_FILTER_OPTIONS = new SubFilterVisitor<SelectedSearchFilterOptions>(){

        @Nonnull
        @ParametersAreNonnullByDefault
        private SelectedSearchFilterOptions searchFilterOptions(String filterId, String ... options) {
            return this.searchFilterOptions(filterId, Arrays.asList(options));
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        private SelectedSearchFilterOptions searchFilterOptions(String filterId, Iterable<String> options) {
            return new SelectedSearchFilterOptions(filterId, options);
        }

        public SelectedSearchFilterOptions visitDateSubFilter(DateSubFilter filter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.DATE, filter.name());
        }

        public SelectedSearchFilterOptions visitStartAndEndDateSubFilter(StartAndEndDateSubFilter filter) {
            return null;
        }

        public SelectedSearchFilterOptions visitStartDateSubFilter(StartDateSubFilter filter) {
            return null;
        }

        public SelectedSearchFilterOptions visitPersonRoleSubFilter(PersonRoleSubFilter roleSubFilter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.PERSON_ROLE, (Iterable<String>)roleSubFilter.getFilterValues());
        }

        public SelectedSearchFilterOptions visitPersonIdSubFilter(PersonIdSubFilter personIdSubFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitOrSubFilter(OrSubFilter orSubFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitEntityMemberSubFilter(EntityMemberSubFilter entityMemberSubFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitInheritMemberSubFilter(InheritMemberSubFilter inheritMemberSubFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitInheritAdminSubFilter(InheritAdminSubFilter inheritAdminSubFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitPublicationDate(PublicationDateFilter publicationDateFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitDocumentFileType(DocumentFileTypeSubFilter subfilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitModificationDate(ModificationDateSubFilter subfilter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.MODIFICATION_DATE, subfilter.name());
        }

        public SelectedSearchFilterOptions visitEntityDynamicAttributeSubFilter(EntityDynamicAttributeSubFilter subFilter) {
            return this.searchFilterOptions(KeyValue.join(SearchFilterServiceImpl.ENTITY_DYNAMIC_ATTRIBUTE, subFilter.getEntityType().name(), subFilter.getAttributeId().getId()), (Iterable<String>)subFilter.getFilterValues());
        }

        public SelectedSearchFilterOptions visitCoadminSubFilter(CoadminSubFilter coadminSubFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitArchiveSubFilter(ArchiveSubFilter archiveSubFilter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.ARCHIVE, archiveSubFilter.name());
        }

        public SelectedSearchFilterOptions visitBlockedSubFilter(BlockSubFilter blockedSubFilter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.BLOCKED, blockedSubFilter.name());
        }

        public SelectedSearchFilterOptions visitChatUserSubFilter(ChatUserSubFilter chatUserSubFilter) {
            return null;
        }

        public SelectedSearchFilterOptions visitEntityStatusSubFilter(EntityStatusSubFilter entityStatusSubFilter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.ENTITY_STATUS, entityStatusSubFilter.getStatusIds().stream().map(LongId::toString).collect(Collectors.toList()));
        }

        public SelectedSearchFilterOptions visitTagSubFilter(TagSubFilter tagSubFilter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.TAG, (Iterable<String>)tagSubFilter.getFilterValues());
        }

        public SelectedSearchFilterOptions visitDriveFileTypeSubFilter(DriveFileTypeSubFilter driveFileTypeSubFilter) {
            return this.searchFilterOptions(SearchFilterServiceImpl.FILE_TYPE, (Iterable<String>)driveFileTypeSubFilter.getFilterValues());
        }

        public SelectedSearchFilterOptions visitProfileAttributeSubFilter(ProfileAttributeSubFilter profileAttributeSubFilter) {
            return this.searchFilterOptions(KeyValue.join(SearchFilterServiceImpl.PROFILE_ATTRIBUTE, profileAttributeSubFilter.getName()), (Iterable<String>)profileAttributeSubFilter.getFilterValues());
        }

        public SelectedSearchFilterOptions visitDriveDocumentTypeSubFilter(DriveDocumentTypeSubFilter driveDocumentTypeSubfilter) {
            return null;
        }
    };
    private static final SearchFacetCounts.SearchFacetCountsVisitor<Stream<OptionCount>> SEARCH_FACET_COUNTS_TO_OPTION_COUNTS = new SearchFacetCounts.SearchFacetCountsVisitor<Stream<OptionCount>>(){

        public Stream<OptionCount> visit(SimpleSearchFacetCounts ssfc) {
            return ssfc.getFacetCounts().entrySet().stream().flatMap(this::mapEntryToOptionCount);
        }

        @Nonnull
        private Stream<OptionCount> mapEntryToOptionCount(@Nonnull Map.Entry<String, Long> entry) {
            String optionValue = entry.getKey();
            Long count = entry.getValue();
            return count == null || optionValue == null ? Stream.empty() : Stream.of(new OptionCount(optionValue, count));
        }

        public Stream<OptionCount> visit(PersonModelSearchFacetCounts pmsfc) {
            return pmsfc.getFacetCounts().stream().flatMap(this::personTeaserModelToOptionCount);
        }

        @Nonnull
        private Stream<OptionCount> personTeaserModelToOptionCount(@Nonnull ModelBasedSearchFacetCounts.SearchFacetCountEntry<PersonTeaserModel> entry) {
            Long count = entry.getCount();
            PersonTeaserModel facetModel = (PersonTeaserModel)entry.getFacetModel();
            return count == null || facetModel == null ? Stream.empty() : Stream.of(new OptionCount(((PersonId)facetModel.getId()).toString(), facetModel.getFullName(), count));
        }

        public Stream<OptionCount> visit(EntityStatusSearchFacetCounts essfc) {
            return essfc.getFacetCounts().stream().flatMap(this::entityStatusClientModelToOptionCount);
        }

        @Nonnull
        private Stream<OptionCount> entityStatusClientModelToOptionCount(@Nonnull ModelBasedSearchFacetCounts.SearchFacetCountEntry<EntityStatusClientModel> entry) {
            Long count = entry.getCount();
            EntityStatusClientModel facetModel = (EntityStatusClientModel)entry.getFacetModel();
            return count == null || facetModel == null ? Stream.empty() : Stream.of(new OptionCount(facetModel.getId().toString(), count));
        }
    };
    private final SearchConfigurationProvider _searchConfigurationProvider;
    private final FilterConfiguration _filterConfiguration;
    private final EntityConfigService _entityConfigService;
    private final ProfileReadDataService _profileReadDataService;
    private final CommonSearchService _commonSearchService;

    @Autowired
    public SearchFilterServiceImpl(SearchConfigurationProvider searchConfigurationProvider, FilterConfiguration filterConfiguration, EntityConfigService entityConfigService, ProfileReadDataService profileReadDataService, CommonSearchService commonSearchService) {
        this._searchConfigurationProvider = searchConfigurationProvider;
        this._filterConfiguration = filterConfiguration;
        this._entityConfigService = entityConfigService;
        this._profileReadDataService = profileReadDataService;
        this._commonSearchService = commonSearchService;
    }

    @Nonnull
    private SearchFilterOption transformFilterTypeToFilterOption(FilterType filterType) {
        KeyValue optionValueAndType = (KeyValue)filterType.accept(FILTER_TYPE_TO_OPTION);
        String translationKey = (String)MoreObjects.firstNonNull((Object)optionValueAndType.getKey(), (Object)"");
        String optionType = optionValueAndType.getValue();
        String optionValue = optionType != null ? translationKey + SEPARATOR + optionType : translationKey;
        return new SearchFilterOption(TYPE, optionValue, optionType, translationKey, 0L);
    }

    @Nonnull
    private ImmutableMap<String, FilterType> getOptionValueToFilterTypeMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this._filterConfiguration.getOrderedFilterTypes().forEach(filter -> builder.put((Object)this.transformFilterTypeToFilterOption((FilterType)filter).getOptionValue(), filter));
        return builder.build();
    }

    private void addFilterType(ImmutableMap.Builder<String, SearchFilter> definitions) {
        SearchFilter typeFilter = new SearchFilter(TYPE, SearchFilterSelectType.SINGLE, "ALL");
        definitions.put((Object)TYPE, (Object)typeFilter);
    }

    private void addSubfilter(ImmutableMap.Builder<String, SearchFilter> definitions, String id, String name, SearchFilterSelectType selectType, boolean optionsTranslatable, @Nullable String documentType, @Nullable String documentAttribute, @Nullable String defaultOptionValue) {
        definitions.put((Object)id, (Object)new SearchFilter(id, name, selectType, optionsTranslatable, defaultOptionValue, documentType, documentAttribute));
    }

    private void addSubfilter(ImmutableMap.Builder<String, SearchFilter> definitions, String id, SearchFilterSelectType selectType, boolean optionsTranslatable, @Nullable String defaultOptionValue) {
        this.addSubfilter(definitions, id, id, selectType, optionsTranslatable, null, null, defaultOptionValue);
    }

    @CheckForNull
    private EntityType getEntityTypeFromFilterType(FilterType filterType) {
        return filterType instanceof EntityFilterType ? ((EntityFilterType)filterType).getType() : null;
    }

    private void addDateSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        EntityType entityType = this.getEntityTypeFromFilterType(filterType);
        if (entityType != null && this._entityConfigService.getDurationTimeOption(entityType) != EntityDurationTimeOption.OFF) {
            String defaultFilterOption = this.getFirstOptionValue((SelectedSearchFilterOptions)DateSubFilter.FUTURE.accept(SUBFILTER_TO_SELECTED_SEARCH_FILTER_OPTIONS));
            this.addSubfilter(definitions, DATE, SearchFilterSelectType.SINGLE, true, defaultFilterOption);
        }
    }

    private boolean hasArchiveFilterType(FilterType filterType) {
        if (ARCHIVE_STATIC_FILTER_TYPES.contains((Object)filterType)) {
            for (EntityType entityType : this._entityConfigService.getOrderedActivatedEntityTypes()) {
                if (!this._entityConfigService.showArchiveSearchFilter(entityType)) continue;
                return true;
            }
            return false;
        }
        EntityType entityType = this.getEntityTypeFromFilterType(filterType);
        return entityType != null && this._entityConfigService.showArchiveSearchFilter(entityType);
    }

    @CheckForNull
    private String getFirstOptionValue(@Nullable SelectedSearchFilterOptions options) {
        if (options == null || options.getOptions().isEmpty()) {
            return null;
        }
        return (String)options.getOptions().get(0);
    }

    private void addArchivSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        if (this.hasArchiveFilterType(filterType)) {
            String defaultFilterOption = this.getFirstOptionValue((SelectedSearchFilterOptions)ArchiveSubFilter.NON_ARCHIVED.accept(SUBFILTER_TO_SELECTED_SEARCH_FILTER_OPTIONS));
            this.addSubfilter(definitions, ARCHIVE, SearchFilterSelectType.SINGLE, true, defaultFilterOption);
        }
    }

    private void addEntityStatusSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        EntityType entityType = this.getEntityTypeFromFilterType(filterType);
        if (entityType != null && this._searchConfigurationProvider.isShowEntityStatusSearchFilter(entityType)) {
            String defaultOptionValue = null;
            ImmutableSetMultimap entityStatusByArchivedFlag = this._searchConfigurationProvider.getEntityStatusByArchivedFlag(entityType);
            boolean hasArchivedStatus = !entityStatusByArchivedFlag.get((Object)Boolean.TRUE).isEmpty();
            ImmutableSet nonArchivedStatus = entityStatusByArchivedFlag.get((Object)Boolean.FALSE);
            if (hasArchivedStatus && !nonArchivedStatus.isEmpty()) {
                SelectedSearchFilterOptions entityStatusDefaultOption = (SelectedSearchFilterOptions)new EntityStatusSubFilter(entityType, nonArchivedStatus).accept(SUBFILTER_TO_SELECTED_SEARCH_FILTER_OPTIONS);
                defaultOptionValue = this.getFirstOptionValue(entityStatusDefaultOption);
            }
            this.addSubfilter(definitions, ENTITY_STATUS, SearchFilterSelectType.MULTI, true, defaultOptionValue);
        }
    }

    private void addPersonRoleSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        if (StaticFilterType.PROFILES.equals((Object)filterType)) {
            this.addSubfilter(definitions, PERSON_ROLE, SearchFilterSelectType.MULTI, true, null);
        }
    }

    private void addBlockSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType, AuthorizationContext authCtx) {
        if (!StaticFilterType.PROFILES.equals((Object)filterType) || !authCtx.may((Action)StaticAction.SEARCH_FILTER_BY_BLOCK_STATUS)) {
            return;
        }
        this.addSubfilter(definitions, BLOCKED, SearchFilterSelectType.SINGLE, true, "ALL");
    }

    private void addEntityDynamicAttributesSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        EntityType entityType = this.getEntityTypeFromFilterType(filterType);
        if (entityType == null) {
            return;
        }
        ImmutableList dynamicAttributes = this._entityConfigService.getDynamicAttributesForType(entityType);
        dynamicAttributes.stream().filter(arg_0 -> ((Predicate)DynamicAttributeConfig.IS_FACETTING_ENABLED).apply(arg_0)).forEach(attribute -> {
            boolean searchable = this._commonSearchService.isSearchFacetContainsSupported((SearchFacet)new EntityDynamicAttributeSearchFacet(attribute.getId(), entityType));
            boolean isProfileFilter = attribute.getInput() instanceof PersonSuggestInput;
            boolean optionTranslatable = attribute.getInput() instanceof SelectionInput;
            this.addSubfilter(definitions, KeyValue.join(ENTITY_DYNAMIC_ATTRIBUTE, entityType.name(), attribute.getId().getId()), ENTITY_DYNAMIC_ATTRIBUTE, searchable ? (isProfileFilter ? SearchFilterSelectType.MULTI_SEARCHABLE_PROFILE : SearchFilterSelectType.MULTI_SEARCHABLE) : SearchFilterSelectType.MULTI, optionTranslatable, entityType.name(), attribute.getId().getId(), null);
        });
    }

    private void addProfileAttributeSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        if (!StaticFilterType.PROFILES.equals((Object)filterType)) {
            return;
        }
        this._profileReadDataService.getAttributesConfiguration().getAllAttributeConfigurations().stream().filter(ProfileAttributeSearchType::isFacetable).forEach(attribute -> {
            boolean searchable = this._commonSearchService.isSearchFacetContainsSupported((SearchFacet)new ProfileAttributeSearchFacet(attribute.getName()));
            this.addSubfilter(definitions, KeyValue.join(PROFILE_ATTRIBUTE, attribute.getName()), PROFILE_ATTRIBUTE, searchable ? SearchFilterSelectType.MULTI_SEARCHABLE : SearchFilterSelectType.MULTI, TRANSLATABLE_OPTION_ATTRIBUTE_TYPES.contains((Object)attribute.getType()), null, attribute.getName(), null);
        });
    }

    private void addTagSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        boolean tagSubfilterAvailableForAll = StaticFilterType.ALL.equals((Object)filterType) && StaticSearchFacet.TAG.applyWithoutFilterType(this._searchConfigurationProvider);
        boolean tagSubfilterAvailableForFilterType = StaticSearchFacet.TAG.applyForFilterType(this._searchConfigurationProvider).apply((Object)filterType);
        if (tagSubfilterAvailableForAll || tagSubfilterAvailableForFilterType) {
            this.addSubfilter(definitions, TAG, SearchFilterSelectType.MULTI_SEARCHABLE, false, null);
        }
    }

    private void addFileTypeSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions, FilterType filterType) {
        boolean fileTypeSubfilterAvailableForCurrentFilterType = StaticSearchFacet.DRIVE_FILE_TYPE.applyForFilterType(this._searchConfigurationProvider).apply((Object)filterType);
        if (fileTypeSubfilterAvailableForCurrentFilterType) {
            this.addSubfilter(definitions, FILE_TYPE, SearchFilterSelectType.MULTI, true, null);
        }
    }

    private void addModificationDateSubFilter(ImmutableMap.Builder<String, SearchFilter> definitions) {
        this.addSubfilter(definitions, MODIFICATION_DATE, SearchFilterSelectType.SINGLE, true, "ALL");
    }

    @Override
    public ImmutableMap<String, SearchFilter> getSearchFilterDefinitions(FilterType filterType, AuthorizationContext authCtx) {
        ImmutableMap.Builder definitions = ImmutableMap.builder();
        this.addFilterType((ImmutableMap.Builder<String, SearchFilter>)definitions);
        this.addFileTypeSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addDateSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addArchivSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addEntityStatusSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addPersonRoleSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addBlockSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType, authCtx);
        this.addEntityDynamicAttributesSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addProfileAttributeSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addTagSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions, filterType);
        this.addModificationDateSubFilter((ImmutableMap.Builder<String, SearchFilter>)definitions);
        return definitions.build();
    }

    @Override
    public SearchFilter getContextSearchFilterDefinition(SearchContext selectedSearchContext) {
        if (selectedSearchContext.isMyContentContext()) {
            return new SearchFilter(MY_CONTENT, SearchFilterSelectType.SINGLE, DEFAULT_MY_CONTENT_SEARCH_CONTEXT.name());
        }
        return new SearchFilter("CONTEXT", SearchFilterSelectType.SINGLE, DEFAULT_SEARCH_CONTEXT.name());
    }

    @Override
    public FilterType getFilterTypeOf(Iterable<SelectedSearchFilterOptions> allSelectedOptions) {
        ImmutableMap<String, FilterType> optionValueToFilterTypeMap = this.getOptionValueToFilterTypeMap();
        return Streams.stream(allSelectedOptions).filter(selectedOptions -> TYPE.equals(selectedOptions.getId())).findFirst().map(selectedOptions -> selectedOptions.getOptions().stream().map(arg_0 -> ((ImmutableMap)optionValueToFilterTypeMap).get(arg_0)).filter(Objects::nonNull).findFirst().orElse(null)).orElse(null);
    }

    @Override
    public ImmutableSet<SubFilter> getSubfilterOf(Iterable<SelectedSearchFilterOptions> selectedOptions, FilterType mainFilter, AuthorizationContext authCtx) {
        if (mainFilter == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet selectedFilters = Sets.newHashSet();
        for (SelectedSearchFilterOptions options : selectedOptions) {
            if (options.getOptions().isEmpty()) continue;
            this.addSubfilter(mainFilter, options, (ImmutableSet.Builder<SubFilter>)builder);
            selectedFilters.add(options.getId());
        }
        ImmutableMap<String, SearchFilter> searchFilterDefinitions = this.getSearchFilterDefinitions(mainFilter, authCtx);
        ImmutableSet availableFilters = searchFilterDefinitions.keySet();
        for (SearchFilter filterDefinition : searchFilterDefinitions.values()) {
            String filterId;
            String defaultOptionValue = filterDefinition.getDefaultOptionValue();
            if (defaultOptionValue == null || selectedFilters.contains(filterId = filterDefinition.getId()) || !availableFilters.contains((Object)filterId)) continue;
            SelectedSearchFilterOptions defaultFilterOption = SelectedSearchFilterOptions.of(filterId, defaultOptionValue);
            this.addSubfilter(mainFilter, defaultFilterOption, (ImmutableSet.Builder<SubFilter>)builder);
        }
        return builder.build();
    }

    private void addSubfilter(FilterType mainFilter, SelectedSearchFilterOptions selectedOptions, ImmutableSet.Builder<SubFilter> builder) {
        ImmutableList<String> options = selectedOptions.getOptions();
        switch (selectedOptions.getId()) {
            case "CONTEXT": 
            case "MY_CONTENT": 
            case "TYPE": {
                break;
            }
            default: {
                this.addSubfilter(mainFilter, selectedOptions.getId(), options, builder);
            }
        }
    }

    private void addSubfilter(FilterType mainFilter, String searchFilterId, ImmutableList<String> options, ImmutableSet.Builder<SubFilter> builder) {
        if (options.isEmpty()) {
            return;
        }
        switch (searchFilterId) {
            case "DATE": {
                this.addSingleSelectSubfilter(arg_0 -> ((Function)DateSubFilter.FROM_NAME).apply(arg_0), options, builder);
                break;
            }
            case "PERSONROLE": {
                this.addSetSelectSubfilter(PersonRoleSubFilter::new, options, builder);
                break;
            }
            case "MODIFICATIONDATE": {
                this.addSingleSelectSubfilter(arg_0 -> ((Function)ModificationDateSubFilter.FROM_NAME).apply(arg_0), options, builder);
                break;
            }
            case "ARCHIVE": {
                this.addSingleSelectSubfilter(arg_0 -> ((Function)ArchiveSubFilter.FROM_NAME).apply(arg_0), options, builder);
                break;
            }
            case "BLOCKED": {
                this.addSingleSelectSubfilter(arg_0 -> ((Function)BlockSubFilter.FROM_NAME).apply(arg_0), options, builder);
                break;
            }
            case "TAG": {
                this.addSetSelectSubfilter(TagSubFilter::new, options, builder);
                break;
            }
            case "FILETYPE": {
                this.addSetSelectSubfilter(DriveFileTypeSubFilter::new, options, builder);
                break;
            }
            case "DOCUMENTFILETYPE": {
                this.addLongSetSelectSubfilter(DocumentFileTypeSubFilter::new, options, builder);
                break;
            }
            default: {
                this.addComplexSubfilter(mainFilter, searchFilterId, options, builder);
            }
        }
    }

    private void addComplexSubfilter(FilterType mainFilter, String complexSearchFilterId, ImmutableList<String> options, ImmutableSet.Builder<SubFilter> builder) {
        KeyValue splittedId = new KeyValue(complexSearchFilterId);
        String searchFilterId = splittedId.getKey();
        if (searchFilterId != null) {
            switch (searchFilterId) {
                case "ENTITYSTATUS": {
                    this.addEntityStatusSubfilter(mainFilter, options, builder);
                    break;
                }
                case "ENTITYDYNAMICATTRIBUTE": {
                    this.addEntityAttributeSubfilter(splittedId.getValue(), options, builder);
                    break;
                }
                case "PROFILEATTRIBUTE": {
                    this.addProfileAttributeSubfilter(splittedId.getValue(), options, builder);
                    break;
                }
            }
        }
    }

    private void addEntityAttributeSubfilter(String attributeKey, ImmutableList<String> options, ImmutableSet.Builder<SubFilter> builder) {
        KeyValue keyValue = new KeyValue(attributeKey);
        EntityType entityType = EntityType.getEntityTypeByName((String)keyValue.getKey());
        String attributeIdString = keyValue.getValue();
        if (attributeIdString != null && entityType != null && !options.isEmpty()) {
            DynamicAttributeId attributeId = new DynamicAttributeId(attributeIdString);
            builder.add((Object)new EntityDynamicAttributeSubFilter(attributeId, entityType, ImmutableSet.copyOf(options)));
        }
    }

    private void addProfileAttributeSubfilter(@Nullable String name, ImmutableList<String> options, ImmutableSet.Builder<SubFilter> builder) {
        if (name != null && !options.isEmpty()) {
            builder.add((Object)new ProfileAttributeSubFilter(name, ImmutableSet.copyOf(options)));
        }
    }

    private void addEntityStatusSubfilter(FilterType mainFilter, ImmutableList<String> options, ImmutableSet.Builder<SubFilter> builder) {
        EntityType entityType = (EntityType)FilterTypes.TO_ENTITY_TYPE.apply((Object)mainFilter);
        if (entityType != null) {
            ImmutableSet.Builder statusBuilder = ImmutableSet.builder();
            options.forEach(statusId -> {
                try {
                    statusBuilder.add((Object)new EntityStatusId(Long.parseLong(statusId)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            ImmutableSet status = statusBuilder.build();
            if (!status.isEmpty()) {
                builder.add((Object)new EntityStatusSubFilter(entityType, status));
            }
        }
    }

    private void addSetSelectSubfilter(java.util.function.Function<ImmutableSet<String>, SubFilter> factory, ImmutableList<String> options, ImmutableSet.Builder<SubFilter> builder) {
        SubFilter filter = factory.apply((ImmutableSet<String>)ImmutableSet.copyOf(options));
        if (filter != null) {
            builder.add((Object)filter);
        }
    }

    private void addLongSetSelectSubfilter(java.util.function.Function<ImmutableSet<Long>, SubFilter> factory, ImmutableList<String> options, ImmutableSet.Builder<SubFilter> builder) {
        ImmutableSet.Builder longOptions = ImmutableSet.builder();
        options.forEach(option -> {
            try {
                longOptions.add((Object)Long.valueOf(option));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        SubFilter filter = factory.apply((ImmutableSet<Long>)longOptions.build());
        if (filter != null) {
            builder.add((Object)filter);
        }
    }

    private void addSingleSelectSubfilter(java.util.function.Function<String, SubFilter> resolver, ImmutableList<String> selectedOptions, ImmutableSet.Builder<SubFilter> builder) {
        SubFilter filter = selectedOptions.stream().findFirst().map(resolver::apply).orElse(null);
        if (filter != null) {
            builder.add((Object)filter);
        }
    }

    @Override
    public ImmutableList<SelectedSearchFilterOptions> getSelectedSearchFilterOptions(SearchParameters searchParameters, AuthorizationContext authCtx) {
        FilterType mainFilter = searchParameters.getFilterTypeOrAll();
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet selectedFilters = Sets.newHashSet();
        SelectedSearchFilterOptions selectedFilterTypeOption = SelectedSearchFilterOptions.of(this.transformFilterTypeToFilterOption(mainFilter));
        builder.add((Object)selectedFilterTypeOption);
        selectedFilters.add(selectedFilterTypeOption.getId());
        for (SubFilter subFilter : searchParameters.getSubfilter()) {
            SelectedSearchFilterOptions selectedSearchFilterOptions = (SelectedSearchFilterOptions)subFilter.accept(SUBFILTER_TO_SELECTED_SEARCH_FILTER_OPTIONS);
            if (selectedSearchFilterOptions == null) continue;
            builder.add((Object)selectedSearchFilterOptions);
            selectedFilters.add(selectedSearchFilterOptions.getId());
        }
        this.addMissingNonRestrictingDefaultValues(mainFilter, (ImmutableList.Builder<SelectedSearchFilterOptions>)builder, selectedFilters, authCtx);
        return builder.build();
    }

    private void addMissingNonRestrictingDefaultValues(FilterType mainFilter, ImmutableList.Builder<SelectedSearchFilterOptions> builder, Set<String> selectedFilters, AuthorizationContext authCtx) {
        ImmutableMap<String, SearchFilter> filterDefinitions = this.getSearchFilterDefinitions(mainFilter, authCtx);
        for (SearchFilter filter : filterDefinitions.values()) {
            boolean hasRestrictingDefaultOptionValue;
            String defaultOptionValue = filter.getDefaultOptionValue();
            boolean bl = hasRestrictingDefaultOptionValue = defaultOptionValue != null && !"ALL".equals(defaultOptionValue);
            String filterId = filter.getId();
            if (selectedFilters.contains(filterId) || !hasRestrictingDefaultOptionValue) continue;
            builder.add((Object)SelectedSearchFilterOptions.of(filterId, "ALL"));
        }
    }

    @Override
    public void addOptionsAndCountToSearchFilters(SearchResult<FederatedSearchResultEntry> searchResult, ImmutableMap<String, SearchFilter> searchFilters, SearchFilter contextFilter, SearchParameters searchParameters) {
        searchResult.getFacetCounts().entrySet().stream().flatMap(entry -> (Stream)((SearchFacet)entry.getKey()).accept((SearchFacet.SearchFacetVisitor)new SearchFacetToFilterOptionVisitor((SearchFacetCounts)entry.getValue()))).forEach(filterOption -> {
            String filterId = filterOption.getFilterId();
            SearchFilter searchFilter = (SearchFilter)searchFilters.get((Object)filterId);
            if (searchFilter != null) {
                searchFilter.addOption((SearchFilterOption)filterOption);
            } else if (filterId.equals(contextFilter.getId())) {
                contextFilter.addOption((SearchFilterOption)filterOption);
            }
        });
    }

    @Override
    public ImmutableList<String> getAvailableSortTypes(SearchParameters searchParameters) {
        return (ImmutableList)Arrays.stream(SortType.values()).filter(st -> searchParameters.isSortTypeSupported(this._searchConfigurationProvider, st)).map(Enum::name).collect(ImmutableList.toImmutableList());
    }

    @Override
    public SearchFacetParameters getSearchFacetParameters(@Nullable SearchFilterOptionRequest searchFilterOptionRequest, ImmutableMap<String, SearchFilter> searchFilters) {
        if (searchFilterOptionRequest == null) {
            return StaticSearchFacetParameters.DEFAULT_FACETS;
        }
        SearchFilter filter = (SearchFilter)searchFilters.get((Object)searchFilterOptionRequest.getFilterId());
        if (filter == null) {
            return StaticSearchFacetParameters.DEFAULT_FACETS;
        }
        String searchString = searchFilterOptionRequest.getSearchString();
        switch (filter.getName()) {
            case "TAG": {
                return new SearchFacetContainsParameters((SearchFacet)StaticSearchFacet.TAG, searchString);
            }
            case "ENTITYDYNAMICATTRIBUTE": {
                String type = filter.getDocumentType();
                String entityAttribute = filter.getDocumentAttribute();
                if (type == null || entityAttribute == null) {
                    return StaticSearchFacetParameters.DEFAULT_FACETS;
                }
                EntityType entityType = EntityType.valueOf((String)type);
                DynamicAttributeId attributeId = new DynamicAttributeId(entityAttribute);
                return new SearchFacetContainsParameters((SearchFacet)new EntityDynamicAttributeSearchFacet(attributeId, entityType), searchString);
            }
            case "PROFILEATTRIBUTE": {
                String profileAttribute = filter.getDocumentAttribute();
                if (profileAttribute == null) {
                    return StaticSearchFacetParameters.DEFAULT_FACETS;
                }
                return new SearchFacetContainsParameters((SearchFacet)new ProfileAttributeSearchFacet(profileAttribute), searchString);
            }
        }
        return StaticSearchFacetParameters.DEFAULT_FACETS;
    }

    @ParametersAreNonnullByDefault
    private final class SearchFacetToFilterOptionVisitor
    implements SearchFacet.SearchFacetVisitor<Stream<SearchFilterOption>> {
        private final SearchFacetCounts _counts;

        public SearchFacetToFilterOptionVisitor(SearchFacetCounts counts) {
            this._counts = counts;
        }

        @Nonnull
        private Stream<SearchFilterOption> createFilterOptionForValue(String filterId, String optionValue, SearchFacet facet) {
            return this.createFilterOptionForValue(filterId, optionValue, null, optionValue, facet);
        }

        @Nonnull
        private Stream<SearchFilterOption> createFilterOptionForValue(String filterId, String optionValue, @Nullable String optionType, String translationKey, SearchFacet facet) {
            return ((Stream)this._counts.accept(SEARCH_FACET_COUNTS_TO_OPTION_COUNTS)).filter(optionCount -> optionCount.getValue().equals(facet.getFacetName())).map(optionCount -> new SearchFilterOption(filterId, optionValue, optionType, translationKey, optionCount.getCount()));
        }

        @Nonnull
        private Stream<SearchFilterOption> createFilterOptionsFromCounts(String filterId, @Nullable String optionType) {
            return ((Stream)this._counts.accept(SEARCH_FACET_COUNTS_TO_OPTION_COUNTS)).map(optionCount -> new SearchFilterOption(filterId, optionCount.getValue(), optionType, optionCount.getTranslationKey(), optionCount.getCount()));
        }

        public Stream<SearchFilterOption> visitDateFuture(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.DATE, DateSubFilter.FUTURE.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitDatePast(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.DATE, DateSubFilter.PAST.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitDateAll(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.DATE, "ALL", searchFacet);
        }

        public Stream<SearchFilterOption> visitDocumentFileType(SearchFacet searchFacet) {
            return this.createFilterOptionsFromCounts(SearchFilterServiceImpl.DOCUMENT_FILE_TYPE, null);
        }

        public Stream<SearchFilterOption> visitModifyDateAll(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MODIFICATION_DATE, "ALL", searchFacet);
        }

        public Stream<SearchFilterOption> visitModifyDateLastHour(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MODIFICATION_DATE, ModificationDateSubFilter.LAST_HOUR.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitModifyDateLast24Hours(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MODIFICATION_DATE, ModificationDateSubFilter.LAST_24HOURS.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitModifyDateLastWeek(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MODIFICATION_DATE, ModificationDateSubFilter.LAST_WEEK.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitModifyDateLastMonth(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MODIFICATION_DATE, ModificationDateSubFilter.LAST_MONTH.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitModifyDateLastYear(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MODIFICATION_DATE, ModificationDateSubFilter.LAST_YEAR.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitDynamicEntityAttribute(EntityDynamicAttributeSearchFacet searchFacet) {
            return this.createFilterOptionsFromCounts(KeyValue.join(SearchFilterServiceImpl.ENTITY_DYNAMIC_ATTRIBUTE, searchFacet.getEntityType().name(), searchFacet.getDynamicAttributeId().getId()), searchFacet.getEntityType().name());
        }

        public Stream<SearchFilterOption> visitArchiveAll(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.ARCHIVE, "ALL", searchFacet);
        }

        public Stream<SearchFilterOption> visitArchiveNonArchived(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.ARCHIVE, ArchiveSubFilter.NON_ARCHIVED.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitArchiveArchived(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.ARCHIVE, ArchiveSubFilter.ARCHIVED.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitBlockAll(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.BLOCKED, "ALL", searchFacet);
        }

        public Stream<SearchFilterOption> visitBlockNonBlocked(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.BLOCKED, BlockSubFilter.NON_BLOCKED.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitBlockBlocked(SearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.BLOCKED, BlockSubFilter.BLOCKED.name(), searchFacet);
        }

        public Stream<SearchFilterOption> visitEntityStatus(EntityStatusSearchFacet searchFacet) {
            return this.createFilterOptionsFromCounts(SearchFilterServiceImpl.ENTITY_STATUS, null);
        }

        public Stream<SearchFilterOption> visitAllContent(SearchContextFacet.AllContentSearchFacet searchFacet) {
            return this.createFilterOptionForValue("CONTEXT", SearchContext.ENTIRE_PLATFORM.name(), (SearchFacet)searchFacet);
        }

        public Stream<SearchFilterOption> visitEntityContext(SearchContextFacet.EntityBasedSearchContextFacet searchFacet) {
            return searchFacet.isIncludeSubentities() ? this.createFilterOptionForValue("CONTEXT", SearchContext.ENTITY_AND_SUBENTITIES.name(), (SearchFacet)searchFacet) : this.createFilterOptionForValue("CONTEXT", SearchContext.ENTITY.name(), (SearchFacet)searchFacet);
        }

        public Stream<SearchFilterOption> visitMyContent(SearchContextFacet.MyContentSearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MY_CONTENT, SearchContext.MY_CONTENT.name(), (SearchFacet)searchFacet);
        }

        public Stream<SearchFilterOption> visitMySubscriptions(SearchContextFacet.MySubscriptionsSearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MY_CONTENT, SearchContext.SUBSCRIPTION.name(), (SearchFacet)searchFacet);
        }

        public Stream<SearchFilterOption> visitMemberRole(SearchContextFacet.MemberRoleSearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MY_CONTENT, SearchContext.MEMBER.name(), (SearchFacet)searchFacet);
        }

        public Stream<SearchFilterOption> visitAdminRole(SearchContextFacet.AdminRoleSearchFacet searchFacet) {
            return this.createFilterOptionForValue(SearchFilterServiceImpl.MY_CONTENT, SearchContext.ADMIN.name(), (SearchFacet)searchFacet);
        }

        public Stream<SearchFilterOption> visitPersonRole(SearchFacet searchFacet) {
            return this.createFilterOptionsFromCounts(SearchFilterServiceImpl.PERSON_ROLE, null);
        }

        public Stream<SearchFilterOption> visitTag(StaticSearchFacet searchFacet) {
            return this.createFilterOptionsFromCounts(SearchFilterServiceImpl.TAG, null);
        }

        public Stream<SearchFilterOption> visitDriveFileType(StaticSearchFacet searchFacet) {
            return this.createFilterOptionsFromCounts(SearchFilterServiceImpl.FILE_TYPE, null);
        }

        public Stream<SearchFilterOption> visitFilterTypeSearchFacet(FilterTypeSearchFacet searchFacet) {
            FilterTypeCountType countType;
            FilterType filterType = searchFacet.getFilterType();
            if (searchFacet instanceof EntityFilterTypeSearchFacet && FilterTypeCountType.PAST.equals((Object)(countType = ((EntityFilterTypeSearchFacet)searchFacet).getCountType()))) {
                return Stream.empty();
            }
            SearchFilterOption option = SearchFilterServiceImpl.this.transformFilterTypeToFilterOption(filterType);
            return this.createFilterOptionForValue(SearchFilterServiceImpl.TYPE, option.getOptionValue(), option.getOptionType(), option.getTranslationKey(), (SearchFacet)searchFacet);
        }

        public Stream<SearchFilterOption> visitProfileAttribute(ProfileAttributeSearchFacet searchFacet) {
            return ((Stream)this._counts.accept(SEARCH_FACET_COUNTS_TO_OPTION_COUNTS)).map(optionCount -> new SearchFilterOption(KeyValue.join(SearchFilterServiceImpl.PROFILE_ATTRIBUTE, searchFacet.getName()), optionCount.getValue(), null, optionCount.getCount()));
        }

        public Stream<SearchFilterOption> visitDriveDocumentType(SearchFacet searchFacet) {
            return this.createFilterOptionsFromCounts(SearchFilterServiceImpl.DOCUMENT_FILE_TYPE, null);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class OptionCount {
        private final String _value;
        private final String _translationKey;
        private final long _count;

        public OptionCount(String value, long count) {
            this(value, value, count);
        }

        public OptionCount(String value, String translationKey, long count) {
            this._value = value;
            this._translationKey = translationKey;
            this._count = count;
        }

        @Nonnull
        public String getValue() {
            return this._value;
        }

        @Nonnull
        public String getTranslationKey() {
            return this._translationKey;
        }

        public long getCount() {
            return this._count;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class KeyValue {
        private final String _key;
        private final String _value;

        public KeyValue(@Nullable String key, @Nullable String value) {
            this._key = key;
            this._value = value;
        }

        public KeyValue(@Nullable String text) {
            if (text == null) {
                this._key = null;
                this._value = null;
            } else {
                int indexOf = text.indexOf(SearchFilterServiceImpl.SEPARATOR);
                this._key = indexOf <= 0 ? text : text.substring(0, indexOf);
                this._value = indexOf > 0 ? text.substring(indexOf + 1) : null;
            }
        }

        @CheckForNull
        public String getKey() {
            return this._key;
        }

        @CheckForNull
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this._key).add("value", (Object)this._value).toString();
        }

        @Nonnull
        public static String join(String ... parts) {
            return Joiner.on((String)SearchFilterServiceImpl.SEPARATOR).skipNulls().join((Object[])parts);
        }
    }
}

