/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.api.controller;

import com.google.common.collect.ImmutableList;
import de.justsoftware.app.search.business.StoredSearchService;
import de.justsoftware.app.search.model.StoredSearchFilter;
import de.justsoftware.app.search.model.StoredSearchFilterCreateModel;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/search/api/v1/storedSearch"})
@Api(tags={"StoredSearch"})
public class StoredSearchController {
    private final StoredSearchService _storedSearchService;

    @Autowired
    public StoredSearchController(StoredSearchService storedSearchService) {
        this._storedSearchService = storedSearchService;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="get the stored search filters of the current user", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns the stored search filters"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ImmutableList<StoredSearchFilter> getStoredSearchFilter(@AuthorizedContext AuthorizationContext authCtx) {
        return this._storedSearchService.getStoredSearchFilter((AuthorizationContextWithUserId)authCtx);
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Create a new search filter for the current user", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns  the new stored search filters"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ImmutableList<StoredSearchFilter> storeSearchFilter(@RequestBody(required=false) StoredSearchFilterCreateModel searchFilter, @AuthorizedContext AuthorizationContext authCtx) {
        this._storedSearchService.createStoredSearchFilter((AuthorizationContextWithUserId)authCtx, searchFilter.getName(), searchFilter.getFilter());
        return this.getStoredSearchFilter(authCtx);
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.DELETE}, path={"/{searchFilterId}"}, produces={"application/json"})
    @ApiOperation(value="Delete the stored search filter with the given searchFilterId", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns  the new stored search filters"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ImmutableList<StoredSearchFilter> deleteStoredSearchFilter(@PathVariable(value="searchFilterId") long searchFilterId, @AuthorizedContext AuthorizationContext authCtx) {
        this._storedSearchService.deleteStoredSearchFilter((AuthorizationContextWithUserId)authCtx, searchFilterId);
        return this.getStoredSearchFilter(authCtx);
    }
}

