/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.api.controller;

import de.justsoftware.app.search.business.SearchService;
import de.justsoftware.app.search.model.SearchRequest;
import de.justsoftware.app.search.model.SearchRequestAndResult;
import de.justsoftware.app.search.model.SearchResult;
import de.justsoftware.app.search.model.SuggestResults;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="searchApiController")
@ParametersAreNonnullByDefault
@RequestMapping(path={"/search/api/v1/search"})
@Api(tags={"Search"})
public class SearchController {
    private final SearchService _searchService;

    @Autowired
    public SearchController(SearchService searchService) {
        this._searchService = searchService;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="execute a search with search string and filter options for the current user", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns the search results"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public SearchResult doSearch(@RequestBody SearchRequest searchRequest, @AuthorizedContext AuthorizationContext authCtx) {
        return this._searchService.doSearch(searchRequest, authCtx);
    }

    @Nonnull
    @RequestMapping(value={"/request"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Transforms the given search token to the corresponding search request and executes that search for the current user", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns the search results"), @ApiResponse(code=500, message="fatal error -  some internal error")})
    public SearchRequestAndResult doSearchForToken(@RequestParam(value="searchToken") String searchToken, @AuthorizedContext AuthorizationContext authCtx) throws TokenUtil.TokenParseException {
        return this._searchService.doSearchForToken(searchToken, authCtx);
    }

    @Nonnull
    @RequestMapping(value={"/suggest"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Suggests elements for the given search request", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns the suggest results"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public SuggestResults suggest(@RequestBody SearchRequest searchRequest, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="count", required=false, defaultValue="10") int count, @AuthorizedContext AuthorizationContext authCtx) {
        return this._searchService.suggest(searchRequest, offset, count, authCtx);
    }
}

